/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodDeclarations;

public class ReplicationQueue {
    private static Log log = LogFactory.getLog(ReplicationQueue.class);
    private CacheImpl cache = null;
    private long interval = 5000L;
    private long max_elements = 500L;
    private final List<MethodCall> elements = new LinkedList<MethodCall>();
    private Timer timer = null;
    private MyTask task = null;

    public ReplicationQueue() {
    }

    public ReplicationQueue(CacheImpl cache, long interval, long max_elements) {
        this.cache = cache;
        this.interval = interval;
        this.max_elements = max_elements;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
        this.stop();
        this.start();
    }

    public long getMax_elements() {
        return this.max_elements;
    }

    public void setMax_elements(long max_elements) {
        this.max_elements = max_elements;
    }

    public synchronized void start() {
        if (this.interval > 0L) {
            if (this.task == null) {
                this.task = new MyTask();
            }
            if (this.timer == null) {
                this.timer = new Timer(true);
                this.timer.schedule((TimerTask)this.task, 500L, this.interval);
            }
        }
    }

    public synchronized void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(MethodCall job) {
        if (job == null) {
            throw new NullPointerException("job is null");
        }
        List<MethodCall> list = this.elements;
        synchronized (list) {
            this.elements.add(job);
            if ((long)this.elements.size() >= this.max_elements) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ArrayList<MethodCall> l;
        List<MethodCall> list = this.elements;
        synchronized (list) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("flush(): flushing repl queue (num elements=" + this.elements.size() + ")"));
            }
            l = new ArrayList<MethodCall>(this.elements);
            this.elements.clear();
        }
        if (l.size() > 0) {
            try {
                this.cache.getRPCManager().callRemoteMethods(null, MethodDeclarations.replicateAllMethod, new Object[]{l}, false, true, 5000L);
            }
            catch (Throwable t) {
                log.error((Object)("failed replicating " + l.size() + " elements in replication queue"), t);
            }
        }
    }

    class MyTask
    extends TimerTask {
        MyTask() {
        }

        public void run() {
            ReplicationQueue.this.flush();
        }
    }
}

