/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.misc.TestingUtil;
import org.jgroups.Address;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class BuddyReplicationWithCacheLoaderTest
extends BuddyReplicationTestsBase {
    protected Fqn<String> fqn = Fqn.fromString((String)"/test/br/four/level");
    protected String key = "key";
    protected String value = "value";
    protected boolean passivation = false;

    private CacheLoader[] getLoaders(List<CacheImpl<Object, Object>> caches) {
        CacheLoader[] retVal = new CacheLoader[caches.size()];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = caches.get(i).getCacheLoaderManager().getCacheLoader();
        }
        return retVal;
    }

    public void testWithDataGravitationDefault() throws Exception {
        this.dataGravitationDefaultTest(true);
    }

    public void testWithDataGravitationDefaultNoAuto() throws Exception {
        this.dataGravitationDefaultTest(false);
    }

    private void dataGravitationDefaultTest(boolean autoGravitate) throws Exception {
        int i;
        this.caches = this.createCachesWithCacheLoader(3, autoGravitate, true, this.passivation);
        TestingUtil.sleepThread(1000L);
        CacheLoader[] loaders = this.getLoaders(this.caches);
        for (i = 0; i < 3; ++i) {
            loaders[i].remove(Fqn.ROOT);
        }
        for (i = 0; i < 3; ++i) {
            System.out.println(i + ": " + loaders[i].get(this.fqn));
        }
        ((CacheImpl)this.caches.get(0)).put(this.fqn, (Object)this.key, (Object)this.value);
        this.assertNoLocks(this.caches);
        for (i = 0; i < 3; ++i) {
            System.out.println(i + ": " + loaders[i].get(this.fqn));
        }
        this.dumpCacheContents(this.caches);
        if (!autoGravitate) {
            ((CacheImpl)this.caches.get(2)).getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
        }
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheImpl)this.caches.get(2)).get(this.fqn, (Object)this.key));
        this.assertNoLocks(this.caches);
        for (i = 0; i < 3; ++i) {
            System.out.println(i + ": " + loaders[i].get(this.fqn));
        }
        this.dumpCacheContents(this.caches);
        AssertJUnit.assertTrue((String)"should not exist in cache0", (!((CacheImpl)this.caches.get(0)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache1", (!((CacheImpl)this.caches.get(1)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in cache2", (boolean)((CacheImpl)this.caches.get(2)).exists(this.fqn));
        AssertJUnit.assertTrue((String)"should not exist in loader0", (!loaders[0].exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loader1", (!loaders[1].exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in loader2", (boolean)(this.passivation ? !loaders[2].exists(this.fqn) : loaders[2].exists(this.fqn)));
        Fqn b1 = new Fqn(new Fqn(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{BuddyManager.getGroupNameFromAddress((Object)((CacheImpl)this.caches.get(0)).getLocalAddress())}), this.fqn.peekElements());
        Fqn b2 = new Fqn(new Fqn(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{BuddyManager.getGroupNameFromAddress((Object)((CacheImpl)this.caches.get(2)).getLocalAddress())}), this.fqn.peekElements());
        AssertJUnit.assertTrue((String)"should not exist in cache0", (!((CacheImpl)this.caches.get(0)).exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in cache0", (boolean)((CacheImpl)this.caches.get(0)).exists(b2));
        AssertJUnit.assertTrue((String)"should not exist in cache1", (!((CacheImpl)this.caches.get(1)).exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache1", (!((CacheImpl)this.caches.get(1)).exists(b2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache2", (!((CacheImpl)this.caches.get(2)).exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache2", (!((CacheImpl)this.caches.get(2)).exists(b2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loader0", (!loaders[0].exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in loader0", (boolean)(this.passivation ? !loaders[0].exists(b2) : loaders[0].exists(b2)));
        AssertJUnit.assertTrue((String)"should not exist in loaders1", (!loaders[1].exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loaders1", (!loaders[1].exists(b2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loaders2", (!loaders[2].exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loaders2", (!loaders[2].exists(b2) ? 1 : 0) != 0);
    }

    public void testWithDataGravitationEvictOnFind() throws Exception {
        this.dataGravitationEvictionTest(true);
    }

    public void testWithDataGravitationEvictOnFindNoAuto() throws Exception {
        this.dataGravitationEvictionTest(false);
    }

    private void dataGravitationEvictionTest(boolean autoGravitate) throws Exception {
        this.caches = this.createCachesWithCacheLoader(3, autoGravitate, false, this.passivation);
        CacheLoader[] loaders = this.getLoaders(this.caches);
        Fqn b1 = BuddyManager.getBackupFqn((Address)((CacheImpl)this.caches.get(0)).getLocalAddress(), this.fqn);
        Fqn b2 = BuddyManager.getBackupFqn((Address)((CacheImpl)this.caches.get(2)).getLocalAddress(), this.fqn);
        ((CacheImpl)this.caches.get(0)).put(this.fqn, (Object)this.key, (Object)this.value);
        Map m = loaders[1].get(b1);
        System.out.println("From loader:  " + m);
        System.out.println("*** About do cause a gravitation event ... ");
        if (!autoGravitate) {
            ((CacheImpl)this.caches.get(2)).getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
        }
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheImpl)this.caches.get(2)).get(this.fqn, (Object)this.key));
        AssertJUnit.assertTrue((String)"should not exist in cache0", (!((CacheImpl)this.caches.get(0)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache1", (!((CacheImpl)this.caches.get(1)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in cache2", (boolean)((CacheImpl)this.caches.get(2)).exists(this.fqn));
        AssertJUnit.assertTrue((String)"should exist in loader0", (boolean)loaders[0].exists(this.fqn));
        AssertJUnit.assertTrue((String)"should not exist in loader1", (!loaders[1].exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in loader2", (boolean)(this.passivation ? !loaders[2].exists(this.fqn) : loaders[2].exists(this.fqn)));
        AssertJUnit.assertTrue((String)"should not exist in cache0", (!((CacheImpl)this.caches.get(0)).exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in cache0", (boolean)((CacheImpl)this.caches.get(0)).exists(b2));
        AssertJUnit.assertTrue((String)"should not exist in cache1", (!((CacheImpl)this.caches.get(1)).exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache1", (!((CacheImpl)this.caches.get(1)).exists(b2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache2", (!((CacheImpl)this.caches.get(2)).exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache2", (!((CacheImpl)this.caches.get(2)).exists(b2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loader0", (!loaders[0].exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in loader0", (boolean)(this.passivation ? !loaders[0].exists(b2) : loaders[0].exists(b2)));
        AssertJUnit.assertTrue((String)"should exist in loaders1", (boolean)loaders[1].exists(b1));
        AssertJUnit.assertTrue((String)"should not exist in loaders1", (!loaders[1].exists(b2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loaders2", (!loaders[2].exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loaders2", (!loaders[2].exists(b2) ? 1 : 0) != 0);
    }

    public void testLocalGravitationOfEvictedNodes() throws Exception {
        CacheImpl<Object, Object> cache1 = this.createCacheWithCacheLoader(true, true, this.passivation, true, false);
        Configuration cfg1 = cache1.getConfiguration();
        this.configureEviction(cfg1);
        Configuration cfg0 = cfg1.clone();
        CacheImpl cache0 = (CacheImpl)DefaultCacheFactory.getInstance().createCache(cfg0, false);
        if (this.caches == null) {
            this.caches = new ArrayList();
        }
        this.caches.add(cache0);
        this.caches.add(cache1);
        cache0.start();
        cache1.start();
        TestingUtil.blockUntilViewsReceived(this.caches.toArray(new Cache[this.caches.size()]), (long)(5000 * this.caches.size()));
        TestingUtil.sleepThread(this.getSleepTimeout());
        Fqn foo = Fqn.fromString((String)"/foo");
        Fqn backupFoo = BuddyManager.getBackupFqn((Address)cache0.getLocalAddress(), (Fqn)foo);
        cache0.put(foo, (Object)"key", (Object)"value");
        assert (cache0.exists(foo)) : "Data should exist in data owner";
        assert (cache1.exists(backupFoo)) : "Buddy should have data";
        TestingUtil.sleepThread(3050L);
        assert (!cache0.exists(foo)) : "Data should have evicted in data owner";
        assert (!cache1.exists(backupFoo)) : "Buddy should have data evicted";
        assert (cache0.getCacheLoader().get(foo) != null) : "Should exist in data owner's cache loader";
        assert (cache1.getCacheLoader().get(backupFoo) != null) : "Should exist in buddy's loader";
        AssertJUnit.assertEquals((String)"Passivated value available from buddy", (Object)"value", (Object)cache1.get(foo, (Object)"key"));
    }

    public void testRemoteGravitationOfEvictedNodes() throws Exception {
        CacheImpl<Object, Object> cache0 = this.createCacheWithCacheLoader(true, true, this.passivation, true, false);
        Configuration cfg0 = cache0.getConfiguration();
        this.configureEviction(cfg0);
        Configuration cfg1 = cfg0.clone();
        CacheImpl cache1 = (CacheImpl)DefaultCacheFactory.getInstance().createCache(cfg1, false);
        Configuration cfg2 = cfg0.clone();
        CacheImpl cache2 = (CacheImpl)DefaultCacheFactory.getInstance().createCache(cfg2, false);
        if (this.caches == null) {
            this.caches = new ArrayList();
        }
        this.caches.add(cache0);
        this.caches.add(cache1);
        this.caches.add(cache2);
        cache0.start();
        cache1.start();
        cache2.start();
        TestingUtil.blockUntilViewsReceived(this.caches.toArray(new Cache[this.caches.size()]), 600000L);
        TestingUtil.sleepThread(this.getSleepTimeout());
        assert (cache0.getBuddyManager().getBuddyAddresses().contains(cache1.getLocalAddress())) : "Cache1 should be cache0's buddy!";
        Fqn foo = Fqn.fromString((String)"/foo");
        Fqn backupFoo = BuddyManager.getBackupFqn((Address)cache0.getLocalAddress(), (Fqn)foo);
        cache0.put(foo, (Object)"key", (Object)"value");
        assert (cache0.exists(foo)) : "Data should exist in data owner";
        assert (cache1.exists(backupFoo)) : "Buddy should have data";
        TestingUtil.sleepThread(3050L);
        assert (!cache0.exists(foo)) : "Data should have evicted in data owner";
        assert (!cache1.exists(backupFoo)) : "Buddy should have data evicted";
        assert (cache0.getCacheLoader().get(foo) != null) : "Should exist in data owner's loader";
        assert (cache1.getCacheLoader().get(backupFoo) != null) : "Should exist in buddy's loader";
        AssertJUnit.assertEquals((String)"Passivated value available from buddy", (Object)"value", (Object)cache2.get(foo, (Object)"key"));
    }

    private void configureEviction(Configuration cfg) {
        EvictionConfig ec = new EvictionConfig();
        ec.setWakeupIntervalSeconds(1);
        EvictionRegionConfig erc = new EvictionRegionConfig();
        erc.setRegionName("/_default_");
        LRUConfiguration epc = new LRUConfiguration();
        epc.setMaxAgeSeconds(2);
        epc.setTimeToLiveSeconds(1);
        epc.setMaxNodes(1);
        erc.setEvictionPolicyConfig((EvictionPolicyConfig)epc);
        ArrayList<EvictionRegionConfig> ercs = new ArrayList<EvictionRegionConfig>();
        ercs.add(erc);
        ec.setEvictionRegionConfigs(ercs);
        cfg.setEvictionConfig(ec);
    }
}

