/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.Set;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.TestListener;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullStackInterceptorTest
extends AbstractOptimisticTestCase {
    private Log log = LogFactory.getLog(FullStackInterceptorTest.class);
    private int groupIncreaser = 0;

    public void testLocalTransaction() throws Exception {
        CacheImpl<Object, Object> cache = this.createCacheWithListener();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testNoLocalTransaction() throws Exception {
        TestListener listener = new TestListener();
        CacheImpl<Object, Object> cache = this.createCacheWithListener(listener);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/one"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/one/two"))).getLock().isLocked());
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one")).getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertEquals((int)2, (int)listener.getNodesAdded());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testSingleInstanceCommit() throws Exception {
        ++this.groupIncreaser;
        CacheImpl<Object, Object> cache = this.createCacheWithListener();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/one"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/one/two"))).getLock().isLocked());
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one")).getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testSingleInstanceRollback() throws Exception {
        ++this.groupIncreaser;
        CacheImpl<Object, Object> cache = this.createSyncReplicatedCache();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.rollback();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertEquals((boolean)false, (boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNull((Object)cache.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testSingleInstanceDuplicateCommit() throws Exception {
        ++this.groupIncreaser;
        CacheImpl<Object, Object> cache = this.createSyncReplicatedCache();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        boolean fail = false;
        try {
            mgr.commit();
        }
        catch (Exception e) {
            fail = true;
        }
        AssertJUnit.assertEquals((boolean)true, (boolean)fail);
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/one"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/one/two"))).getLock().isLocked());
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one")).getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testValidationFailCommit() throws Exception {
        ++this.groupIncreaser;
        CacheImpl<Object, Object> cache = this.createSyncReplicatedCache();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.suspend();
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        SamplePojo pojo2 = new SamplePojo(22, "test2");
        cache.put("/one/two", (Object)"key1", (Object)pojo2);
        mgr.commit();
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        mgr.resume(tx);
        boolean fail = false;
        try {
            mgr.commit();
        }
        catch (Exception e) {
            fail = true;
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertEquals((boolean)true, (boolean)fail);
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/one"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/one/two"))).getLock().isLocked());
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one")).getChild((Object)"two"));
        AssertJUnit.assertEquals((Object)pojo2, (Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void test2InstanceCommit() throws Exception {
        ++this.groupIncreaser;
        CacheImpl<Object, Object> cache = this.createSyncReplicatedCache();
        CacheImpl<Object, Object> cache2 = this.createSyncReplicatedCache();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/one"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/one/two"))).getLock().isLocked());
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one")).getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache2.get(Fqn.fromString((String)"/"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache2.get(Fqn.fromString((String)"/one"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache2.get(Fqn.fromString((String)"/one/two"))).getLock().isLocked());
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/one")).getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    public void test2InstanceRemove() throws Exception {
        ++this.groupIncreaser;
        CacheImpl<Object, Object> cache = this.createSyncReplicatedCache();
        CacheImpl<Object, Object> cache2 = this.createSyncReplicatedCache();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/one"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/one/two"))).getLock().isLocked());
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one")).getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache2.get(Fqn.fromString((String)"/"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache2.get(Fqn.fromString((String)"/one"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache2.get(Fqn.fromString((String)"/one/two"))).getLock().isLocked());
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/one")).getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        cache.remove("/one/two");
        this.log.debug((Object)("  C1 " + cache.get("/one/two")));
        this.log.debug((Object)("  C2 " + cache2.get("/one/two")));
        AssertJUnit.assertEquals((boolean)false, (boolean)cache.exists("/one/two"));
        AssertJUnit.assertEquals((boolean)false, (boolean)cache2.exists("/one/two"));
        AssertJUnit.assertEquals(null, (Object)cache.get("/one/two", (Object)"key1"));
        AssertJUnit.assertEquals(null, (Object)cache2.get("/one/two", (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    public void testValidationFailCommit2Instances() throws Exception {
        ++this.groupIncreaser;
        CacheImpl<Object, Object> cache = this.createSyncReplicatedCache();
        CacheImpl<Object, Object> cache2 = this.createSyncReplicatedCache();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.suspend();
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        GlobalTransaction gtx = cache.getCurrentTransaction(tx);
        TransactionTable table = cache.getTransactionTable();
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        AssertJUnit.assertEquals((int)3, (int)entry.getTransactionWorkSpace().getNodes().size());
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        SamplePojo pojo2 = new SamplePojo(22, "test2");
        cache2.put("/one/two", (Object)"key1", (Object)pojo2);
        mgr.commit();
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        mgr.resume(tx);
        boolean fail = false;
        try {
            mgr.commit();
        }
        catch (Exception e) {
            fail = true;
        }
        AssertJUnit.assertEquals((boolean)true, (boolean)fail);
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertEquals((int)0, (int)entry.getTransactionWorkSpace().getNodes().size());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/")).getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/one"))).getLock().isLocked());
        AssertJUnit.assertEquals((boolean)false, (boolean)((NodeSPI)cache.get(Fqn.fromString((String)"/one/two"))).getLock().isLocked());
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one")).getChild((Object)"two"));
        AssertJUnit.assertEquals((Object)pojo2, (Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    public void testGetKeyValIsolationTransaction() throws Exception {
        SamplePojo pojo1 = new SamplePojo(21, "test-1");
        SamplePojo pojo2 = new SamplePojo(21, "test-2");
        CacheImpl<Object, Object> cache = this.createCacheWithListener();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        cache.put("/one/two", (Object)"key1", (Object)pojo1);
        mgr.commit();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        System.out.println("Current TX " + mgr.getTransaction());
        AssertJUnit.assertEquals((Object)pojo1, (Object)cache.get("/one/two", (Object)"key1"));
        mgr.suspend();
        mgr.begin();
        System.out.println("Current TX " + mgr.getTransaction());
        cache.put("/one/two", (Object)"key2", (Object)pojo2);
        mgr.commit();
        AssertJUnit.assertEquals((Object)pojo2, (Object)cache.get("/one/two", (Object)"key2"));
        System.out.println("Current TX " + mgr.getTransaction());
        mgr.resume(tx);
        System.out.println("Current TX " + mgr.getTransaction());
        AssertJUnit.assertEquals(null, (Object)cache.get("/one/two", (Object)"key2"));
        mgr.commit();
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testGetKeysIsolationTransaction() throws Exception {
        CacheImpl<Object, Object> cache = this.createCacheWithListener();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        if (mgr.getTransaction() != null) {
            mgr.rollback();
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        AssertJUnit.assertEquals((int)1, (int)cache.getKeys("/one/two").size());
        mgr.suspend();
        mgr.begin();
        cache.put("/one/two", (Object)"key2", (Object)pojo);
        mgr.commit();
        AssertJUnit.assertEquals((int)2, (int)cache.getKeys("/one/two").size());
        mgr.resume(tx);
        AssertJUnit.assertEquals((int)1, (int)cache.getKeys("/one/two").size());
        mgr.commit();
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testTxRollbackThroughConcurrentWrite() throws Exception {
        CacheImpl<Object, Object> cache = this.createCacheWithListener();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        if (mgr.getTransaction() != null) {
            mgr.rollback();
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        cache.put("/one/two", (Object)"key1", (Object)"val1");
        mgr.commit();
        Set keys = cache.getKeys("/one/two");
        System.out.println("keys after TX #1: " + keys);
        AssertJUnit.assertEquals((int)1, (int)keys.size());
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.put("/one/two", (Object)"key2", (Object)"val2");
        mgr.suspend();
        mgr.begin();
        cache.put("/one/two", (Object)"key3", (Object)"val3");
        mgr.commit();
        keys = cache.getKeys("/one/two");
        System.out.println("keys after TX #3 committed: " + keys);
        AssertJUnit.assertEquals((int)2, (int)keys.size());
        mgr.resume(tx);
        keys = cache.getKeys("/one/two");
        System.out.println("keys after TX #2 resumed (in private workspace of TX #2): " + keys);
        AssertJUnit.assertEquals((int)2, (int)keys.size());
        try {
            mgr.commit();
            AssertJUnit.fail((String)"TX should fail as other TX incremented version number");
        }
        catch (RollbackException rollback_ex) {
            System.out.println("TX was rolled back because the other TX committed first and incremented version ID. This is the expected behavior");
        }
        keys = cache.getKeys("/one/two");
        System.out.println("keys after TX #2 was rolled back: " + keys);
        AssertJUnit.assertEquals((int)2, (int)keys.size());
        this.destroyCache((Cache<Object, Object>)cache);
    }

    protected CacheImpl<Object, Object> createSyncReplicatedCache() throws Exception {
        return this.createReplicatedCache("temp" + this.groupIncreaser, Configuration.CacheMode.REPL_SYNC);
    }

    protected CacheImpl<Object, Object> createSyncReplicatedCacheAsyncCommit() throws Exception {
        CacheImpl<Object, Object> cache = this.createReplicatedCache("temp" + this.groupIncreaser, Configuration.CacheMode.REPL_SYNC, false);
        cache.getConfiguration().setSyncCommitPhase(false);
        cache.getConfiguration().setSyncRollbackPhase(false);
        cache.create();
        cache.start();
        return cache;
    }

    public void testPuts() throws Exception {
        CacheImpl<Object, Object> cache = this.createCache();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        Assert.assertNull((Object)cache.get(this.fqn));
        mgr.begin();
        cache.put(this.fqn, (Object)this.key, (Object)this.value);
        Assert.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        Transaction tx = mgr.getTransaction();
        mgr.suspend();
        mgr.begin();
        Assert.assertNull((Object)cache.get(this.fqn, (Object)this.key));
        mgr.commit();
        mgr.resume(tx);
        Assert.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        mgr.commit();
        Assert.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
    }

    public void testRemoves() throws Exception {
        CacheImpl<Object, Object> cache = this.createCache();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        Assert.assertNull((Object)cache.get(this.fqn));
        cache.put(this.fqn, (Object)this.key, (Object)this.value);
        Assert.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        mgr.begin();
        Assert.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        cache.remove(this.fqn);
        Assert.assertNull((Object)cache.get(this.fqn));
        Transaction tx = mgr.getTransaction();
        mgr.suspend();
        mgr.begin();
        Assert.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        mgr.commit();
        mgr.resume(tx);
        Assert.assertNull((Object)cache.get(this.fqn));
        mgr.commit();
        Assert.assertNull((Object)cache.get(this.fqn));
    }

    public void testRemovesBeforeGet() throws Exception {
        CacheImpl<Object, Object> cache = this.createCache();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        Assert.assertNull((Object)cache.get(this.fqn));
        cache.put(this.fqn, (Object)this.key, (Object)this.value);
        Assert.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        mgr.begin();
        cache.remove(this.fqn);
        Assert.assertNull((Object)cache.get(this.fqn));
        Transaction tx = mgr.getTransaction();
        mgr.suspend();
        mgr.begin();
        Assert.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        mgr.commit();
        mgr.resume(tx);
        Assert.assertNull((Object)cache.get(this.fqn));
        mgr.commit();
        Assert.assertNull((Object)cache.get(this.fqn));
    }

    public void testLoopedPutAndGet() throws Exception {
        try {
            this.log.debug((Object)"Starting test");
            CacheImpl<Object, Object> cache1 = this.createSyncReplicatedCache();
            CacheImpl<Object, Object> cache2 = this.createSyncReplicatedCache();
            this.log.debug((Object)"Created caches");
            TransactionManager mgr = cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
            int numLoops = 5;
            int numPuts = 5;
            this.log.debug((Object)("Starting " + numLoops + " loops"));
            for (int i = 0; i < numLoops; ++i) {
                this.log.debug((Object)(" *** in loop " + i));
                mgr.begin();
                for (int j = 0; j < numPuts; ++j) {
                    cache1.put(Fqn.fromString((String)("/profiler/node" + i)), (Object)("key" + j), (Object)("value" + j));
                }
                this.log.debug((Object)"*** >> Out of put loop");
                mgr.commit();
            }
            this.destroyCache((Cache<Object, Object>)cache1);
            this.destroyCache((Cache<Object, Object>)cache2);
        }
        catch (Exception e) {
            this.log.debug((Object)"Error: ", (Throwable)e);
            Assert.assertFalse((String)"Threw exception!", (boolean)true);
            throw e;
        }
    }

    @Test(enabled=false)
    public void testAsynchronousCommit() throws Exception {
        CacheImpl<Object, Object> cache1 = this.createSyncReplicatedCacheAsyncCommit();
        CacheImpl<Object, Object> cache2 = this.createSyncReplicatedCacheAsyncCommit();
        TransactionManager tm1 = cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        Fqn fqn = Fqn.fromString((String)"/test/node");
        String KEY = "key";
        String VALUE1 = "value1";
        tm1.begin();
        cache1.put(fqn, (Object)KEY, (Object)VALUE1);
        tm1.commit();
        AssertJUnit.assertEquals((String)"Known issue JBCACHE-1201: Correct node2 value", (Object)VALUE1, (Object)cache2.get(fqn, (Object)KEY));
        AssertJUnit.assertEquals((String)"Correct node1 value", (Object)VALUE1, (Object)cache1.get(fqn, (Object)KEY));
        this.destroyCache((Cache<Object, Object>)cache1);
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    private void rollback(TransactionManager tm) {
        try {
            tm.rollback();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private class ExceptionHolder {
        Exception node1Exception;
        Exception node2Exception;
        AssertionFailedError node1Failure;
        AssertionFailedError node2Failure;

        private ExceptionHolder() {
        }
    }
}

