/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.event.NodeEvent;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class PassivationActivationCallbacksTestCase {
    private static final Fqn<String> BASE = Fqn.fromString((String)"/base");
    private static final Log log = LogFactory.getLog(PassivationActivationCallbacksTestCase.class);
    private CacheSPI<String, String> cache;
    private CacheLoader loader = null;
    private CacheListener listener = null;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        log.debug((Object)"");
        CacheFactory instance = DefaultCacheFactory.getInstance();
        this.cache = (CacheImpl)instance.createCache(false);
        this.cache.getConfiguration().setCacheMode("local");
        this.configureEviction();
        this.configureCacheLoader();
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.listener = new CacheListener();
        this.cache.addCacheListener((Object)this.listener);
        this.cache.create();
        this.cache.start();
        this.loader = this.cache.getCacheLoaderManager().getCacheLoader();
    }

    protected void configureCacheLoader() throws Exception {
        CacheLoaderConfig clc = new CacheLoaderConfig();
        clc.setPassivation(true);
        clc.setShared(false);
        clc.setPreload("/");
        CacheLoaderConfig.IndividualCacheLoaderConfig dummyConfig = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        dummyConfig.setAsync(false);
        dummyConfig.setFetchPersistentState(true);
        dummyConfig.setIgnoreModifications(false);
        dummyConfig.setClassName(DummyInMemoryCacheLoader.class.getName());
        clc.addIndividualCacheLoaderConfig(dummyConfig);
        this.cache.getConfiguration().setCacheLoaderConfig(clc);
    }

    protected void configureEviction() throws Exception {
        EvictionConfig ec = new EvictionConfig();
        ec.setWakeupIntervalSeconds(1);
        ArrayList<EvictionRegionConfig> ercs = new ArrayList<EvictionRegionConfig>();
        EvictionRegionConfig erc = new EvictionRegionConfig();
        erc.setRegionFqn(RegionManager.DEFAULT_REGION);
        LRUConfiguration epc = new LRUConfiguration();
        epc.setMaxNodes(0);
        epc.setTimeToLiveSeconds(5);
        erc.setEvictionPolicyConfig((EvictionPolicyConfig)epc);
        ercs.add(erc);
        erc = new EvictionRegionConfig();
        erc.setRegionFqn(BASE);
        epc = new LRUConfiguration();
        epc.setMaxNodes(0);
        epc.setTimeToLiveSeconds(1);
        erc.setEvictionPolicyConfig((EvictionPolicyConfig)epc);
        ercs.add(erc);
        ec.setEvictionRegionConfigs(ercs);
        this.cache.getConfiguration().setEvictionConfig(ec);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.removeNode(Fqn.ROOT);
        this.loader.remove(Fqn.fromString((String)"/"));
        this.cache.stop();
        this.cache.destroy();
    }

    public void testSimpleLifecycle() throws Exception {
        Fqn fqn = new Fqn(BASE, (Object[])new String[]{"bean1"});
        this.cache.put(fqn, (Object)"bean", (Object)"A bean");
        this.cache.evict(fqn, false);
        AssertJUnit.assertNull((String)"No activation exception", (Object)this.listener.activationException);
        AssertJUnit.assertNull((String)"No passivation exception", (Object)this.listener.passivationException);
        AssertJUnit.assertTrue((boolean)this.listener.passivated.contains(fqn));
        AssertJUnit.assertFalse((boolean)this.listener.activated.contains(fqn));
        Object obj = this.cache.get(fqn, (Object)"bean");
        AssertJUnit.assertEquals((String)"Got bean", (Object)"A bean", (Object)obj);
        AssertJUnit.assertNull((String)"No activation exception", (Object)this.listener.activationException);
        AssertJUnit.assertNull((String)"No passivation exception", (Object)this.listener.passivationException);
        AssertJUnit.assertTrue((boolean)this.listener.activated.contains(fqn));
    }

    @org.jboss.cache.notifications.annotation.CacheListener
    public class CacheListener {
        protected Log log = LogFactory.getLog(CacheListener.class);
        protected Set<Fqn<String>> passivated = new HashSet<Fqn<String>>();
        protected Set<Fqn<String>> activated = new HashSet<Fqn<String>>();
        protected Exception passivationException;
        protected Exception activationException;

        @NodeActivated
        public void nodeActivated(NodeEvent e) {
            if (e.isPre()) {
                return;
            }
            if (!e.getFqn().isChildOrEquals(BASE)) {
                return;
            }
            Object bean = null;
            try {
                bean = PassivationActivationCallbacksTestCase.this.cache.get(e.getFqn(), (Object)"bean");
            }
            catch (CacheException ex) {
                this.log.error((Object)("nodeActivate(): can't retrieve bean instance from: " + e.getFqn() + " with exception: " + (Object)((Object)ex)));
                this.activationException = ex;
                return;
            }
            if (bean == null) {
                this.activationException = new IllegalStateException("nodeActivate(): null bean instance.");
                throw (IllegalStateException)this.activationException;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("nodeActivate(): saw postActivate event on fqn: " + e.getFqn()));
            }
            this.activated.add((Fqn<String>)e.getFqn());
        }

        @NodePassivated
        public void nodePassivated(NodeEvent e) {
            if (!e.isPre()) {
                return;
            }
            Fqn fqn = e.getFqn();
            if (!fqn.isChildOrEquals(BASE)) {
                return;
            }
            try {
                Object bean = PassivationActivationCallbacksTestCase.this.cache.get(fqn, (Object)"bean");
                if (bean != null) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("nodePassivate(): send prePassivate event on fqn: " + fqn));
                    }
                    this.passivated.add((Fqn<String>)fqn);
                }
            }
            catch (CacheException ex) {
                this.log.error((Object)("nodePassivate(): can't retrieve bean instance from: " + fqn + " with exception: " + (Object)((Object)ex)));
                this.passivationException = ex;
                return;
            }
        }
    }
}

