/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.replicated;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.event.NodeEvent;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class SyncCacheListenerTest {
    private CacheImpl<Object, Object> cache1;
    private CacheImpl<Object, Object> cache2;
    private static final Log log_ = LogFactory.getLog(SyncCacheListenerTest.class);
    private String old_factory = null;
    private static final String FACTORY = "org.jboss.cache.transaction.DummyContextFactory";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        System.out.println("*** starting setUp()");
        this.old_factory = System.getProperty("java.naming.factory.initial");
        System.setProperty("java.naming.factory.initial", FACTORY);
        this.initCaches();
        System.out.println("*** finished setUp()");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        System.out.println("*** starting tearDown()");
        DummyTransactionManager.destroy();
        this.destroyCaches();
        if (this.old_factory != null) {
            System.setProperty("java.naming.factory.initial", this.old_factory);
            this.old_factory = null;
        }
        System.out.println("*** finished tearDown()");
    }

    private void initCaches() throws Exception {
        this.cache1 = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        this.cache2 = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        this.cache1.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cache2.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cache1.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache2.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache1.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache2.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache1.getConfiguration().setLockAcquisitionTimeout(5000L);
        this.cache2.getConfiguration().setLockAcquisitionTimeout(5000L);
        this.cache1.start();
        this.cache2.start();
    }

    private void destroyCaches() {
        if (this.cache1 != null) {
            this.cache1.stop();
        }
        if (this.cache2 != null) {
            this.cache2.stop();
        }
    }

    public void testSyncTxRepl() throws Exception {
        TransactionManager tm = this.cache1.getTransactionManager();
        tm.begin();
        Transaction tx = tm.getTransaction();
        Listener lis = new Listener();
        this.cache1.getNotifier().addCacheListener((Object)lis);
        lis.put("/a/b/c", "age", 38);
        tm.suspend();
        AssertJUnit.assertNull((String)"age on cache2 must be null as the TX has not yet been committed", (Object)this.cache2.get("/a/b/c", (Object)"age"));
        tm.resume(tx);
        tm.commit();
        Integer age = (Integer)this.cache2.get("/a/b/c", (Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
    }

    public void testRemoteCacheListener() throws Exception {
        RemoteListener lis = new RemoteListener();
        this.cache2.getNotifier().addCacheListener((Object)lis);
        this.cache1.put("/a/b/c", (Object)"age", (Object)38);
        Integer age = (Integer)this.cache2.get("/a/b/c", (Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
        this.cache1.remove("/a/b/c", (Object)"age");
    }

    public void testSyncRepl() throws Exception {
        Listener lis = new Listener();
        this.cache1.getNotifier().addCacheListener((Object)lis);
        lis.put("/a/b/c", "age", 38);
        Integer age = (Integer)this.cache2.get("/a/b/c", (Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
    }

    public void testSyncTxReplMap() throws Exception {
        TransactionManager tm = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        tm.begin();
        Transaction tx = tm.getTransaction();
        Listener lis = new Listener();
        this.cache1.getNotifier().addCacheListener((Object)lis);
        HashMap<String, Comparable> map = new HashMap<String, Comparable>();
        map.put("age", Integer.valueOf(38));
        map.put("name", (Comparable)((Object)"Ben"));
        lis.put("/a/b/c", map);
        tm.suspend();
        AssertJUnit.assertNull((String)"age on cache2 must be null as the TX has not yet been committed", (Object)this.cache2.get("/a/b/c", (Object)"age"));
        tm.resume(tx);
        tm.commit();
        Integer age = (Integer)this.cache2.get("/a/b/c", (Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
    }

    public void testSyncReplMap() throws Exception {
        Listener lis = new Listener();
        this.cache1.getNotifier().addCacheListener((Object)lis);
        HashMap<String, Comparable> map = new HashMap<String, Comparable>();
        map.put("age", Integer.valueOf(38));
        map.put("name", (Comparable)((Object)"Ben"));
        lis.put("/a/b/c", map);
        Integer age = (Integer)this.cache2.get("/a/b/c", (Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
    }

    @CacheListener
    public class RemoteListener {
        @NodeRemoved
        @NodeModified
        public void callback(NodeEvent e) {
            System.out.println("Callback got event " + e);
            log_.debug((Object)("Callback got event " + e));
            AssertJUnit.assertFalse((String)"node was removed on remote cache so isLocal should be false", (boolean)e.isOriginLocal());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @CacheListener
    public class Listener {
        Object key_ = null;

        public void put(String fqn, Object key, Object val) {
            this.key_ = key;
            SyncCacheListenerTest.this.cache1.put(fqn, key, val);
        }

        public void put(String fqn, Map<String, Comparable> map) {
            if (map.size() == 0) {
                AssertJUnit.fail((String)"put(): map size can't be 0");
            }
            Set<String> set = map.keySet();
            this.key_ = set.iterator().next();
            SyncCacheListenerTest.this.cache1.put(fqn, map);
        }

        @NodeModified
        public void nodeModified(NodeEvent ne) {
            if (!ne.isPre()) {
                log_.debug((Object)("nodeModified visited with fqn: " + ne.getFqn()));
                try {
                    SyncCacheListenerTest.this.cache1.get(ne.getFqn(), this.key_);
                }
                catch (CacheException e) {
                    e.printStackTrace();
                    AssertJUnit.fail((String)("nodeModified: test failed with exception: " + (Object)((Object)e)));
                }
            }
        }
    }
}

