/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.Dynamic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationComponent
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4879873994727821938L;
    protected transient Log log = LogFactory.getLog(this.getClass());
    private transient CacheImpl cache;
    private final Set<ConfigurationComponent> children = Collections.synchronizedSet(new HashSet());

    protected ConfigurationComponent() {
    }

    public void passCacheToChildConfig(ConfigurationComponent child) {
        if (child != null) {
            child.setCacheImpl(this.cache);
        }
    }

    protected void addChildConfig(ConfigurationComponent child) {
        if (child != null && this.children.add(child)) {
            child.setCacheImpl(this.cache);
        }
    }

    protected void addChildConfigs(Collection<? extends ConfigurationComponent> toAdd) {
        if (toAdd != null) {
            for (ConfigurationComponent configurationComponent : toAdd) {
                this.addChildConfig(configurationComponent);
            }
        }
    }

    protected void removeChildConfig(ConfigurationComponent child) {
        this.children.remove(child);
    }

    protected void removeChildConfigs(Collection<? extends ConfigurationComponent> toRemove) {
        if (toRemove != null) {
            for (ConfigurationComponent configurationComponent : toRemove) {
                this.removeChildConfig(configurationComponent);
            }
        }
    }

    protected void replaceChildConfig(ConfigurationComponent oldConfig, ConfigurationComponent newConfig) {
        this.removeChildConfig(oldConfig);
        this.addChildConfig(newConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceChildConfigs(Collection<? extends ConfigurationComponent> oldConfigs, Collection<? extends ConfigurationComponent> newConfigs) {
        Set<ConfigurationComponent> set = this.children;
        synchronized (set) {
            this.removeChildConfigs(oldConfigs);
            this.addChildConfigs(newConfigs);
        }
    }

    protected void testImmutability(String fieldName) {
        try {
            if (this.cache != null && this.cache.isStarted() && !this.getClass().getDeclaredField(fieldName).isAnnotationPresent(Dynamic.class)) {
                throw new ConfigurationException("Attempted to modify a non-Dynamic configuration element [" + fieldName + "] after the cache has started!");
            }
        }
        catch (NoSuchFieldException e) {
            this.log.warn((Object)("Field " + fieldName + " not found!!"));
        }
    }

    protected CacheImpl getTreeCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheImpl(CacheImpl cache) {
        this.cache = cache;
        Set<ConfigurationComponent> set = this.children;
        synchronized (set) {
            for (ConfigurationComponent child : this.children) {
                child.setCacheImpl(cache);
            }
        }
    }

    public ConfigurationComponent clone() throws CloneNotSupportedException {
        ConfigurationComponent c = (ConfigurationComponent)super.clone();
        c.setCacheImpl(null);
        return c;
    }

    protected static boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

