/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.optimistic.DataVersioningException;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisticValidatorInterceptor
extends OptimisticInterceptor {
    private boolean useTombstones;

    @Override
    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        Configuration.CacheMode mode = cache.getConfiguration().getCacheMode();
        this.useTombstones = mode == Configuration.CacheMode.INVALIDATION_ASYNC || mode == Configuration.CacheMode.INVALIDATION_SYNC;
    }

    @Override
    public Object invoke(InvocationContext ctx) throws Throwable {
        MethodCall m = ctx.getMethodCall();
        Object retval = null;
        switch (m.getMethodId()) {
            case 18: {
                this.validateNodes(this.getGlobalTransaction(ctx));
                break;
            }
            case 11: {
                this.commit(this.getGlobalTransaction(ctx));
                break;
            }
            case 12: {
                this.rollBack(this.getGlobalTransaction(ctx));
                break;
            }
            default: {
                retval = super.invoke(ctx);
            }
        }
        return retval;
    }

    private void validateNodes(GlobalTransaction gtx) throws CacheException {
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        Collection<WorkspaceNode> nodes = workspace.getNodes().values();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Validating " + nodes.size() + " nodes."));
        }
        this.simpleValidate(nodes);
        this.log.debug((Object)"Successfully validated nodes");
    }

    private void simpleValidate(Collection<WorkspaceNode> nodes) throws DataVersioningException {
        for (WorkspaceNode workspaceNode : nodes) {
            if (workspaceNode.isDirty()) {
                NodeSPI underlyingNode;
                Fqn fqn = workspaceNode.getFqn();
                if (this.trace) {
                    this.log.trace((Object)("Validating version for node [" + fqn + "]"));
                }
                if ((underlyingNode = this.cache.peek(fqn, true, true)) == null && !workspaceNode.isCreated() && !workspaceNode.isDeleted()) {
                    throw new DataVersioningException("Underlying node for " + fqn + " is null, and this node wasn't newly created in this transaction!  We have a concurrent deletion event.");
                }
                if (underlyingNode != null && underlyingNode.isValid() && workspaceNode.isCreated() && workspaceNode.isModified()) {
                    throw new DataVersioningException("Transaction attempted to create " + fqn + " anew.  It has already been created since this transaction started, by another (possibly remote) transaction.  We have a concurrent creation event.");
                }
                if (underlyingNode != null && !underlyingNode.isValid()) {
                    if (!workspaceNode.isCreated() && !workspaceNode.isDeleted()) {
                        throw new DataVersioningException("Underlying node doesn't exist but a tombstone does; workspace node should be marked as created!");
                    }
                    if (underlyingNode.getVersion().newerThan(workspaceNode.getVersion())) {
                        throw new DataVersioningException("Version mismatch for node " + fqn + ": underlying node with version " + workspaceNode.getNode().getVersion() + " is newer than workspace node, with version " + workspaceNode.getVersion());
                    }
                }
                if (workspaceNode.isCreated() || !workspaceNode.isDeleted() && !workspaceNode.isModified()) continue;
                if (underlyingNode == null) {
                    if (!workspaceNode.isDeleted()) {
                        throw new DataVersioningException("Unable to compare versions since the underlying node has been deleted by a concurrent transaction!");
                    }
                    if (!this.trace) continue;
                    this.log.trace((Object)("The data node [" + fqn + "] is null, but this is ok since the workspace node is marked as deleted as well"));
                    continue;
                }
                if (!underlyingNode.getVersion().newerThan(workspaceNode.getVersion())) continue;
                throw new DataVersioningException("Version mismatch for node " + fqn + ": underlying node with version " + workspaceNode.getNode().getVersion() + " is newer than workspace node, with version " + workspaceNode.getVersion());
            }
            if (!this.trace) continue;
            this.log.trace((Object)("Node [" + workspaceNode.getFqn() + "] doesn't need validating as it isn't dirty"));
        }
    }

    private void commit(GlobalTransaction gtx) {
        TransactionWorkspace workspace;
        try {
            workspace = this.getTransactionWorkspace(gtx);
        }
        catch (CacheException e) {
            this.log.warn((Object)"we can't rollback", (Throwable)e);
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Commiting successfully validated changes for GlobalTransaction " + gtx));
        }
        Collection workspaceNodes = workspace.getNodes().values();
        for (WorkspaceNode workspaceNode : workspaceNodes) {
            NodeSPI underlyingNode = workspaceNode.getNode();
            if (workspaceNode.isDeleted()) {
                if (this.trace) {
                    this.log.trace((Object)("Workspace node " + workspaceNode.getFqn() + " deleted; removing"));
                }
                if (underlyingNode.getFqn().isRoot()) {
                    throw new CacheException("An illegal attempt to delete the root node!");
                }
                underlyingNode.setValid(false, true);
                this.performVersionUpdate(underlyingNode, workspaceNode);
                if (this.useTombstones) continue;
                NodeSPI parent = underlyingNode.getParent();
                if (parent == null) {
                    throw new CacheException("Underlying node " + underlyingNode + " has no parent");
                }
                parent.removeChildDirect(underlyingNode.getFqn().getLastElement());
                continue;
            }
            boolean updateVersion = false;
            if (workspaceNode.isChildrenModified()) {
                this.log.trace((Object)"Updating children since node has modified children");
                List<Set<Fqn>> deltas = workspaceNode.getMergedChildren();
                if (this.trace) {
                    this.log.trace((Object)("Applying children deltas to parent node " + underlyingNode.getFqn()));
                }
                for (Fqn child : deltas.get(0)) {
                    underlyingNode.addChildDirect(workspace.getNode(child).getNode());
                }
                for (Fqn child : deltas.get(1)) {
                    NodeSPI childNode = underlyingNode.getChildDirect(child.getLastElement());
                    if (childNode != null) {
                        childNode.setValid(false, true);
                    }
                    if (this.useTombstones) continue;
                    underlyingNode.removeChildDirect(child.getLastElement());
                }
                updateVersion = underlyingNode.isLockForChildInsertRemove();
            }
            if (workspaceNode.isModified()) {
                this.log.trace((Object)"Merging data since node is dirty");
                Map mergedData = workspaceNode.getMergedData();
                underlyingNode.clearDataDirect();
                underlyingNode.putAllDirect(mergedData);
                this.validateNodeAndParents(underlyingNode);
                updateVersion = true;
            }
            if (!updateVersion) continue;
            this.performVersionUpdate(underlyingNode, workspaceNode);
        }
    }

    private void validateNodeAndParents(NodeSPI node) {
        node.setValid(true, false);
        if (!node.getFqn().isRoot()) {
            this.validateNodeAndParents(node.getParent());
        }
    }

    private void performVersionUpdate(NodeSPI underlyingNode, WorkspaceNode workspaceNode) {
        if (workspaceNode.isVersioningImplicit()) {
            if (this.trace) {
                this.log.trace((Object)"Versioning is implicit; incrementing.");
            }
            underlyingNode.setVersion(((DefaultDataVersion)workspaceNode.getVersion()).increment());
        } else {
            if (this.trace) {
                this.log.trace((Object)"Versioning is explicit; not attempting an increment.");
            }
            underlyingNode.setVersion(workspaceNode.getVersion());
        }
        if (this.trace) {
            this.log.trace((Object)("Setting version of node " + underlyingNode.getFqn() + " from " + workspaceNode.getVersion() + " to " + underlyingNode.getVersion()));
        }
    }

    private void rollBack(GlobalTransaction gtx) {
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        workspace.clearNodes();
    }
}

