/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDelegatingCacheLoader
extends AbstractCacheLoader {
    CacheLoaderConfig.IndividualCacheLoaderConfig config;
    CacheImpl delegate = null;

    public LocalDelegatingCacheLoader() {
    }

    public LocalDelegatingCacheLoader(CacheImpl delegate) {
        this.delegate = delegate;
    }

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig config) {
        this.config = config;
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    @Override
    public Set<?> getChildrenNames(Fqn fqn) throws Exception {
        Set cn = this.delegate.getChildrenNames(fqn);
        if (cn.isEmpty()) {
            return null;
        }
        return cn;
    }

    @Override
    public Map<Object, Object> get(Fqn name) throws Exception {
        NodeSPI n = (NodeSPI)this.delegate.get(name);
        if (n == null) {
            return null;
        }
        Map<Object, Object> m = n.getDataDirect();
        if (m == null) {
            m = new HashMap<Object, Object>(0);
        }
        return m;
    }

    @Override
    public boolean exists(Fqn name) throws Exception {
        return this.delegate.exists(name);
    }

    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        return this.delegate.put(name, key, value);
    }

    @Override
    public void put(Fqn name, Map<Object, Object> attributes) throws Exception {
        this.delegate.put(name, attributes);
    }

    @Override
    public Object remove(Fqn fqn, Object key) throws Exception {
        return this.delegate.remove(fqn, key);
    }

    @Override
    public void remove(Fqn fqn) throws Exception {
        this.delegate.remove(fqn);
    }

    @Override
    public void removeData(Fqn fqn) throws Exception {
        this.delegate.removeData(fqn);
    }

    protected void setDelegateCache(CacheImpl delegate) {
        this.delegate = delegate;
    }

    @Override
    public void loadEntireState(ObjectOutputStream os) throws Exception {
        try {
            this.delegate.getStateTransferManager().getState(os, Fqn.ROOT, this.delegate.getConfiguration().getStateRetrievalTimeout(), true, false);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Caught exception getting state from delegate", t);
        }
    }

    @Override
    public void loadState(Fqn subtree, ObjectOutputStream os) throws Exception {
        throw new UnsupportedOperationException("setting and loading state for specific Fqns not supported");
    }

    @Override
    public void storeEntireState(ObjectInputStream is) throws Exception {
        this.delegate.getStateTransferManager().setState(is, Fqn.ROOT);
    }

    @Override
    public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
        throw new UnsupportedOperationException("setting and loading state for specific Fqns not supported");
    }
}

