/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.loader.AdjListJDBCCacheLoaderConfig;
import org.jboss.cache.loader.ConnectionFactory;

public class ManagedConnectionFactory
implements ConnectionFactory {
    private static final Log log = LogFactory.getLog(ManagedConnectionFactory.class);
    private DataSource dataSource;
    private String datasourceName;

    public void setConfig(AdjListJDBCCacheLoaderConfig config) {
        this.datasourceName = config.getDatasourceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(this.datasourceName);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Datasource lookup for " + this.datasourceName + " succeded: " + this.dataSource));
            }
        }
        catch (NamingException e) {
            this.reportAndRethrowError("Failed to lookup datasource " + this.datasourceName, e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    log.warn((Object)"Failed to close naming context.", (Throwable)e);
                }
            }
        }
    }

    public Connection getConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Connection checked out: " + connection));
        }
        return connection;
    }

    public void prepare(Object txId) {
    }

    public void commit(Object txId) {
    }

    public void rollback(Object txId) {
    }

    public void close(Connection con) {
        this.safeClose(con);
    }

    public void stop() {
    }

    private void safeClose(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.warn((Object)"Failed to close connection", (Throwable)e);
            }
        }
    }

    private void reportAndRethrowError(String message, Exception cause) throws IllegalStateException {
        log.error((Object)message, (Throwable)cause);
        throw new IllegalStateException(message, cause);
    }
}

