/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.TcpDelegatingCacheLoaderConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpDelegatingCacheLoader
extends AbstractCacheLoader {
    private Socket sock;
    private TcpDelegatingCacheLoaderConfig config;
    ObjectInputStream in;
    ObjectOutputStream out;

    public TcpDelegatingCacheLoader() {
    }

    public TcpDelegatingCacheLoader(String host, int port) {
        this.config = new TcpDelegatingCacheLoaderConfig(host, port);
    }

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.config = base instanceof TcpDelegatingCacheLoaderConfig ? (TcpDelegatingCacheLoaderConfig)base : new TcpDelegatingCacheLoaderConfig(base);
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<?> getChildrenNames(Fqn fqn) throws Exception {
        Set cn = null;
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(1);
            this.out.writeObject(fqn);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
            cn = (Set)retval;
        }
        if (cn.isEmpty()) {
            return null;
        }
        return cn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Object, Object> get(Fqn name) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(3);
            this.out.writeObject(name);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
            return (Map)retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(Fqn name) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(4);
            this.out.writeObject(name);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
            return (Boolean)retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(5);
            this.out.writeObject(name);
            this.out.writeObject(key);
            this.out.writeObject(value);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Fqn name, Map<Object, Object> attributes) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(6);
            this.out.writeObject(name);
            this.out.writeObject(attributes);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
        }
    }

    @Override
    public void start() throws Exception {
        this.init();
    }

    @Override
    public void stop() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void init() throws IOException {
        this.sock = new Socket(this.config.getHost(), this.config.getPort());
        this.out = new ObjectOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
        this.out.flush();
        this.in = new ObjectInputStream(new BufferedInputStream(this.sock.getInputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(List<Modification> modifications) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(12);
            int length = modifications.size();
            this.out.writeInt(length);
            for (Modification m : modifications) {
                m.writeExternal(this.out);
            }
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Fqn fqn, Object key) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(7);
            this.out.writeObject(fqn);
            this.out.writeObject(key);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Fqn fqn) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(8);
            this.out.writeObject(fqn);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeData(Fqn fqn) throws Exception {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.reset();
            this.out.writeByte(9);
            this.out.writeObject(fqn);
            this.out.flush();
            Object retval = this.in.readObject();
            if (retval instanceof Exception) {
                throw (Exception)retval;
            }
        }
    }

    @Override
    public void loadEntireState(ObjectOutputStream os) throws Exception {
        throw new UnsupportedOperationException("operation is not currently supported - need to define semantics first");
    }

    @Override
    public void loadState(Fqn subtree, ObjectOutputStream os) throws Exception {
        throw new UnsupportedOperationException("operation is not currently supported - need to define semantics first");
    }

    @Override
    public void storeEntireState(ObjectInputStream is) throws Exception {
        throw new UnsupportedOperationException("operation is not currently supported - need to define semantics first");
    }

    @Override
    public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
        throw new UnsupportedOperationException("operation is not currently supported - need to define semantics first");
    }
}

