/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.interceptors;

import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.lock.UpgradeException;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.impl.InternalConstant;
import org.jboss.cache.pojo.interceptors.AbstractInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoTxLockInterceptor
extends AbstractInterceptor {
    public static final String LOCK_KEY = "POJOCache.LOCK";
    private final int RETRY = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation in) throws Throwable {
        MethodInvocation invocation = (MethodInvocation)in;
        this.handleLock(invocation);
        Object object = invocation.invokeNext();
        return object;
    }

    private void handleLock(MethodInvocation invocation) throws Throwable {
        CacheSPI cache;
        Object owner = null;
        Fqn id = (Fqn)invocation.getArguments()[0];
        if (!this.lockPojo(owner, id, (Cache<Object, Object>)(cache = this.getCache(invocation)))) {
            throw new PojoCacheException("PojoCache.removeObject(): Can't obtain the pojo lock under id: " + id);
        }
    }

    private boolean lockPojo(Object owner, Fqn id, Cache<Object, Object> cache) throws CacheException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("lockPojo(): id:" + id + " Owner: " + owner));
        }
        boolean isNeeded = true;
        int retry = 0;
        Fqn realId = id;
        if (id.isChildOrEquals(InternalConstant.JBOSS_INTERNAL) && id.size() > 2) {
            realId = id.getParent();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("lockPojo(): will lock parent id instead:" + realId));
            }
        }
        while (isNeeded) {
            try {
                cache.put(realId, (Object)LOCK_KEY, (Object)"LOCK");
                isNeeded = false;
            }
            catch (UpgradeException upe) {
                this.log.warn((Object)("lockPojo(): can't upgrade the lock during lockPojo. Will re-try. id: " + realId + " retry times: " + retry));
                if (retry++ > 5) {
                    return false;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {}
            }
        }
        return true;
    }
}

