/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.InputStream;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.lock.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class CacheFactoryTest {
    Configuration expected;
    String configFile = "META-INF/replSync-service.xml";
    private CacheImpl cache;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        XmlConfigurationParser parser = new XmlConfigurationParser();
        this.expected = parser.parseFile(this.configFile);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache != null) {
            this.cache.stop();
        }
    }

    public void testFromConfigFileStarted() {
        this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(this.configFile);
        AssertJUnit.assertTrue((String)"Should have started", (boolean)this.cache.isStarted());
        this.doSimpleConfTests(this.cache.getConfiguration());
    }

    public void testFromConfigFileUnstarted() {
        this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(this.configFile, false);
        AssertJUnit.assertFalse((String)"Should not have started", (boolean)this.cache.isStarted());
        this.doSimpleConfTests(this.cache.getConfiguration());
    }

    public void testFromConfigObjStarted() {
        this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(this.expected);
        AssertJUnit.assertTrue((String)"Should have started", (boolean)this.cache.isStarted());
        this.doSimpleConfTests(this.cache.getConfiguration());
    }

    public void testFromConfigObjUnstarted() {
        this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(this.expected, false);
        AssertJUnit.assertFalse((String)"Should not have started", (boolean)this.cache.isStarted());
        this.doSimpleConfTests(this.cache.getConfiguration());
    }

    private void doSimpleConfTests(Configuration tc) {
        AssertJUnit.assertEquals((Object)Configuration.CacheMode.REPL_SYNC, (Object)tc.getCacheMode());
        AssertJUnit.assertEquals((long)10000L, (long)tc.getLockAcquisitionTimeout());
        AssertJUnit.assertEquals((Object)IsolationLevel.REPEATABLE_READ, (Object)tc.getIsolationLevel());
        AssertJUnit.assertEquals((boolean)true, (boolean)tc.isUseRegionBasedMarshalling());
    }

    public void testLifecycle() throws Exception {
        this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(this.expected, false);
        AssertJUnit.assertFalse((boolean)this.cache.isStarted());
        this.cache.start();
        AssertJUnit.assertTrue((boolean)this.cache.isStarted());
        this.cache.stop();
        AssertJUnit.assertFalse((boolean)this.cache.isStarted());
    }

    public void testCreationFromStreamStarted() throws Exception {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.configFile);
        CacheFactory cf = DefaultCacheFactory.getInstance();
        this.cache = (CacheImpl)cf.createCache(is);
        AssertJUnit.assertTrue((String)"Should have started", (boolean)this.cache.isStarted());
        this.doSimpleConfTests(this.cache.getConfiguration());
    }

    public void testCreationFromStream() throws Exception {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.configFile);
        CacheFactory cf = DefaultCacheFactory.getInstance();
        this.cache = (CacheImpl)cf.createCache(is, false);
        AssertJUnit.assertFalse((String)"Should not have started", (boolean)this.cache.isStarted());
        this.doSimpleConfTests(this.cache.getConfiguration());
    }
}

