/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.misc.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "jgroups", "transaction"})
public class SyncReplTxTest {
    private List<CacheSPI<Object, Object>> caches;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        System.out.println("*** In setUp()");
        this.caches = new ArrayList<CacheSPI<Object, Object>>();
        this.caches.add((CacheSPI<Object, Object>)((CacheSPI)DefaultCacheFactory.getInstance().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC))));
        this.caches.add((CacheSPI<Object, Object>)((CacheSPI)DefaultCacheFactory.getInstance().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC))));
        TestingUtil.blockUntilViewsReceived(this.caches.toArray(new Cache[0]), 5000L);
        System.out.println("*** Finished setUp()");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        System.out.println("*** In tearDown()");
        if (this.caches != null) {
            for (CacheSPI<Object, Object> c : this.caches) {
                block7: {
                    if (c == null) continue;
                    try {
                        Transaction t = c.getTransactionManager().getTransaction();
                        if (t == null) break block7;
                        try {
                            if (t.getStatus() == 0) {
                                c.getTransactionManager().rollback();
                            }
                        }
                        catch (SystemException e) {}
                    }
                    catch (SystemException e) {
                        // empty catch block
                    }
                }
                c.stop();
            }
            this.caches = null;
        }
        System.out.println("*** Finished tearDown()");
    }

    private TransactionManager beginTransaction(Cache<Object, Object> cache) throws NotSupportedException, SystemException {
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        return mgr;
    }

    public void testBasicOperation() throws SystemException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException {
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        this.assertInvocationContextInitState();
        Fqn f = Fqn.fromString((String)"/test/data");
        String k = "key";
        String v = "value";
        AssertJUnit.assertNull((String)"Should be null", (Object)this.caches.get(0).getRoot().getChild(f));
        AssertJUnit.assertNull((String)"Should be null", (Object)this.caches.get(1).getRoot().getChild(f));
        Node node = this.caches.get(0).getRoot().addChild(f);
        AssertJUnit.assertNotNull((String)"Should not be null", (Object)node);
        TransactionManager tm = this.beginTransaction((Cache<Object, Object>)((Cache)this.caches.get(0)));
        node.put((Object)k, (Object)v);
        Transaction tx1 = this.caches.get(0).getInvocationContext().getTransaction();
        AssertJUnit.assertNotNull((String)"Transaction can't be null ", (Object)tx1);
        tm.commit();
        AssertJUnit.assertEquals((Object)v, (Object)node.get((Object)k));
        AssertJUnit.assertEquals((Object)v, (Object)this.caches.get(0).get(f, (Object)k));
        AssertJUnit.assertEquals((String)"Should have replicated", (Object)v, (Object)this.caches.get(1).get(f, (Object)k));
    }

    private void assertClusterSize(String message, int size) {
        for (CacheSPI<Object, Object> c : this.caches) {
            this.assertClusterSize(message, size, (Cache<Object, Object>)c);
        }
    }

    private void assertClusterSize(String message, int size, Cache<Object, Object> c) {
        AssertJUnit.assertEquals((String)message, (int)size, (int)c.getMembers().size());
    }

    private void assertInvocationContextInitState() {
        for (CacheSPI<Object, Object> c : this.caches) {
            this.assertInvocationContextInitState((Cache<Object, Object>)c);
        }
    }

    private void assertInvocationContextInitState(Cache<Object, Object> c) {
        InvocationContext ctx = c.getInvocationContext();
        InvocationContext control = null;
        try {
            control = ctx.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        control.reset();
        control.setOptionOverrides(new Option());
        AssertJUnit.assertEquals((String)"Should be equal", (Object)control, (Object)ctx);
    }
}

