/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.DummyEvictionConfiguration;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.NodeEventType;
import org.jboss.cache.interceptors.CacheMgmtInterceptor;
import org.jboss.cache.interceptors.CallInterceptor;
import org.jboss.cache.interceptors.EvictionInterceptor;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.PessimisticLockInterceptor;
import org.jboss.cache.interceptors.TxInterceptor;
import org.jboss.cache.interceptors.UnlockInterceptor;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class EvictionInterceptorTest {
    private static final String fqn1 = "/a/b/c";
    private static final String fqn2 = "/a/b";
    private static final String fqn3 = "/a/b/d";
    private static final String fqn4 = "/d/e/f";
    private CacheImpl<Object, Object> cache;
    private Interceptor interceptor;
    private RegionManager regionManager;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.regionManager = new RegionManager();
        DummyEvictionConfiguration config = new DummyEvictionConfiguration();
        this.regionManager.setUsingEvictions(true);
        this.regionManager.getRegion(RegionManager.DEFAULT_REGION, true).setEvictionPolicy((EvictionPolicyConfig)config);
        this.regionManager.getRegion(fqn1, true).setEvictionPolicy((EvictionPolicyConfig)config);
        this.regionManager.getRegion("/a/b/c/d", true).setEvictionPolicy((EvictionPolicyConfig)config);
        this.regionManager.getRegion(fqn2, true).setEvictionPolicy((EvictionPolicyConfig)config);
        this.regionManager.getRegion(fqn4, true).setEvictionPolicy((EvictionPolicyConfig)config);
        this.regionManager.getRegion("/d/e/g", true).setEvictionPolicy((EvictionPolicyConfig)config);
        this.regionManager.getRegion("/d/e", true).setEvictionPolicy((EvictionPolicyConfig)config);
        this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.interceptor = new CacheMgmtInterceptor();
        this.interceptor.setCache(this.cache);
        TxInterceptor ti = new TxInterceptor();
        ti.setCache(this.cache);
        this.interceptor.setNext((Interceptor)ti);
        UnlockInterceptor ui = new UnlockInterceptor();
        ui.setCache(this.cache);
        ti.setNext((Interceptor)ui);
        PessimisticLockInterceptor pli = new PessimisticLockInterceptor();
        pli.setCache(this.cache);
        ui.setNext((Interceptor)pli);
        EvictionInterceptor ei = new EvictionInterceptor();
        ei.setCache(this.cache);
        ei.setRegionManager(this.regionManager);
        pli.setNext((Interceptor)ei);
        CallInterceptor ci = new CallInterceptor();
        ci.setCache(this.cache);
        ci.setTreeCacheInstance(this.cache);
        ei.setNext((Interceptor)ci);
        this.cache.getConfiguration().setCacheMode("LOCAL");
        this.cache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.remove("/");
        this.cache.stop();
    }

    private Node<Object, Object> cast(Node node) {
        return node;
    }

    public void testVisitNode() throws Throwable {
        int i;
        MethodCall mc = MethodCallFactory.create((Method)MethodDeclarations.getNodeMethodLocal, (Object[])new Object[]{Fqn.fromString((String)fqn1)});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        Region regionABC = this.regionManager.getRegion(fqn1, false);
        AssertJUnit.assertNull((Object)regionABC.takeLastEventNode());
        this.cache.put(fqn1, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get(fqn1, (Object)"key"));
        Node<Object, Object> node = this.cast(this.cache.get(fqn1));
        AssertJUnit.assertNotNull(node);
        AssertJUnit.assertEquals((Object)"value", (Object)node.get((Object)"key"));
        this.cache.put(fqn3, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get(fqn3, (Object)"key"));
        node = this.cast(this.cache.get(fqn3));
        AssertJUnit.assertNotNull(node);
        AssertJUnit.assertEquals((Object)"value", (Object)node.get((Object)"key"));
        mc = MethodCallFactory.create((Method)MethodDeclarations.getNodeMethodLocal, (Object[])new Object[]{Fqn.fromString((String)fqn1)});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        regionABC = this.regionManager.getRegion(fqn1, false);
        EvictedEventNode event = regionABC.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((String)fqn1, (String)event.getFqn().toString());
        AssertJUnit.assertNull((Object)regionABC.takeLastEventNode());
        mc = MethodCallFactory.create((Method)MethodDeclarations.getNodeMethodLocal, (Object[])new Object[]{Fqn.fromString((String)fqn2)});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        Region regionAB = this.regionManager.getRegion(fqn2, false);
        event = regionAB.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((String)fqn2, (String)event.getFqn().toString());
        AssertJUnit.assertNull((Object)regionAB.takeLastEventNode());
        mc = MethodCallFactory.create((Method)MethodDeclarations.getDataMapMethodLocal, (Object[])new Object[]{Fqn.fromString((String)fqn3)});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        Region regionABD = this.regionManager.getRegion(fqn3, false);
        event = regionABD.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((String)fqn3, (String)event.getFqn().toString());
        AssertJUnit.assertNull((Object)regionABD.takeLastEventNode());
        for (i = 0; i < 10; ++i) {
            Fqn fqn = Fqn.fromString((String)fqn3);
            mc = MethodCallFactory.create((Method)MethodDeclarations.getNodeMethodLocal, (Object[])new Object[]{fqn});
            this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        }
        for (i = 0; i < 10; ++i) {
            Region region = this.regionManager.getRegion(fqn3, false);
            event = region.takeLastEventNode();
            AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
            AssertJUnit.assertEquals((String)fqn3, (String)event.getFqn().toString());
        }
        AssertJUnit.assertNull((Object)this.regionManager.getRegion(fqn3, false).takeLastEventNode());
        mc = MethodCallFactory.create((Method)MethodDeclarations.getDataMapMethodLocal, (Object[])new Object[]{null});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
    }

    public void testVisitElement() throws Throwable {
        int i;
        Fqn fqn = Fqn.fromString((String)fqn4);
        Object key = "key";
        MethodCall mc = MethodCallFactory.create((Method)MethodDeclarations.getKeyValueMethodLocal, (Object[])new Object[]{fqn, key, false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        Region region = this.regionManager.getRegion(fqn.toString(), false);
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        this.cache.put(fqn, (Object)"wrongkey", (Object)"");
        mc = MethodCallFactory.create((Method)MethodDeclarations.getKeyValueMethodLocal, (Object[])new Object[]{fqn, key, false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        mc = MethodCallFactory.create((Method)MethodDeclarations.getKeyValueMethodLocal, (Object[])new Object[]{fqn, "wrongkey", false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        EvictedEventNode event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        this.cache.put(fqn4, key, (Object)"value");
        fqn = Fqn.fromString((String)fqn4);
        mc = MethodCallFactory.create((Method)MethodDeclarations.getKeyValueMethodLocal, (Object[])new Object[]{fqn, key, false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        region = this.regionManager.getRegion(fqn.toString(), false);
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        fqn = Fqn.fromString((String)"/d/e/g");
        for (i = 0; i < 1000; ++i) {
            key = i;
            this.cache.put("/d/e/g", key, (Object)"");
            mc = MethodCallFactory.create((Method)MethodDeclarations.getKeyValueMethodLocal, (Object[])new Object[]{fqn, key, true});
            this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        }
        region = this.regionManager.getRegion(fqn.toString(), false);
        for (i = 0; i < 1000; ++i) {
            event = region.takeLastEventNode();
            AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
            AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        }
        this.cache.put(fqn1, key, (Object)"");
        fqn = Fqn.fromString((String)fqn1);
        mc = MethodCallFactory.create((Method)MethodDeclarations.getKeyValueMethodLocal, (Object[])new Object[]{fqn, key, false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        region = this.regionManager.getRegion(fqn.toString(), false);
        event = region.takeLastEventNode();
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        for (i = 0; i < 1000; ++i) {
            key = i;
            this.cache.put(fqn.toString(), key, (Object)"");
            mc = MethodCallFactory.create((Method)MethodDeclarations.getKeyValueMethodLocal, (Object[])new Object[]{fqn, key, true});
            this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        }
        for (i = 0; i < 1000; ++i) {
            event = region.takeLastEventNode();
            AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
            AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        }
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        mc = MethodCallFactory.create((Method)MethodDeclarations.getKeyValueMethodLocal, (Object[])new Object[]{null, key, true});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        mc = MethodCallFactory.create((Method)MethodDeclarations.getKeyValueMethodLocal, (Object[])new Object[]{null, null, true});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        mc = MethodCallFactory.create((Method)MethodDeclarations.getKeyValueMethodLocal, (Object[])new Object[]{fqn, null, true});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
    }

    public void testCreateNode() throws Throwable {
        int i;
        HashMap<Integer, Integer> data = new HashMap<Integer, Integer>();
        for (int i2 = 0; i2 < 100; ++i2) {
            data.put(i2, i2);
        }
        Fqn fqn = Fqn.fromString((String)fqn1);
        MethodCall mc = MethodCallFactory.create((Method)MethodDeclarations.putDataMethodLocal, (Object[])new Object[]{null, fqn, data, false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        Region region = this.regionManager.getRegion(fqn.toString(), false);
        EvictedEventNode event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.ADD_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((int)100, (int)event.getElementDifference());
        Node<Object, Object> node = this.cast(this.cache.get(fqn.toString()));
        AssertJUnit.assertNotNull(node);
        for (i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)node.getData().containsKey(i));
            AssertJUnit.assertEquals((Object)i, (Object)node.get((Object)i));
        }
        for (i = 0; i < 100; ++i) {
            mc = MethodCallFactory.create((Method)MethodDeclarations.putKeyValMethodLocal, (Object[])new Object[]{null, fqn, i, "value", false});
            this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
            AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get(fqn.toString(), (Object)i));
        }
        for (i = 0; i < 100; ++i) {
            event = region.takeLastEventNode();
            AssertJUnit.assertNotNull((Object)event);
            AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
            AssertJUnit.assertEquals((Object)NodeEventType.ADD_ELEMENT_EVENT, (Object)event.getEventType());
        }
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        fqn = Fqn.fromString((String)fqn2);
        mc = MethodCallFactory.create((Method)MethodDeclarations.putDataEraseMethodLocal, (Object[])new Object[]{null, fqn, data, false, false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        event = this.regionManager.getRegion(fqn.toString(), false).takeLastEventNode();
        AssertJUnit.assertFalse((boolean)event.isResetElementCount());
        AssertJUnit.assertEquals((Object)NodeEventType.ADD_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((int)100, (int)event.getElementDifference());
        AssertJUnit.assertNull((Object)this.regionManager.getRegion(fqn.toString(), false).takeLastEventNode());
        node = this.cast(this.cache.get(fqn.toString()));
        AssertJUnit.assertEquals((int)100, (int)node.getData().size());
        AssertJUnit.assertNotNull(node);
        for (i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)node.getData().containsKey(i));
            AssertJUnit.assertEquals((Object)i, (Object)node.get((Object)i));
        }
        mc = MethodCallFactory.create((Method)MethodDeclarations.putDataEraseMethodLocal, (Object[])new Object[]{null, fqn, data, false, true});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        event = this.regionManager.getRegion(fqn.toString(), false).takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.ADD_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((int)100, (int)event.getElementDifference());
        AssertJUnit.assertTrue((boolean)event.isResetElementCount());
        AssertJUnit.assertNull((Object)this.regionManager.getRegion(fqn.toString(), false).takeLastEventNode());
        node = this.cast(this.cache.get(fqn.toString()));
        AssertJUnit.assertEquals((int)100, (int)node.getData().size());
        AssertJUnit.assertNotNull(node);
        for (i = 0; i < 100; ++i) {
            AssertJUnit.assertTrue((boolean)node.getData().containsKey(i));
            AssertJUnit.assertEquals((Object)i, (Object)node.get((Object)i));
        }
    }

    public void testCreateElement() throws Throwable {
        Fqn fqn = Fqn.fromString((String)fqn4);
        Region region = this.regionManager.getRegion(fqn.toString(), false);
        String key = "key";
        String value = "value";
        MethodCall mc = MethodCallFactory.create((Method)MethodDeclarations.putKeyValMethodLocal, (Object[])new Object[]{null, fqn, key, value, false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get(fqn, (Object)key));
        EvictedEventNode event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.ADD_ELEMENT_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((int)1, (int)event.getElementDifference());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get(fqn, (Object)key));
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        mc = MethodCallFactory.create((Method)MethodDeclarations.putKeyValMethodLocal, (Object[])new Object[]{null, fqn, key, value, false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get(fqn, (Object)key));
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.ADD_ELEMENT_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((int)1, (int)event.getElementDifference());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get(fqn, (Object)key));
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
    }

    public void testRemoveNode() throws Throwable {
        Fqn fqn = Fqn.fromString((String)fqn1);
        this.cache.put(fqn, (Object)"a", (Object)"b");
        this.cache.put(fqn, (Object)"b", (Object)"c");
        MethodCall mc = MethodCallFactory.create((Method)MethodDeclarations.removeDataMethodLocal, (Object[])new Object[]{null, fqn, false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        AssertJUnit.assertEquals((int)0, (int)this.cache.get(fqn).getData().size());
        Region region = this.regionManager.getRegion(fqn.toString(), false);
        EvictedEventNode event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.REMOVE_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        mc = MethodCallFactory.create((Method)MethodDeclarations.removeNodeMethodLocal, (Object[])new Object[]{null, fqn, false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        AssertJUnit.assertNull((Object)this.cache.get(fqn));
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.REMOVE_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
    }

    public void testRemoveElement() throws Throwable {
        Fqn fqn = Fqn.fromString((String)fqn1);
        this.cache.put(fqn, (Object)"a", (Object)"b");
        this.cache.put(fqn, (Object)"b", (Object)"c");
        MethodCall mc = MethodCallFactory.create((Method)MethodDeclarations.removeKeyMethodLocal, (Object[])new Object[]{null, fqn, "a", false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)"a"));
        Region region = this.regionManager.getRegion(fqn.toString(), false);
        EvictedEventNode event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.REMOVE_ELEMENT_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((int)1, (int)event.getElementDifference());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        mc = MethodCallFactory.create((Method)MethodDeclarations.removeKeyMethodLocal, (Object[])new Object[]{null, fqn, "b", false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)"b"));
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.REMOVE_ELEMENT_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((int)1, (int)event.getElementDifference());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        mc = MethodCallFactory.create((Method)MethodDeclarations.removeKeyMethodLocal, (Object[])new Object[]{null, fqn, "b", false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        event = region.takeLastEventNode();
        AssertJUnit.assertNull((Object)event);
    }

    public void testMixedEvent() throws Throwable {
        HashMap<Integer, Integer> data = new HashMap<Integer, Integer>();
        for (int i = 0; i < 100; ++i) {
            data.put(i, i);
        }
        Fqn fqn = Fqn.fromString((String)fqn1);
        MethodCall mc = MethodCallFactory.create((Method)MethodDeclarations.putDataMethodLocal, (Object[])new Object[]{null, fqn, data, false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        Region region = this.regionManager.getRegion(fqn.toString(), false);
        EvictedEventNode event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.ADD_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((int)100, (int)event.getElementDifference());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        mc = MethodCallFactory.create((Method)MethodDeclarations.getNodeMethodLocal, (Object[])new Object[]{fqn});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        mc = MethodCallFactory.create((Method)MethodDeclarations.removeNodeMethodLocal, (Object[])new Object[]{null, fqn, false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        AssertJUnit.assertNull((Object)this.cache.get(fqn));
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.REMOVE_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        String key = "key";
        String value = "value";
        mc = MethodCallFactory.create((Method)MethodDeclarations.putKeyValMethodLocal, (Object[])new Object[]{null, fqn, key, value, false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get(fqn, (Object)key));
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.ADD_ELEMENT_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((int)1, (int)event.getElementDifference());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get(fqn, (Object)key));
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        mc = MethodCallFactory.create((Method)MethodDeclarations.getKeyValueMethodLocal, (Object[])new Object[]{fqn, key, false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        region = this.regionManager.getRegion(fqn.toString(), false);
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.VISIT_NODE_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
        mc = MethodCallFactory.create((Method)MethodDeclarations.removeKeyMethodLocal, (Object[])new Object[]{null, fqn, key, false});
        this.interceptor.invoke(InvocationContext.fromMethodCall((MethodCall)mc));
        AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)key));
        event = region.takeLastEventNode();
        AssertJUnit.assertEquals((Object)NodeEventType.REMOVE_ELEMENT_EVENT, (Object)event.getEventType());
        AssertJUnit.assertEquals((Object)fqn, (Object)event.getFqn());
        AssertJUnit.assertEquals((int)1, (int)event.getElementDifference());
        AssertJUnit.assertNull((Object)region.takeLastEventNode());
    }
}

