/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.jmx;

import java.util.EnumSet;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import junit.framework.AssertionFailedError;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.jmx.CacheJmxWrapper;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class NotificationTest {
    protected static final String CLUSTER_NAME = "NotificationTestCluster";
    protected static final String CAPITAL = "capital";
    protected static final String CURRENCY = "currency";
    protected static final String POPULATION = "population";
    protected static final String EUROPE_NODE = "Europe";
    protected MBeanServer m_server;
    protected EnumSet<Type> events = EnumSet.noneOf(Type.class);
    protected CacheImpl<Object, Object> cache = null;
    protected boolean optimistic = false;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.m_server = MBeanServerFactory.createMBeanServer();
        Object cacheMBean = this.createCacheAndJmxWrapper();
        ObjectName mgmt = this.getWrapperObjectName();
        this.m_server.registerMBean(cacheMBean, mgmt);
    }

    protected Object createCacheAndJmxWrapper() throws Exception {
        this.cache = this.createCache(CLUSTER_NAME);
        return new CacheJmxWrapper(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        try {
            this.cleanup();
        }
        finally {
            if (this.m_server != null) {
                MBeanServerFactory.releaseMBeanServer(this.m_server);
            }
        }
    }

    protected void cleanup() throws Exception {
        ObjectName mgmt;
        this.events.clear();
        this.destroyCache();
        if (this.m_server != null && this.m_server.isRegistered(mgmt = this.getWrapperObjectName())) {
            this.m_server.unregisterMBean(mgmt);
        }
    }

    protected void destroyCache() {
        if (this.cache != null) {
            this.cache.destroy();
            this.cache = null;
        }
    }

    protected ObjectName getWrapperObjectName() throws Exception {
        return new ObjectName("jboss.cache:service=JBossCache,cluster=NotificationTestCluster");
    }

    public void testNotifications() throws Exception {
        AssertJUnit.assertNotNull((String)"MBeanServer is null.", (Object)this.m_server);
        AssertJUnit.assertNotNull((String)"Cache is null.", this.cache);
        ObjectName mgmt = this.getWrapperObjectName();
        MyListener listener = new MyListener(mgmt);
        this.m_server.addNotificationListener(mgmt, listener, null, null);
        this.cache.start();
        HashMap<String, String> albania = new HashMap<String, String>(4);
        albania.put(CAPITAL, "Tirana");
        albania.put(CURRENCY, "Lek");
        this.cache.put("Europe/Albania", albania);
        this.cache.put("Europe/Albania", (Object)POPULATION, (Object)3563112);
        Fqn key = Fqn.fromString((String)"Europe/Albania");
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve currency for " + key), (Object)this.cache.get(key, (Object)CURRENCY));
        this.cache.evict(key);
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve currency for " + key), (Object)this.cache.get(key, (Object)CURRENCY));
        this.cache.remove(key);
        CacheLoader cl = this.cache.getCacheLoader();
        cl.remove(Fqn.fromString((String)EUROPE_NODE));
        this.cache.stop();
        this.m_server.removeNotificationListener(mgmt, listener);
        AssertJUnit.assertTrue((String)"Expected CacheStarted notification", (boolean)this.events.contains((Object)Type.STARTED));
        AssertJUnit.assertTrue((String)"Expected CacheStopped notification", (boolean)this.events.contains((Object)Type.STOPPED));
        AssertJUnit.assertTrue((String)"Expected NodeCreated notification", (boolean)this.events.contains((Object)Type.PRECREATE));
        AssertJUnit.assertTrue((String)"Expected NodeCreated notification", (boolean)this.events.contains((Object)Type.POSTCREATE));
        AssertJUnit.assertTrue((String)"Expected NodeEvicted notification", (boolean)this.events.contains((Object)Type.PREEVICT));
        AssertJUnit.assertTrue((String)"Expected NodeEvicted notification", (boolean)this.events.contains((Object)Type.POSTEVICT));
        AssertJUnit.assertTrue((String)"Expected NodeLoaded notification", (boolean)this.events.contains((Object)Type.PRELOAD));
        AssertJUnit.assertTrue((String)"Expected NodeLoaded notification", (boolean)this.events.contains((Object)Type.POSTLOAD));
        AssertJUnit.assertTrue((String)"Expected NodeVisited notification", (boolean)this.events.contains((Object)Type.PREVISIT));
        AssertJUnit.assertTrue((String)"Expected NodeVisited notification", (boolean)this.events.contains((Object)Type.POSTVISIT));
        AssertJUnit.assertTrue((String)"Expected NodeActivated notification", (boolean)this.events.contains((Object)Type.PREACTIVATE));
        AssertJUnit.assertTrue((String)"Expected NodeActivated notification", (boolean)this.events.contains((Object)Type.POSTACTIVATE));
        AssertJUnit.assertTrue((String)"Expected NodeModified notification", (boolean)this.events.contains((Object)Type.PREMODIFY));
        AssertJUnit.assertTrue((String)"Expected NodeModified notification", (boolean)this.events.contains((Object)Type.POSTMODIFY));
        AssertJUnit.assertTrue((String)"Expected NodePassivated notification", (boolean)this.events.contains((Object)Type.PREPASSIVATE));
        AssertJUnit.assertTrue((String)"Expected NodePassivated notification", (boolean)this.events.contains((Object)Type.POSTPASSIVATE));
        AssertJUnit.assertTrue((String)"Expected NodeRemoved notification", (boolean)this.events.contains((Object)Type.PREREMOVE));
        AssertJUnit.assertTrue((String)"Expected NodeRemoved notification", (boolean)this.events.contains((Object)Type.POSTREMOVE));
        AssertJUnit.assertTrue((String)"Expected ViewChange notification", (boolean)this.events.contains((Object)Type.VIEWCHANGE));
        NotificationTest.validateHealthyListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEarlyRegistration() throws Exception {
        this.cleanup();
        CacheJmxWrapper wrapper = new CacheJmxWrapper();
        ObjectName mgmt = this.getWrapperObjectName();
        this.m_server.registerMBean(wrapper, mgmt);
        MyListener listener = new MyListener(mgmt);
        this.m_server.addNotificationListener(mgmt, listener, null, null);
        this.cache = this.createCache(CLUSTER_NAME);
        wrapper.setCache(this.cache);
        this.cache.start();
        try {
            AssertJUnit.assertTrue((String)"Expected CacheStarted notification", (boolean)this.events.contains((Object)Type.STARTED));
            NotificationTest.validateHealthyListener(listener);
        }
        finally {
            this.cache.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLateRegistration() throws Exception {
        AssertJUnit.assertNotNull((String)"MBeanServer is null.", (Object)this.m_server);
        AssertJUnit.assertNotNull((String)"Cache is null.", this.cache);
        this.cache.start();
        try {
            ObjectName mgmt = this.getWrapperObjectName();
            MyListener listener = new MyListener(mgmt);
            this.m_server.addNotificationListener(mgmt, listener, null, null);
            HashMap<String, String> albania = new HashMap<String, String>(4);
            albania.put(CAPITAL, "Tirana");
            albania.put(CURRENCY, "Lek");
            this.cache.put("Europe/Albania", albania);
            AssertJUnit.assertTrue((String)"Expected NodeModified notification", (boolean)this.events.contains((Object)Type.PREMODIFY));
            AssertJUnit.assertTrue((String)"Expected NodeModified notification", (boolean)this.events.contains((Object)Type.POSTMODIFY));
            NotificationTest.validateHealthyListener(listener);
        }
        finally {
            this.cache.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListenerRemoval() throws Exception {
        AssertJUnit.assertNotNull((String)"MBeanServer is null.", (Object)this.m_server);
        AssertJUnit.assertNotNull((String)"Cache is null.", this.cache);
        ObjectName mgmt = this.getWrapperObjectName();
        MyListener listener = new MyListener(mgmt);
        this.m_server.addNotificationListener(mgmt, listener, null, null);
        this.cache.start();
        boolean ok = false;
        try {
            AssertJUnit.assertTrue((String)"Expected CacheStarted notification", (boolean)this.events.contains((Object)Type.STARTED));
            this.m_server.removeNotificationListener(mgmt, listener);
            ok = true;
        }
        finally {
            this.cache.stop();
            if (ok) {
                AssertJUnit.assertFalse((String)"Expected no CacheStopped notification", (boolean)this.events.contains((Object)Type.STOPPED));
                NotificationTest.validateHealthyListener(listener);
            }
        }
    }

    private CacheImpl<Object, Object> createCache(String clusterName) throws Exception {
        Configuration config = this.createConfiguration(clusterName);
        CacheFactory factory = DefaultCacheFactory.getInstance();
        CacheImpl cache = (CacheImpl)factory.createCache(config, false);
        cache.create();
        return cache;
    }

    protected Configuration createConfiguration(String clusterName) throws Exception {
        Configuration config = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC);
        config.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        config.setCacheLoaderConfig(NotificationTest.getCacheLoaderConfig("location=" + NotificationTest.getTempDir()));
        config.setExposeManagementStatistics(true);
        config.setClusterName(clusterName);
        if (this.optimistic) {
            config.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
            config.setNodeLockingScheme("OPTIMISTIC");
        }
        return config;
    }

    private static String getTempDir() {
        return System.getProperty("java.io.tempdir", "/tmp");
    }

    private static boolean getPre(Object data) {
        AssertJUnit.assertNotNull((String)"User data is null, should be Object[]", (Object)data);
        AssertJUnit.assertTrue((String)("User data is " + data.getClass().getName() + ", should be Object[]"), (boolean)(data instanceof Object[]));
        Object[] parms = (Object[])data;
        AssertJUnit.assertTrue((String)("Parameter is " + parms[1].getClass().getName() + ", should be Boolean"), (boolean)(parms[1] instanceof Boolean));
        return (Boolean)parms[1];
    }

    protected static CacheLoaderConfig getCacheLoaderConfig(String properties) throws Exception {
        String xml = "<config>\n<passivation>true</passivation>\n<preload></preload>\n<shared>true</shared>\n<cacheloader>\n<class>org.jboss.cache.loader.FileCacheLoader</class>\n<properties>" + properties + "</properties>\n" + "<async>false</async>\n" + "<fetchPersistentState>false</fetchPersistentState>\n" + "<ignoreModifications>false</ignoreModifications>\n" + "</cacheloader>\n" + "</config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }

    private static void validateHealthyListener(MyListener listener) {
        if (listener.failure != null) {
            throw listener.failure;
        }
        if (listener.exception != null) {
            throw listener.exception;
        }
    }

    private class MyListener
    implements NotificationListener {
        private RuntimeException exception;
        private AssertionFailedError failure;
        private final String emitterObjectName;

        MyListener(ObjectName emitter) {
            this.emitterObjectName = emitter.getCanonicalName();
        }

        public void handleNotification(Notification notification, Object handback) {
            try {
                String type = notification.getType();
                Object userData = notification.getUserData();
                if (type.equals("org.jboss.cache.CacheStarted")) {
                    NotificationTest.this.events.add(Type.STARTED);
                    AssertJUnit.assertEquals((String)"Correct object name in start notification", (Object)this.emitterObjectName, (Object)userData);
                } else if (type.equals("org.jboss.cache.CacheStopped")) {
                    NotificationTest.this.events.add(Type.STOPPED);
                    AssertJUnit.assertEquals((String)"Correct object name in stop notification", (Object)this.emitterObjectName, (Object)userData);
                } else if (type.equals("org.jboss.cache.NodeCreated")) {
                    if (NotificationTest.getPre(userData)) {
                        NotificationTest.this.events.add(Type.PRECREATE);
                    } else {
                        NotificationTest.this.events.add(Type.POSTCREATE);
                    }
                } else if (type.equals("org.jboss.cache.NodeEvicted")) {
                    if (NotificationTest.getPre(userData)) {
                        NotificationTest.this.events.add(Type.PREEVICT);
                    } else {
                        NotificationTest.this.events.add(Type.POSTEVICT);
                    }
                } else if (type.equals("org.jboss.cache.NodeLoaded")) {
                    if (NotificationTest.getPre(userData)) {
                        NotificationTest.this.events.add(Type.PRELOAD);
                    } else {
                        NotificationTest.this.events.add(Type.POSTLOAD);
                    }
                } else if (type.equals("org.jboss.cache.NodeRemoved")) {
                    if (NotificationTest.getPre(userData)) {
                        NotificationTest.this.events.add(Type.PREREMOVE);
                    } else {
                        NotificationTest.this.events.add(Type.POSTREMOVE);
                    }
                } else if (type.equals("org.jboss.cache.NodeVisited")) {
                    if (NotificationTest.getPre(userData)) {
                        NotificationTest.this.events.add(Type.PREVISIT);
                    } else {
                        NotificationTest.this.events.add(Type.POSTVISIT);
                    }
                } else if (type.equals("org.jboss.cache.ViewChanged")) {
                    NotificationTest.this.events.add(Type.VIEWCHANGE);
                } else if (type.equals("org.jboss.cache.NodeActivated")) {
                    if (NotificationTest.getPre(userData)) {
                        NotificationTest.this.events.add(Type.PREACTIVATE);
                    } else {
                        NotificationTest.this.events.add(Type.POSTACTIVATE);
                    }
                } else if (type.equals("org.jboss.cache.NodeModified")) {
                    if (NotificationTest.getPre(userData)) {
                        NotificationTest.this.events.add(Type.PREMODIFY);
                    } else {
                        NotificationTest.this.events.add(Type.POSTMODIFY);
                    }
                } else if (type.equals("org.jboss.cache.NodePassivated")) {
                    if (NotificationTest.getPre(userData)) {
                        NotificationTest.this.events.add(Type.PREPASSIVATE);
                    } else {
                        NotificationTest.this.events.add(Type.POSTPASSIVATE);
                    }
                }
            }
            catch (RuntimeException e) {
                this.exception = e;
            }
            catch (AssertionFailedError e) {
                this.failure = e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        STARTED,
        STOPPED,
        PRECREATE,
        POSTCREATE,
        PREEVICT,
        POSTEVICT,
        PRELOAD,
        POSTLOAD,
        PREREMOVE,
        POSTREMOVE,
        PREVISIT,
        POSTVISIT,
        PREMODIFY,
        POSTMODIFY,
        PREACTIVATE,
        POSTACTIVATE,
        PREPASSIVATE,
        POSTPASSIVATE,
        VIEWCHANGE;

    }
}

