/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.loader.JDBCCacheLoader;
import org.jboss.cache.loader.JDBCCacheLoaderOld;
import org.jboss.cache.statetransfer.StateTransferManager;
import org.jboss.cache.xml.XmlHelper;
import org.jboss.util.stream.MarshalledValueInputStream;
import org.jboss.util.stream.MarshalledValueOutputStream;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public class AdjListJDBCCacheLoaderCompatibilityTest {
    private JDBCCacheLoaderOld oldImpl;
    private JDBCCacheLoader newImpl;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.newImpl = this.getNewCacheLoader();
        this.oldImpl = this.getOldLoader();
        CacheImpl cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        CacheImpl cache2 = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        this.newImpl.setCache((CacheSPI)cache);
        this.oldImpl.setCache((CacheSPI)cache2);
        this.oldImpl.start();
        this.oldImpl.remove(Fqn.ROOT);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.oldImpl.remove(Fqn.ROOT);
        this.oldImpl.stop();
        this.newImpl.stop();
    }

    public void testCommonOperations() throws Exception {
        this.newImpl.start();
        this.oldImpl.put(Fqn.fromString((String)"/a/b/c"), (Object)"key1", (Object)"value1");
        this.oldImpl.put(Fqn.fromString((String)"/a/b/d"), (Object)"key2", (Object)"value2");
        this.oldImpl.put(Fqn.fromString((String)"/a/b/e"), (Object)"key3", (Object)"value3");
        AssertJUnit.assertTrue((boolean)this.newImpl.exists(Fqn.fromString((String)"/a/b/c")));
        AssertJUnit.assertTrue((boolean)this.newImpl.exists(Fqn.fromString((String)"/a/b/d")));
        AssertJUnit.assertTrue((boolean)this.newImpl.exists(Fqn.fromString((String)"/a/b/e")));
        AssertJUnit.assertEquals((Object)"value1", this.newImpl.get(Fqn.fromString((String)"/a/b/c")).get("key1"));
        AssertJUnit.assertEquals((Object)"value2", this.newImpl.get(Fqn.fromString((String)"/a/b/d")).get("key2"));
        AssertJUnit.assertEquals((Object)"value3", this.newImpl.get(Fqn.fromString((String)"/a/b/e")).get("key3"));
    }

    public void testRemove() throws Exception {
        this.oldImpl.put(Fqn.fromString((String)"/a/b/c"), (Object)"key1", (Object)"value1");
        this.oldImpl.put(Fqn.fromString((String)"/a/b/d"), (Object)"key2", (Object)"value2");
        this.oldImpl.put(Fqn.fromString((String)"/a/b/e"), (Object)"key3", (Object)"value3");
        this.oldImpl.put(Fqn.fromString((String)"/a/f/e"), (Object)"key4", (Object)"value4");
        AssertJUnit.assertTrue((boolean)this.newImpl.exists(Fqn.fromString((String)"/a/b/c")));
        AssertJUnit.assertTrue((boolean)this.newImpl.exists(Fqn.fromString((String)"/a/b/d")));
        AssertJUnit.assertTrue((boolean)this.newImpl.exists(Fqn.fromString((String)"/a/b/e")));
        this.newImpl.start();
        this.newImpl.remove(Fqn.fromString((String)"/a/b"));
        AssertJUnit.assertFalse((boolean)this.newImpl.exists(Fqn.fromString((String)"/a/b/c")));
        AssertJUnit.assertFalse((boolean)this.newImpl.exists(Fqn.fromString((String)"/a/b/d")));
        AssertJUnit.assertFalse((boolean)this.newImpl.exists(Fqn.fromString((String)"/a/b/e")));
        AssertJUnit.assertTrue((boolean)this.newImpl.exists(Fqn.fromString((String)"/a/f")));
        AssertJUnit.assertTrue((boolean)this.newImpl.exists(Fqn.fromString((String)"/a/f/e")));
    }

    public void testLoadEntireState() throws Exception {
        this.oldImpl.put(Fqn.fromString((String)"/a/b/c"), (Object)"key1", (Object)"value1");
        this.oldImpl.put(Fqn.fromString((String)"/a/b/d"), (Object)"key2", (Object)"value2");
        this.oldImpl.put(Fqn.fromString((String)"/a/b/e"), (Object)"key3", (Object)"value3");
        this.oldImpl.put(Fqn.fromString((String)"/a/f/e"), (Object)"key4", (Object)"value4");
        this.oldImpl.put(Fqn.ROOT, (Object)"root_key", (Object)"root_value");
        ByteArrayOutputStream newBaos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream newOs = new MarshalledValueOutputStream((OutputStream)newBaos);
        this.newImpl.start();
        this.newImpl.loadEntireState((ObjectOutputStream)newOs);
        this.newImpl.getMarshaller().objectToObjectStream((Object)StateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)newOs);
        newOs.close();
        this.newImpl.remove(Fqn.ROOT);
        AssertJUnit.assertNull((Object)this.newImpl.get(Fqn.fromString((String)"/a/b/c")));
        AssertJUnit.assertNull((Object)this.newImpl.get(Fqn.fromString((String)"/a/b/d")));
        AssertJUnit.assertNull((Object)this.newImpl.get(Fqn.fromString((String)"/a/b/e")));
        AssertJUnit.assertNull((Object)this.newImpl.get(Fqn.fromString((String)"/a/f/e")));
        AssertJUnit.assertNull((Object)this.newImpl.get(Fqn.ROOT));
        ByteArrayInputStream bais = new ByteArrayInputStream(newBaos.toByteArray());
        MarshalledValueInputStream is = new MarshalledValueInputStream((InputStream)bais);
        this.newImpl.storeEntireState((ObjectInputStream)is);
        AssertJUnit.assertEquals(this.newImpl.get(Fqn.fromString((String)"/a/b/c")).get("key1"), (Object)"value1");
        AssertJUnit.assertEquals(this.newImpl.get(Fqn.fromString((String)"/a/b/d")).get("key2"), (Object)"value2");
        AssertJUnit.assertEquals(this.newImpl.get(Fqn.fromString((String)"/a/b/e")).get("key3"), (Object)"value3");
        AssertJUnit.assertEquals(this.newImpl.get(Fqn.fromString((String)"/a/f/e")).get("key4"), (Object)"value4");
        AssertJUnit.assertEquals(this.newImpl.get(Fqn.ROOT).get("root_key"), (Object)"root_value");
        AssertJUnit.assertEquals((int)this.newImpl.getNodeCount(), (int)8);
    }

    public void testLoadNodeState() throws Exception {
        this.oldImpl.put(Fqn.fromString((String)"/a/b/c"), (Object)"key1", (Object)"value1");
        this.oldImpl.put(Fqn.fromString((String)"/a/b/d"), (Object)"key2", (Object)"value2");
        this.oldImpl.put(Fqn.fromString((String)"/a/b/e"), (Object)"key3", (Object)"value3");
        this.oldImpl.put(Fqn.fromString((String)"/a/f/e"), (Object)"key4", (Object)"value4");
        this.oldImpl.put(Fqn.ROOT, (Object)"root_key", (Object)"root_value");
        ByteArrayOutputStream newBaos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream newOs = new MarshalledValueOutputStream((OutputStream)newBaos);
        this.newImpl.start();
        this.newImpl.loadState(Fqn.fromString((String)"/a/b"), (ObjectOutputStream)newOs);
        this.newImpl.getMarshaller().objectToObjectStream((Object)StateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)newOs);
        newOs.close();
        this.newImpl.remove(Fqn.fromString((String)"/a/b"));
        AssertJUnit.assertNull((Object)this.newImpl.get(Fqn.fromString((String)"/a/b/c")));
        AssertJUnit.assertNull((Object)this.newImpl.get(Fqn.fromString((String)"/a/b/d")));
        AssertJUnit.assertNull((Object)this.newImpl.get(Fqn.fromString((String)"/a/b/e")));
        AssertJUnit.assertNull((Object)this.newImpl.get(Fqn.fromString((String)"/a/b")));
        ByteArrayInputStream bais = new ByteArrayInputStream(newBaos.toByteArray());
        MarshalledValueInputStream is = new MarshalledValueInputStream((InputStream)bais);
        this.newImpl.storeState(Fqn.fromString((String)"/a/b"), (ObjectInputStream)is);
        AssertJUnit.assertEquals(this.newImpl.get(Fqn.fromString((String)"/a/b/c")).get("key1"), (Object)"value1");
        AssertJUnit.assertEquals(this.newImpl.get(Fqn.fromString((String)"/a/b/d")).get("key2"), (Object)"value2");
        AssertJUnit.assertEquals(this.newImpl.get(Fqn.fromString((String)"/a/b/e")).get("key3"), (Object)"value3");
        AssertJUnit.assertEquals(this.newImpl.get(Fqn.fromString((String)"/a/f/e")).get("key4"), (Object)"value4");
        AssertJUnit.assertEquals(this.newImpl.get(Fqn.ROOT).get("root_key"), (Object)"root_value");
        AssertJUnit.assertEquals((int)this.newImpl.getNodeCount(), (int)8);
    }

    public void testGetNodeData() throws Exception {
        this.oldImpl.put(Fqn.fromString((String)"/a/b/c"), (Object)"key1", (Object)"value1");
        this.oldImpl.put(Fqn.fromString((String)"/a/b/d"), (Object)"key2", (Object)"value2");
        this.oldImpl.put(Fqn.fromString((String)"/a/b/e"), (Object)"key3", (Object)"value3");
        this.oldImpl.put(Fqn.fromString((String)"/a/f/e"), (Object)"key4", (Object)"value4");
        this.oldImpl.put(Fqn.ROOT, (Object)"root_key", (Object)"root_value");
        this.newImpl.start();
        ArrayList oldList = new ArrayList();
        this.oldImpl.getNodeDataList(Fqn.ROOT, oldList);
        ArrayList newList = new ArrayList();
        this.newImpl.getNodeDataList(Fqn.ROOT, newList);
        AssertJUnit.assertEquals(new HashSet(oldList), new HashSet(newList));
    }

    public void testStartWork() throws Exception {
        this.oldImpl.put(Fqn.fromString((String)"/a/b/c"), (Object)"key1", (Object)"value1");
        this.oldImpl.put(Fqn.fromString((String)"/a/b/d"), (Object)"key2", (Object)"value2");
        AssertJUnit.assertNull((Object)this.oldImpl.get(Fqn.ROOT));
        this.newImpl.start();
        AssertJUnit.assertNotNull((Object)this.newImpl.get(Fqn.ROOT));
    }

    protected CacheLoaderConfig getSingleCacheLoaderConfig(String preload, String cacheloaderClass, String properties) throws Exception {
        String xml = "<config>\n<passivation>false</passivation>\n<preload>" + preload + "</preload>\n" + "<cacheloader>\n" + "<class>" + cacheloaderClass + "</class>\n" + "<properties>" + properties + "</properties>\n" + "<async>false</async>\n" + "<shared>false</shared>\n" + "<fetchPersistentState>true</fetchPersistentState>\n" + "<purgeOnStartup>false</purgeOnStartup>\n" + "</cacheloader>\n" + "</config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }

    protected Properties getProperties() throws Exception {
        Properties prop = new Properties();
        try {
            prop.load(this.getClass().getClassLoader().getResourceAsStream("cache-jdbc.properties"));
            return prop;
        }
        catch (Exception e) {
            throw new Exception("Error loading jdbc properties ", e);
        }
    }

    private JDBCCacheLoader getNewCacheLoader() throws Exception {
        Properties prop = this.getProperties();
        String props = "cache.jdbc.driver =" + prop.getProperty("cache.jdbc.driver") + "\n" + "cache.jdbc.url=" + prop.getProperty("cache.jdbc.url") + "\n" + "cache.jdbc.user=" + prop.getProperty("cache.jdbc.user") + "\n" + "cache.jdbc.password=" + prop.getProperty("cache.jdbc.password") + "\n" + "cache.jdbc.node.type=" + prop.getProperty("cache.jdbc.node.type") + "\n" + "cache.jdbc.sql-concat=" + prop.getProperty("cache.jdbc.sql-concat") + "\n";
        CacheLoaderConfig.IndividualCacheLoaderConfig base = this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.JDBCCacheLoader", props).getFirstCacheLoaderConfig();
        JDBCCacheLoader jdbcCacheLoader = new JDBCCacheLoader();
        jdbcCacheLoader.setConfig(base);
        return jdbcCacheLoader;
    }

    private JDBCCacheLoaderOld getOldLoader() throws Exception {
        Properties prop = this.getProperties();
        String props = "cache.jdbc.driver =" + prop.getProperty("cache.jdbc.driver") + "\n" + "cache.jdbc.url=" + prop.getProperty("cache.jdbc.url") + "\n" + "cache.jdbc.user=" + prop.getProperty("cache.jdbc.user") + "\n" + "cache.jdbc.password=" + prop.getProperty("cache.jdbc.password") + "\n" + "cache.jdbc.node.type=" + prop.getProperty("cache.jdbc.node.type") + "\n" + "cache.jdbc.sql-concat=" + prop.getProperty("cache.jdbc.sql-concat");
        CacheLoaderConfig.IndividualCacheLoaderConfig base = this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.JDBCCacheLoader", props).getFirstCacheLoaderConfig();
        JDBCCacheLoaderOld jdbcCacheLoader = new JDBCCacheLoaderOld();
        jdbcCacheLoader.setConfig(base);
        return jdbcCacheLoader;
    }
}

