/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.DummyCacheLoader;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class CacheLoaderMethodCallCounterTest
extends AbstractCacheLoaderTestBase {
    private CacheImpl<Object, Object> cache;
    private DummyCacheLoader dummyLoader;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        if (this.cache != null) {
            this.tearDown();
        }
        this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        this.cache.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", DummyCacheLoader.class.getName(), "", false, false, false));
        this.cache.start();
        this.dummyLoader = (DummyCacheLoader)this.cache.getCacheLoaderManager().getCacheLoader();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache != null) {
            this.cache.stop();
        }
        this.cache.destroy();
        this.cache = null;
    }

    public void testPut() throws Exception {
        this.cache.put("/node", (Object)"key", (Object)"value");
        this.printReport("putKeyValue", this.dummyLoader);
    }

    public void testGet() throws Exception {
        this.cache.get("/node", (Object)"key");
        this.printReport("getKey", this.dummyLoader);
    }

    public void testRemove() throws Exception {
        this.cache.remove("/node", (Object)"key");
        this.printReport("removeKey", this.dummyLoader);
    }

    private void printReport(String test, DummyCacheLoader d) {
        System.out.println("------------------------------");
        System.out.println(" Test name: " + test);
        System.out.println("  cache loader stats:");
        System.out.println("   put count: " + d.getPutCount());
        System.out.println("   get count: " + d.getGetCount());
        System.out.println("   exists count: " + d.getExistsCount());
        System.out.println("   remove count: " + d.getRemoveCount());
        System.out.println("   getChildrenNames count: " + d.getGetChildrenNamesCount());
        System.out.println("------------------------------");
    }

    public void testLoopedGets() throws Exception {
        this.cache.put("/test", (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((int)1, (int)this.dummyLoader.getPutCount());
        AssertJUnit.assertEquals((int)1, (int)this.dummyLoader.getGetCount());
        for (int i = 0; i < 2000; ++i) {
            this.cache.get("/test");
        }
        AssertJUnit.assertEquals((int)1, (int)this.dummyLoader.getPutCount());
        AssertJUnit.assertEquals((int)1, (int)this.dummyLoader.getGetCount());
        AssertJUnit.assertEquals((int)0, (int)this.dummyLoader.getRemoveCount());
        AssertJUnit.assertEquals((int)0, (int)this.dummyLoader.getExistsCount());
    }
}

