/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import javax.transaction.TransactionManager;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.loader.AbstractDelegatingCacheLoader;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.ChainingCacheLoader;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public class ChainingCacheLoaderFullTest {
    private CacheImpl<Object, Object> cache;
    private ChainingCacheLoader chainingCacheLoader;
    private CacheLoader loader1;
    private CacheLoader loader2;
    private Fqn fqn = Fqn.fromString((String)"/a/b");
    private String key = "key";
    private String value = "value";

    protected void startCache(boolean ignoreMods1, boolean ignoreMods2) throws Exception {
        this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(ignoreMods1, ignoreMods2));
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.start();
        this.chainingCacheLoader = (ChainingCacheLoader)this.cache.getCacheLoaderManager().getCacheLoader();
        this.loader1 = (CacheLoader)this.chainingCacheLoader.getCacheLoaders().get(0);
        this.loader2 = (CacheLoader)this.chainingCacheLoader.getCacheLoaders().get(1);
        while (this.loader1 instanceof AbstractDelegatingCacheLoader) {
            this.loader1 = ((AbstractDelegatingCacheLoader)this.loader1).getCacheLoader();
        }
        while (this.loader2 instanceof AbstractDelegatingCacheLoader) {
            this.loader2 = ((AbstractDelegatingCacheLoader)this.loader2).getCacheLoader();
        }
    }

    protected void cleanup() throws Exception {
        this.cache.remove("/");
        this.cache.stop();
        this.cache = null;
    }

    protected CacheLoaderConfig getCacheLoaderConfig(boolean ignoreMods1, boolean ignoreMods2) throws Exception {
        String xml = "<config>\n<passivation>false</passivation>\n<preload></preload>\n<cacheloader>\n<class>" + DummyInMemoryCacheLoader.class.getName() + "</class>\n" + "<properties>" + "</properties>\n" + "<async>false</async>\n" + "<fetchPersistentState>true</fetchPersistentState>\n" + "<ignoreModifications>" + ignoreMods1 + "</ignoreModifications>\n" + "</cacheloader>\n" + "<cacheloader>\n" + "<class>" + DummyInMemoryCacheLoader.class.getName() + "</class>\n" + "<properties>" + "</properties>\n" + "<async>false</async>\n" + "<fetchPersistentState>false</fetchPersistentState>\n" + "<ignoreModifications>" + ignoreMods2 + "</ignoreModifications>\n" + "</cacheloader>\n" + "</config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }

    public void testCruds() throws Exception {
        this.startCache(false, false);
        this.cache.put(this.fqn, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, this.chainingCacheLoader.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader2.get(this.fqn).get(this.key));
        this.cache.evict(this.fqn);
        AssertJUnit.assertEquals((Object)this.value, this.chainingCacheLoader.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader2.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        this.cache.remove(this.fqn);
        AssertJUnit.assertNull((String)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((String)this.value, (Object)this.chainingCacheLoader.get(this.fqn));
        AssertJUnit.assertNull((String)this.value, (Object)this.loader1.get(this.fqn));
        AssertJUnit.assertNull((String)this.value, (Object)this.loader2.get(this.fqn));
        this.cleanup();
    }

    public void testGets() throws Exception {
        this.startCache(false, false);
        this.cache.put(this.fqn, (Object)this.key, (Object)this.value);
        this.cache.evict(this.fqn);
        this.loader1.put(this.fqn, (Object)this.key, (Object)(this.value + 2));
        AssertJUnit.assertEquals((Object)this.value, this.loader2.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)(this.value + 2), this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)(this.value + 2), this.chainingCacheLoader.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)(this.value + 2), (Object)this.cache.get(this.fqn, (Object)this.key));
        this.cache.remove("/");
        this.cache.put(this.fqn, (Object)this.key, (Object)this.value);
        this.cache.evict(this.fqn);
        this.loader2.put(this.fqn, (Object)this.key, (Object)(this.value + 2));
        AssertJUnit.assertEquals((Object)(this.value + 2), this.loader2.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.chainingCacheLoader.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        this.cache.remove("/");
        this.cache.put(this.fqn, (Object)this.key, (Object)this.value);
        this.cache.evict(this.fqn);
        this.loader1.remove(this.fqn);
        AssertJUnit.assertNull((Object)this.loader1.get(this.fqn));
        AssertJUnit.assertEquals((Object)this.value, this.loader2.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.chainingCacheLoader.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        this.cleanup();
    }

    public void testIgnoreMods() throws Exception {
        this.startCache(false, true);
        this.loader1.put(this.fqn, (Object)this.key, (Object)this.value);
        this.loader2.put(this.fqn, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, this.chainingCacheLoader.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader2.get(this.fqn).get(this.key));
        this.cache.put(this.fqn, (Object)this.key, (Object)(this.value + 2));
        AssertJUnit.assertEquals((Object)(this.value + 2), (Object)this.cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)(this.value + 2), this.chainingCacheLoader.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)(this.value + 2), this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader2.get(this.fqn).get(this.key));
        this.cache.remove(this.fqn);
        AssertJUnit.assertEquals((Object)this.value, this.chainingCacheLoader.get(this.fqn).get(this.key));
        AssertJUnit.assertNull((Object)this.loader1.get(this.fqn));
        AssertJUnit.assertEquals((Object)this.value, this.loader2.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        this.cleanup();
    }

    public void testIgnoreModsTransactional() throws Exception {
        this.startCache(false, true);
        TransactionManager mgr = this.cache.getTransactionManager();
        this.loader1.put(this.fqn, (Object)this.key, (Object)this.value);
        this.loader2.put(this.fqn, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, this.chainingCacheLoader.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader2.get(this.fqn).get(this.key));
        mgr.begin();
        this.cache.put(this.fqn, (Object)this.key, (Object)(this.value + 2));
        AssertJUnit.assertEquals((Object)(this.value + 2), (Object)this.cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, this.chainingCacheLoader.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader2.get(this.fqn).get(this.key));
        mgr.commit();
        AssertJUnit.assertEquals((Object)(this.value + 2), (Object)this.cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)(this.value + 2), this.chainingCacheLoader.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)(this.value + 2), this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader2.get(this.fqn).get(this.key));
        this.cache.remove(this.fqn);
        AssertJUnit.assertEquals((Object)this.value, this.chainingCacheLoader.get(this.fqn).get(this.key));
        AssertJUnit.assertNull((Object)this.loader1.get(this.fqn));
        AssertJUnit.assertEquals((Object)this.value, this.loader2.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        this.cleanup();
    }

    public void testCrudsTransactional() throws Exception {
        this.startCache(false, false);
        TransactionManager mgr = this.cache.getTransactionManager();
        this.chainingCacheLoader.remove(this.cache.getRoot().getFqn());
        AssertJUnit.assertNull((Object)this.loader1.get(this.fqn));
        AssertJUnit.assertNull((Object)this.loader2.get(this.fqn));
        AssertJUnit.assertNull((Object)this.chainingCacheLoader.get(this.fqn));
        mgr.begin();
        this.cache.put(this.fqn, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((Object)this.chainingCacheLoader.get(this.fqn));
        AssertJUnit.assertNull((Object)this.loader1.get(this.fqn));
        AssertJUnit.assertNull((Object)this.loader2.get(this.fqn));
        mgr.commit();
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, this.chainingCacheLoader.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader2.get(this.fqn).get(this.key));
        this.cache.evict(this.fqn);
        AssertJUnit.assertEquals((Object)this.value, this.chainingCacheLoader.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, this.loader2.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        this.cache.remove(this.fqn);
        AssertJUnit.assertNull((String)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((String)this.value, (Object)this.chainingCacheLoader.get(this.fqn));
        AssertJUnit.assertNull((String)this.value, (Object)this.loader1.get(this.fqn));
        AssertJUnit.assertNull((String)this.value, (Object)this.loader2.get(this.fqn));
        this.cleanup();
    }
}

