/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Iterator;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.interceptors.CacheStoreInterceptor;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.DummyCacheLoader;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class SharedCacheLoaderTest
extends AbstractCacheLoaderTestBase {
    private CacheImpl<Object, Object> cache1;
    private CacheImpl<Object, Object> cache2;
    private DummyCacheLoader dummyCacheLoader;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        if (this.cache1 != null || this.cache2 != null) {
            this.tearDown();
        }
        this.cache1 = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        this.cache2 = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        this.cache1.getConfiguration().setCacheMode("REPL_SYNC");
        this.cache2.getConfiguration().setCacheMode("REPL_SYNC");
        this.cache1.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", DummyCacheLoader.class.getName(), "", false, false, true));
        this.cache2.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", DummyCacheLoader.class.getName(), "", false, false, true));
        this.cache1.start();
        this.cache2.start();
        this.dummyCacheLoader = new DummyCacheLoader();
        this.cache1.setCacheLoader((CacheLoader)this.dummyCacheLoader);
        this.cache2.setCacheLoader((CacheLoader)this.dummyCacheLoader);
        this.findCacheStoreInterceptor(this.cache1).setCache(this.cache1);
        this.findCacheStoreInterceptor(this.cache2).setCache(this.cache2);
    }

    protected CacheStoreInterceptor findCacheStoreInterceptor(CacheImpl cache) {
        Iterator ints = cache.getInterceptors().iterator();
        CacheStoreInterceptor csi = null;
        while (ints.hasNext()) {
            Interceptor i = (Interceptor)ints.next();
            if (!(i instanceof CacheStoreInterceptor)) continue;
            csi = (CacheStoreInterceptor)i;
            break;
        }
        return csi;
    }

    @AfterMethod(alwaysRun=true)
    protected void tearDown() {
        if (this.cache1 != null) {
            this.cache1.stop();
        }
        if (this.cache2 != null) {
            this.cache2.stop();
        }
        this.cache1 = null;
        this.cache2 = null;
    }

    public void testReplicationWithSharedCL() throws Exception {
        this.cache1.put("/test", (Object)"one", (Object)"two");
        AssertJUnit.assertEquals((Object)"two", (Object)this.cache1.get("/test", (Object)"one"));
        AssertJUnit.assertEquals((Object)"two", (Object)this.cache2.get("/test", (Object)"one"));
        AssertJUnit.assertEquals((int)1, (int)this.dummyCacheLoader.getPutCount());
    }
}

