/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.TransactionManager;
import junit.framework.Assert;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.annotation.NodeLoaded;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeMoved;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.NodeVisited;
import org.jboss.cache.notifications.annotation.TransactionCompleted;
import org.jboss.cache.notifications.annotation.TransactionRegistered;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class NotificationThreadTest
extends AbstractCacheLoaderTestBase {
    private Cache<String, String> cache1;
    private Cache<String, String> cache2;
    private TestCacheListener listener;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        CacheFactory instance = DefaultCacheFactory.getInstance();
        this.cache1 = instance.createCache(false);
        this.cache2 = instance.createCache(false);
        this.cache1.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cache2.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cache1.getConfiguration().setSyncCommitPhase(true);
        this.cache2.getConfiguration().setSyncCommitPhase(true);
        this.cache1.getConfiguration().setSyncRollbackPhase(true);
        this.cache2.getConfiguration().setSyncRollbackPhase(true);
        this.cache1.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache2.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache1.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", DummyInMemoryCacheLoader.class.getName(), null, false, false, false));
        this.listener = new TestCacheListener();
        this.cache1.addCacheListener((Object)this.listener);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.cache1.stop();
        this.cache2.stop();
    }

    public void testPessimisticWithCacheLoader() throws Throwable {
        this.doTest(false);
    }

    public void testOptimisticWithCacheLoader() throws Throwable {
        this.cache1.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache2.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.doTest(false);
    }

    public void testPessimisticWithPassivation() throws Throwable {
        this.cache1.getConfiguration().getCacheLoaderConfig().setPassivation(true);
        this.doTest(false);
    }

    public void testOptimisticWithPassivation() throws Throwable {
        this.cache1.getConfiguration().getCacheLoaderConfig().setPassivation(true);
        this.cache1.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache2.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.doTest(false);
    }

    public void testPessimisticWithCacheLoaderTx() throws Throwable {
        this.doTest(true);
    }

    public void testOptimisticWithCacheLoaderTx() throws Throwable {
        this.cache1.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache2.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.doTest(true);
    }

    public void testPessimisticWithPassivationTx() throws Throwable {
        this.cache1.getConfiguration().getCacheLoaderConfig().setPassivation(true);
        this.doTest(true);
    }

    public void testOptimisticWithPassivationTx() throws Throwable {
        this.cache1.getConfiguration().getCacheLoaderConfig().setPassivation(true);
        this.cache1.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache2.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.doTest(true);
    }

    private void doTest(boolean tx) throws Throwable {
        this.cache1.stop();
        this.cache1.start();
        this.cache2.start();
        TransactionManager tm = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.listener.sameThreadExpected = true;
        this.listener.mainThread = Thread.currentThread();
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        if (tx) {
            tm.begin();
        }
        this.cache1.put(fqn, (Object)"k", (Object)"v");
        if (tx) {
            tm.commit();
        }
        if (tx) {
            tm.begin();
        }
        this.cache1.get(fqn, (Object)"k");
        if (tx) {
            tm.commit();
        }
        if (tx) {
            tm.begin();
        }
        this.cache1.put(fqn, (Object)"k", (Object)"v2");
        if (tx) {
            tm.commit();
        }
        if (tx) {
            tm.begin();
        }
        this.cache1.removeNode(fqn);
        if (tx) {
            tm.commit();
        }
        if (tx) {
            tm.begin();
        }
        this.cache1.put(fqn, (Object)"k", (Object)"v3");
        if (tx) {
            tm.commit();
        }
        if (tx) {
            tm.begin();
        }
        this.cache1.evict(fqn, true);
        if (tx) {
            tm.commit();
        }
        if (tx) {
            tm.begin();
        }
        this.cache1.get(fqn, (Object)"k");
        if (tx) {
            tm.commit();
        }
        if (tx) {
            tm.begin();
        }
        this.cache1.move(fqn, Fqn.ROOT);
        if (tx) {
            tm.commit();
        }
        this.listener.sameThreadExpected = false;
        this.cache2.stop();
        TestingUtil.sleepThread(500L);
        Iterator<Throwable> i$ = this.listener.exceptions.iterator();
        if (i$.hasNext()) {
            Throwable e = i$.next();
            throw e;
        }
    }

    @CacheListener
    public class TestCacheListener {
        boolean sameThreadExpected;
        Thread mainThread;
        List<Throwable> exceptions = new LinkedList<Throwable>();

        @NodeCreated
        @NodeModified
        @NodeRemoved
        @NodeVisited
        @NodeEvicted
        @NodeLoaded
        @NodeMoved
        @NodeActivated
        @NodePassivated
        @CacheStarted
        @CacheStopped
        @ViewChanged
        @TransactionCompleted
        @TransactionRegistered
        public void testCallbackThread(Event e) {
            try {
                if (this.sameThreadExpected) {
                    Assert.assertSame((Object)this.mainThread, (Object)Thread.currentThread());
                } else {
                    Assert.assertNotSame((Object)this.mainThread, (Object)Thread.currentThread());
                }
            }
            catch (Throwable t) {
                this.exceptions.add(t);
            }
        }
    }
}

