/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.jgroups.Address;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class CacheTest
extends AbstractOptimisticTestCase {
    Log log = LogFactory.getLog(CacheTest.class);
    private CacheImpl<Object, Object> c;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.c = this.createCache();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        super.tearDown();
        if (this.c != null) {
            this.destroyCache((Cache<Object, Object>)this.c);
        }
        this.c = null;
    }

    public void testExplicitTxFailure() throws Exception {
        TransactionManager mgr = this.c.getTransactionManager();
        try {
            mgr.begin();
            this.c.put("/a", (Object)"k", (Object)"v");
            Transaction t = mgr.suspend();
            this.c.put("/a", (Object)"k2", (Object)"v2");
            mgr.resume(t);
            mgr.commit();
            AssertJUnit.assertTrue((String)"Expecting a rollback exception!", (boolean)false);
        }
        catch (RollbackException re) {
            AssertJUnit.assertTrue((String)"Expecting a rollback exception!", (boolean)true);
        }
    }

    public void testImplicitTxFailure() throws Exception {
        int i;
        int numThreads = 100;
        AbstractOptimisticTestCase.ExceptionThread[] thread = new AbstractOptimisticTestCase.ExceptionThread[numThreads];
        final CountDownLatch latch = new CountDownLatch(1);
        for (i = 0; i < numThreads; ++i) {
            thread[i] = new AbstractOptimisticTestCase.ExceptionThread(){

                public void run() {
                    try {
                        latch.await();
                        CacheTest.this.c.put("/a", (Object)"k", (Object)"v");
                    }
                    catch (Exception e) {
                        CacheTest.this.log.fatal((Object)"*** Thew an exception!!", (Throwable)e);
                        this.setException(e);
                    }
                }
            };
        }
        for (i = 0; i < numThreads; ++i) {
            thread[i].start();
        }
        latch.countDown();
        for (i = 0; i < numThreads; ++i) {
            thread[i].join();
        }
        int exceptionCount = 0;
        for (int i2 = 0; i2 < numThreads; ++i2) {
            Exception e = thread[i2].getException();
            if (e == null) continue;
            AssertJUnit.assertFalse((String)"Should never see a RollbackException - instead, expecting the CAUSE of the rollback.", (boolean)(e instanceof RollbackException));
            ++exceptionCount;
        }
        AssertJUnit.assertTrue((String)"Expecting at least ONE concurrent write exception!!", (exceptionCount > 0 ? 1 : 0) != 0);
    }

    public void testLocalTransaction() throws Exception {
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache(this.c);
        this.c.setInterceptorChain(this.getAlteredInterceptorChain(dummy, (CacheSPI<Object, Object>)this.c, true));
        TransactionManager mgr = this.c.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        this.c.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumLocalTransactions());
        List<Method> calls = dummy.getAllCalled();
        AssertJUnit.assertEquals((Object)MethodDeclarations.optimisticPrepareMethod, (Object)calls.get(0));
        AssertJUnit.assertEquals((Object)MethodDeclarations.commitMethod, (Object)calls.get(1));
    }

    public void testRollbackTransaction() throws Exception {
        this.destroyCache((Cache<Object, Object>)this.c);
        this.c = this.createCacheWithListener();
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache(this.c);
        this.c.setInterceptorChain(this.getAlteredInterceptorChain(dummy, (CacheSPI<Object, Object>)this.c, true));
        TransactionManager mgr = this.c.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        mgr.begin();
        this.c.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.rollback();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumLocalTransactions());
        List<Method> calls = dummy.getAllCalled();
        AssertJUnit.assertEquals((int)1, (int)calls.size());
        AssertJUnit.assertEquals((Object)MethodDeclarations.rollbackMethod, (Object)calls.get(0));
    }

    public void testRemotePrepareTransaction() throws Throwable {
        this.destroyCache((Cache<Object, Object>)this.c);
        this.c = this.createCacheWithListener();
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache(this.c);
        this.c.setInterceptorChain(this.getAlteredInterceptorChain(dummy, (CacheSPI<Object, Object>)this.c, true));
        TransactionManager mgr = this.c.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.c.getCurrentTransaction(tx);
        SamplePojo pojo = new SamplePojo(21, "test");
        this.c.put("/one/two", (Object)"key1", (Object)pojo);
        GlobalTransaction gtx = this.c.getCurrentTransaction(tx);
        TransactionTable table = this.c.getTransactionTable();
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        GlobalTransaction remoteGtx = new GlobalTransaction();
        remoteGtx.setAddress((Address)new AbstractOptimisticTestCase.DummyAddress());
        MethodCall meth = (MethodCall)entry.getModifications().get(0);
        meth.getArgs()[0] = remoteGtx;
        MethodCall prepareMethod = MethodCallFactory.create((Method)MethodDeclarations.optimisticPrepareMethod, (Object[])new Object[]{remoteGtx, this.injectDataVersion(entry.getModifications()), null, remoteGtx.getAddress(), Boolean.FALSE});
        this.c._replicate(prepareMethod);
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertNotNull((Object)table.get(remoteGtx));
        AssertJUnit.assertNotNull((Object)table.getLocalTransaction(remoteGtx));
        AssertJUnit.assertEquals((int)1, (int)table.get(remoteGtx).getModifications().size());
        AssertJUnit.assertEquals((int)3, (int)entry.getTransactionWorkSpace().getNodes().size());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        List<Method> calls = dummy.getAllCalled();
        AssertJUnit.assertEquals((Object)MethodDeclarations.optimisticPrepareMethod, (Object)calls.get(2));
        AssertJUnit.assertEquals((int)1, (int)this.c.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)this.c.getTransactionTable().getNumLocalTransactions());
    }

    public void testRemoteCacheBroadcast() throws Exception {
        this.destroyCache((Cache<Object, Object>)this.c);
        CacheImpl<Object, Object> cache = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
        CacheImpl<Object, Object> cache2 = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
        AssertJUnit.assertEquals((int)2, (int)cache.getMembers().size());
        AssertJUnit.assertEquals((int)2, (int)cache2.getMembers().size());
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((Object)pojo, (Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((Object)pojo, (Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    public void testTwoWayRemoteCacheBroadcast() throws Exception {
        this.destroyCache((Cache<Object, Object>)this.c);
        CacheImpl<Object, Object> cache = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
        CacheImpl<Object, Object> cache2 = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
        AssertJUnit.assertEquals((int)2, (int)cache.getMembers().size());
        AssertJUnit.assertEquals((int)2, (int)cache2.getMembers().size());
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getCurrentTransaction(tx);
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((Object)pojo, (Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((Object)pojo, (Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    public void testConcurrentNodeRemoval() throws Exception {
        this.c.put(this.fqn, (Object)"key", (Object)"value");
        TransactionManager mgr = this.c.getTransactionManager();
        mgr.begin();
        this.c.put(this.fqn, (Object)"key2", (Object)"value2");
        Transaction tx = mgr.suspend();
        this.c.remove(this.fqn);
        mgr.resume(tx);
        boolean ok = false;
        try {
            mgr.commit();
        }
        catch (RollbackException rbe) {
            ok = true;
        }
        AssertJUnit.assertTrue((String)"Concurrent mod should result in a rollback", (boolean)ok);
        AssertJUnit.assertTrue((String)"The node should have been removed!", (!this.c.exists(this.fqn) ? 1 : 0) != 0);
    }

    public void testConcurrentNodeModification() throws Exception {
        this.c.put(this.fqn, (Object)"key", (Object)"value");
        TransactionManager mgr = this.c.getTransactionManager();
        mgr.begin();
        this.c.put(this.fqn, (Object)"key2", (Object)"value2");
        Transaction tx = mgr.suspend();
        this.c.put(this.fqn, (Object)"key3", (Object)"value3");
        mgr.resume(tx);
        boolean ok = false;
        try {
            mgr.commit();
        }
        catch (RollbackException rbe) {
            ok = true;
        }
        AssertJUnit.assertTrue((String)"Concurrent mod should result in a rollback", (boolean)ok);
    }

    public void testRemoveAndCreate() throws Exception {
        this.c = this.createCache();
        this.c.put(this.fqn, (Object)"key", (Object)"value");
        TransactionManager tm = this.c.getTransactionManager();
        tm.begin();
        this.c.put(this.fqn, (Object)"test", (Object)"test");
        tm.commit();
        AssertJUnit.assertEquals((int)1, (int)this.c.getRoot().getChildrenNames().size());
        tm.begin();
        this.c.removeNode(this.fqn);
        this.c.put(this.fqn, (Object)"test", (Object)"test");
        tm.commit();
        AssertJUnit.assertEquals((int)1, (int)this.c.getRoot().getChildrenNames().size());
    }

    public void testRemoveChildAfterRemoveParent() throws Exception {
        this.c = this.createCache();
        TransactionManager tm = this.c.getTransactionManager();
        this.c.put(Fqn.fromString((String)"/a/b"), (Object)"k", (Object)"v");
        tm.begin();
        this.c.remove(Fqn.fromString((String)"/a"));
        this.c.remove(Fqn.fromString((String)"/a/b"));
        tm.commit();
        this.destroyCache((Cache<Object, Object>)this.c);
    }

    public void testAddChildAfterRemoveParent() throws Exception {
        this.c = this.createCache();
        TransactionManager tm = this.c.getTransactionManager();
        this.c.put(Fqn.fromString((String)"/a/b"), (Object)"k", (Object)"v");
        tm.begin();
        this.c.remove(Fqn.fromString((String)"/a"));
        this.c.put(Fqn.fromString((String)"/a/b"), (Object)"k", (Object)"v");
        tm.commit();
        this.destroyCache((Cache<Object, Object>)this.c);
    }
}

