/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.Iterator;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.optimistic.TestListener;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.testng.AssertJUnit;

public class NodeInterceptorGetKeysTest
extends AbstractOptimisticTestCase {
    public void testTransactionGetKeysMethod() throws Exception {
        TestListener listener = new TestListener();
        CacheImpl<Object, Object> cache = this.createCacheWithListener(listener);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        interceptor.setCache(cache);
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        nodeInterceptor.setCache(cache);
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache(cache);
        interceptor.setNext((Interceptor)nodeInterceptor);
        nodeInterceptor.setNext((Interceptor)dummy);
        cache.setInterceptorChain((Interceptor)interceptor);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getInvocationContext().setTransaction(tx);
        cache.getInvocationContext().setGlobalTransaction(cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        TransactionTable table = cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)1, (int)cache.getKeys("/one/two").size());
        mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        mgr.begin();
        Transaction tx2 = mgr.getTransaction();
        cache.getInvocationContext().setTransaction(tx2);
        cache.getInvocationContext().setGlobalTransaction(cache.getCurrentTransaction(tx2));
        AssertJUnit.assertNull((Object)cache.get("/one/two", (Object)"key1"));
        mgr.commit();
        cache.stop();
    }

    public void testTransactionGetNoKeysMethod() throws Exception {
        TestListener listener = new TestListener();
        CacheImpl<Object, Object> cache = this.createCacheWithListener(listener);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        interceptor.setCache(cache);
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        nodeInterceptor.setCache(cache);
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache(cache);
        interceptor.setNext((Interceptor)nodeInterceptor);
        nodeInterceptor.setNext((Interceptor)dummy);
        cache.setInterceptorChain((Interceptor)interceptor);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getInvocationContext().setTransaction(tx);
        cache.getInvocationContext().setGlobalTransaction(cache.getCurrentTransaction(tx));
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        TransactionTable table = cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        AssertJUnit.assertEquals((int)0, (int)cache.getKeys("/").size());
        mgr.commit();
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)0, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        cache.stop();
    }

    public void testTransactionGetKeysIteratorMethod() throws Exception {
        TestListener listener = new TestListener();
        CacheImpl<Object, Object> cache = this.createCacheWithListener(listener);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        interceptor.setCache(cache);
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        nodeInterceptor.setCache(cache);
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache(cache);
        interceptor.setNext((Interceptor)nodeInterceptor);
        nodeInterceptor.setNext((Interceptor)dummy);
        cache.setInterceptorChain((Interceptor)interceptor);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getInvocationContext().setTransaction(tx);
        cache.getInvocationContext().setGlobalTransaction(cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        TransactionTable table = cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        AssertJUnit.assertEquals((int)1, (int)cache.getKeys("/one/two").size());
        Iterator it = cache.getKeys("/one/two").iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        AssertJUnit.assertEquals((int)0, (int)cache.getKeys("/one/two").size());
        mgr.commit();
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)dummy.getCalled());
        cache.stop();
    }
}

