/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.options;

import javax.transaction.TransactionManager;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.NodeLock;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ForceWriteLockTest {
    private CacheSPI<String, String> cache;
    private Fqn fqn = Fqn.fromString((String)"/a/b");
    private TransactionManager tm;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        Configuration c = new Configuration();
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        CacheFactory instance = DefaultCacheFactory.getInstance();
        this.cache = (CacheSPI)instance.createCache(c);
        this.tm = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        try {
            this.tm.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cache.stop();
    }

    public void testControl() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.tm.begin();
        this.cache.get(this.fqn, (Object)"k");
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn.getParent(), false);
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn, false);
        this.tm.commit();
        this.assertNotLocked(this.fqn);
    }

    public void testForceWithGetTx() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.tm.begin();
        this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
        this.cache.get(this.fqn, (Object)"k");
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn.getParent(), false);
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn, true);
        this.tm.commit();
        this.assertNotLocked(this.fqn);
        this.testControl();
    }

    public void testForceWithPutTx() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.tm.begin();
        this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
        this.cache.put(this.fqn, (Object)"k", (Object)"v2");
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn.getParent(), false);
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn, true);
        this.tm.commit();
        this.assertNotLocked(this.fqn);
        this.testControl();
    }

    public void testForceWithRemoveTx() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.tm.begin();
        this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
        this.cache.remove(this.fqn, (Object)"k");
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn.getParent(), false);
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn, true);
        this.tm.commit();
        this.assertNotLocked(this.fqn);
        this.testControl();
    }

    private void assertNotLocked(Fqn fqn) throws Exception {
        NodeSPI n = this.cache.peek(fqn, true);
        NodeLock lock = n.getLock();
        AssertJUnit.assertFalse((String)("node " + fqn + " is locked!"), (boolean)lock.isLocked());
    }

    private void assertLocked(Object owner, Fqn fqn, boolean write_locked) throws Exception {
        NodeSPI n = this.cache.peek(fqn, true);
        if (owner == null) {
            owner = Thread.currentThread();
        }
        NodeLock lock = n.getLock();
        AssertJUnit.assertTrue((String)("node " + fqn + " is not locked"), (boolean)lock.isLocked());
        if (write_locked) {
            AssertJUnit.assertTrue((String)("node " + fqn + " is not write-locked" + (lock.isReadLocked() ? " but is read-locked instead!" : "!")), (boolean)lock.isWriteLocked());
        } else {
            AssertJUnit.assertTrue((String)("node " + fqn + " is not read-locked" + (lock.isWriteLocked() ? " but is write-locked instead!" : "!")), (boolean)lock.isReadLocked());
        }
        AssertJUnit.assertTrue((String)("owner " + owner + "is not owner for lock " + lock), (boolean)lock.isOwner(owner));
    }
}

