/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ConcurrentPassivationTest {
    private CacheImpl<Integer, String> cache_;
    private int wakeupIntervalMillis_ = 0;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis_ = this.cache_.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds() * 1000;
        if (this.wakeupIntervalMillis_ < 0) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis_));
        }
    }

    private void initCaches() throws Exception {
        CacheFactory instance = DefaultCacheFactory.getInstance();
        this.cache_ = (CacheImpl)instance.createCache(false);
        this.cache_.setConfiguration(new XmlConfigurationParser().parseFile("META-INF/local-passivation-service.xml"));
        this.cache_.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache_.getConfiguration().getCacheLoaderConfig().getFirstCacheLoaderConfig().setClassName(DummyInMemoryCacheLoader.class.getName());
        this.cache_.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache_.stop();
        this.cache_ = null;
    }

    public void testConcurrentPassivation() throws Exception {
        Fqn base = new Fqn(new Object[]{"/org/jboss/test/data/concurrent/passivation"});
        for (int i = 0; i < 35000; ++i) {
            this.cache_.put(new Fqn(base, new Object[]{i / 100}), (Object)i, (Object)"value");
        }
        long loopDone = System.currentTimeMillis() + (long)(5 * this.wakeupIntervalMillis_);
        System.out.println("Initialised; Loop for " + 5 * this.wakeupIntervalMillis_ + " millis");
        while (System.currentTimeMillis() < loopDone) {
            for (int i = 0; i < 35000; ++i) {
                Fqn fqn = new Fqn(base, new Object[]{i / 100});
                AssertJUnit.assertNotNull((String)("Get on Fqn " + fqn + " returned null"), (Object)this.cache_.get(fqn));
            }
        }
    }
}

