/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.ArrayList;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.util.CachePrinter;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"}, enabled=true)
public class SimultaneousRollbackAndPutTest {
    private Cache cache;
    private TransactionManager tm;
    private Fqn A = Fqn.fromString((String)"/a");
    private Fqn B = Fqn.fromString((String)"/b");
    private Log log = LogFactory.getLog(SimultaneousRollbackAndPutTest.class);

    @BeforeTest(alwaysRun=true)
    protected void setUp() throws Exception {
        this.cache = DefaultCacheFactory.getInstance().createCache(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.cache.start();
        this.tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.cache.put(this.A, (Object)"k", (Object)"v");
    }

    @AfterTest(alwaysRun=true)
    protected void tearDown() {
        TestingUtil.killCaches(this.cache);
    }

    @AfterMethod(alwaysRun=true)
    protected void resetCache() throws Exception {
        try {
            this.cache.removeNode(this.B);
            this.cache.getRoot().getChild(this.A).clearData();
            this.cache.put(this.A, (Object)"k", (Object)"v");
            TestingUtil.killTransactions(this.cache);
        }
        catch (Exception e) {
            this.tearDown();
            this.setUp();
        }
    }

    @Test(invocationCount=100, alwaysRun=false, enabled=false, description="This is to do with a flaw in the way pessimistic locking deals with transactions.  See JBCACHE-923")
    public void testStaleLocks() throws Exception {
        this.tm.begin();
        final Transaction t = this.tm.getTransaction();
        final ArrayList exceptions = new ArrayList();
        this.cache.put(this.B, (Object)"k", (Object)"v");
        Thread rollbackThread = new Thread("RollbackThread"){

            public void run() {
                try {
                    t.rollback();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        rollbackThread.start();
        try {
            this.cache.put(this.A, (Object)"k2", (Object)"v2");
            this.tm.commit();
        }
        catch (RollbackException expected) {
        }
        catch (CacheException ce) {
            // empty catch block
        }
        rollbackThread.join();
        if (((CacheImpl)this.cache).getNumberOfLocksHeld() > 0) {
            this.log.fatal((Object)"***********");
            this.log.fatal((Object)CachePrinter.printCacheLockingInfo((Cache)this.cache));
            this.log.fatal((Object)"***********");
        }
        assert (0 == ((CacheImpl)this.cache).getNumberOfLocksHeld());
        if (exceptions.size() > 0) {
            throw (Exception)exceptions.get(0);
        }
    }
}

