/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import javassist.ByteArrayClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.jboss.aop.Advised;
import org.jboss.aop.AdvisorFactory;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.Domain;
import org.jboss.aop.SecurityActions;
import org.jboss.aop.WeavingStrategySupport;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.InstrumentorFactory;
import org.jboss.aop.util.logging.AOPLogger;
import org.jboss.logging.Logger;

public class SuperClassesFirstWeavingStrategy
extends WeavingStrategySupport {
    private static final Logger logger = AOPLogger.getLogger(SuperClassesFirstWeavingStrategy.class);
    private boolean verbose = AspectManager.verbose;
    public static final String AOP_PACKAGE = Advised.class.getPackage().getName();

    public byte[] translate(AspectManager manager, String className, ClassLoader loader, byte[] classfileBuffer) throws Exception {
        if (SuperClassesFirstWeavingStrategy.isReEntry()) {
            return null;
        }
        SuperClassesFirstWeavingStrategy.setReEntry();
        manager.transformationStarted = true;
        try {
            CtClassTransformationInfo info;
            if (manager.isNonAdvisableClassName(className)) {
                byte[] byArray = null;
                return byArray;
            }
            AOPClassPool pool = (AOPClassPool)manager.registerClassLoader(loader);
            CtClass clazz = this.instrumentClass(manager, pool, info = this.obtainCtClassInfo(pool, className, classfileBuffer), true);
            if (clazz != null) {
                pool.lockInCache(info.getClazz());
                if (AspectManager.debugClasses) {
                    SecurityActions.debugWriteFile(info.getClazz());
                }
                byte[] rtn = info.getClazz().toBytecode();
                if (AspectManager.getPrune()) {
                    info.getClazz().prune();
                }
                byte[] byArray = rtn;
                return byArray;
            }
            pool.soften(info.getClazz());
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception ex) {
            if (!(ex instanceof NotFoundException)) {
                if (this.verbose) {
                    ex.printStackTrace();
                } else {
                    System.err.println("[error] " + ex.getMessage() + ".. Do verbose mode if you want full stack trace.");
                }
            }
            throw ex;
        }
        finally {
            SuperClassesFirstWeavingStrategy.clearReEntry();
        }
    }

    private CtClassTransformationInfo obtainCtClassInfo(AOPClassPool pool, String className, byte[] classfileBuffer) throws NotFoundException {
        try {
            return new CtClassTransformationInfo(pool.getLocally(className), className);
        }
        catch (NotFoundException e) {
            ByteArrayClassPath cp = new ByteArrayClassPath(className, classfileBuffer);
            pool.insertClassPath((ClassPath)cp);
            return new CtClassTransformationInfo(pool.getLocally(className), className);
        }
        catch (Error e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CtClass instrumentClass(AspectManager manager, AOPClassPool pool, CtClassTransformationInfo info, boolean isLoadedClass) throws NotFoundException, Exception {
        try {
            boolean transformed;
            CtClass superClass = info.getClazz().getSuperclass();
            if (superClass != null && !Instrumentor.implementsAdvised(info.getClazz())) {
                CtClassTransformationInfo superInfo = new CtClassTransformationInfo(superClass, superClass.getName());
                ClassPool superPool = superClass.getClassPool();
                if (superPool instanceof AOPClassPool) {
                    AspectManager aspectManager = manager;
                    if (manager instanceof Domain && superPool != pool) {
                        aspectManager = AspectManager.instance(superPool.getClassLoader());
                    }
                    this.instrumentClass(aspectManager, (AOPClassPool)superPool, superInfo, false);
                }
            }
            if (manager.isNonAdvisableClassName(info.getClassName())) {
                return null;
            }
            if (info.getClass().isArray()) {
                if (this.verbose && logger.isDebugEnabled()) {
                    logger.debug((Object)("cannot compile, isArray: " + info.getClassName()));
                }
                pool.flushClass(info.getClassName());
                return null;
            }
            if (info.getClazz().isInterface()) {
                if (this.verbose && logger.isDebugEnabled()) {
                    logger.debug((Object)("cannot compile, isInterface: " + info.getClassName()));
                }
                info.getClazz().prune();
                return null;
            }
            if (info.getClazz().isFrozen()) {
                if (this.isAdvised((ClassPool)pool, info.getClazz())) {
                    return null;
                }
                if (this.verbose && logger.isDebugEnabled()) {
                    logger.debug((Object)("warning, isFrozen: " + info.getClassName() + " " + info.getClazz().getClassPool()));
                }
                if (isLoadedClass) {
                    return null;
                }
                info = this.obtainCtClassInfo(pool, info.getClassName(), null);
            }
            if (!(transformed = info.getClazz().isModified())) {
                ClassAdvisor advisor = AdvisorFactory.getClassAdvisor(info.getClazz(), manager);
                Instrumentor instrumentor = InstrumentorFactory.getInstrumentor(pool, manager, manager.dynamicStrategy.getJoinpointClassifier(), manager.dynamicStrategy.getDynamicTransformationObserver(info.getClazz()));
                if (!Instrumentor.isTransformable(info.getClazz())) {
                    if (!this.verbose) return null;
                    if (!logger.isDebugEnabled()) return null;
                    logger.debug((Object)("cannot compile, implements Untransformable: " + info.getClassName()));
                    return null;
                }
                manager.attachMetaData(advisor, info.getClazz(), true);
                manager.applyInterfaceIntroductions(advisor, info.getClazz());
                transformed = instrumentor.transform(info.getClazz(), advisor);
            }
            if (!transformed) {
                return null;
            }
            if (isLoadedClass) return info.getClazz();
            info.setTransformed(transformed);
            return info.getClazz();
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting class ", e);
        }
    }

    public boolean isAdvised(ClassPool pool, CtClass clazz) throws NotFoundException {
        CtClass[] interfaces = clazz.getInterfaces();
        CtClass advised = pool.get(AOP_PACKAGE + ".Advised");
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].equals(advised)) {
                return true;
            }
            if (!interfaces[i].getName().equals(AOP_PACKAGE + ".Advised")) continue;
            return true;
        }
        return false;
    }

    private class CtClassTransformationInfo {
        boolean transformed;
        CtClass clazz;
        String className;

        private CtClassTransformationInfo(CtClass clazz, String className) {
            this.clazz = clazz;
            this.className = className;
        }

        private CtClassTransformationInfo(CtClass clazz, String className, boolean transformed) {
            this.clazz = clazz;
            this.className = className;
            this.transformed = transformed;
        }

        private CtClass getClazz() {
            return this.clazz;
        }

        private boolean isTransformed() {
            return this.transformed;
        }

        private void setTransformed(boolean transformed) {
            this.transformed = transformed;
        }

        private String getClassName() {
            return this.className;
        }
    }
}

