/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.DatabaseStats;

public class BtreeStats
extends DatabaseStats {
    private long binCount;
    private long dbinCount;
    private long deletedLNCount;
    private long dupCountLNCount;
    private long inCount;
    private long dinCount;
    private long lnCount;
    private int mainTreeMaxDepth;
    private int duplicateTreeMaxDepth;
    private long[] insByLevel;
    private long[] binsByLevel;
    private long[] dinsByLevel;
    private long[] dbinsByLevel;

    public long getBottomInternalNodeCount() {
        return this.binCount;
    }

    public void setBottomInternalNodeCount(long val) {
        this.binCount = val;
    }

    public long getDuplicateBottomInternalNodeCount() {
        return this.dbinCount;
    }

    public void setDuplicateBottomInternalNodeCount(long val) {
        this.dbinCount = val;
    }

    public long getDeletedLeafNodeCount() {
        return this.deletedLNCount;
    }

    public void setDeletedLeafNodeCount(long val) {
        this.deletedLNCount = val;
    }

    public long getDupCountLeafNodeCount() {
        return this.dupCountLNCount;
    }

    public void setDupCountLeafNodeCount(long val) {
        this.dupCountLNCount = val;
    }

    public long getInternalNodeCount() {
        return this.inCount;
    }

    public void setInternalNodeCount(long val) {
        this.inCount = val;
    }

    public long getDuplicateInternalNodeCount() {
        return this.dinCount;
    }

    public void setDuplicateInternalNodeCount(long val) {
        this.dinCount = val;
    }

    public long getLeafNodeCount() {
        return this.lnCount;
    }

    public void setLeafNodeCount(long val) {
        this.lnCount = val;
    }

    public int getMainTreeMaxDepth() {
        return this.mainTreeMaxDepth;
    }

    public void setMainTreeMaxDepth(int val) {
        this.mainTreeMaxDepth = val;
    }

    public int getDuplicateTreeMaxDepth() {
        return this.duplicateTreeMaxDepth;
    }

    public void setDuplicateTreeMaxDepth(int val) {
        this.duplicateTreeMaxDepth = val;
    }

    public long[] getINsByLevel() {
        return this.insByLevel;
    }

    public void setINsByLevel(long[] insByLevel) {
        this.insByLevel = insByLevel;
    }

    public long[] getBINsByLevel() {
        return this.binsByLevel;
    }

    public void setBINsByLevel(long[] binsByLevel) {
        this.binsByLevel = binsByLevel;
    }

    public long[] getDINsByLevel() {
        return this.dinsByLevel;
    }

    public void setDINsByLevel(long[] dinsByLevel) {
        this.dinsByLevel = dinsByLevel;
    }

    public long[] getDBINsByLevel() {
        return this.dbinsByLevel;
    }

    public void setDBINsByLevel(long[] dbinsByLevel) {
        this.dbinsByLevel = dbinsByLevel;
    }

    private void arrayToString(long[] arr, StringBuffer sb) {
        for (int i = 0; i < arr.length; ++i) {
            long count = arr[i];
            if (count <= 0L) continue;
            sb.append("   <Item level=\"").append(i);
            sb.append("\" count=\"").append(count).append("\"/>\n");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<BtreeStats>\n");
        if (this.binCount > 0L) {
            sb.append(" <BottomInternalNodesByLevel total=\"");
            sb.append(this.binCount).append("\">\n");
            this.arrayToString(this.binsByLevel, sb);
            sb.append(" </BottomInternalNodesByLevel>\n");
        }
        if (this.inCount > 0L) {
            sb.append(" <InternalNodesByLevel total=\"");
            sb.append(this.inCount).append("\">\n");
            this.arrayToString(this.insByLevel, sb);
            sb.append(" </InternalNodesByLevel>\n");
        }
        if (this.dinCount > 0L) {
            sb.append(" <DuplicateInternalNodesByLevel total=\"");
            sb.append(this.dinCount).append("\">\n");
            this.arrayToString(this.dinsByLevel, sb);
            sb.append(" </DuplicateInternalNodesByLevel>\n");
        }
        if (this.dbinCount > 0L) {
            sb.append(" <DuplicateBottomInternalNodesByLevel total=\"");
            sb.append(this.dbinCount).append("\">\n");
            this.arrayToString(this.dbinsByLevel, sb);
            sb.append(" </DuplicateBottomInternalNodesByLevel>\n");
        }
        sb.append(" <LeafNodes count=\"").append(this.lnCount).append("\"/>\n");
        sb.append(" <DeletedLeafNodes count=\"").append(this.deletedLNCount).append("\"/>\n");
        sb.append(" <DuplicateCountLeafNodes count=\"").append(this.dupCountLNCount).append("\"/>\n");
        sb.append(" <MainTreeMaxDepth depth=\"").append(this.mainTreeMaxDepth).append("\"/>\n");
        sb.append(" <DuplicateTreeMaxDepth depth=\"").append(this.duplicateTreeMaxDepth).append("\"/>\n");
        sb.append("</BtreeStats>\n");
        return sb.toString();
    }
}

