/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.tree.TreeUtils;

public class DatabaseEntry {
    private byte[] data;
    private int dlen = 0;
    private int doff = 0;
    private int offset = 0;
    private int size = 0;
    private boolean partial = false;

    public String toString() {
        StringBuffer sb = new StringBuffer("<DatabaseEntry");
        sb.append(" dlen=").append(this.dlen);
        sb.append(" doff=").append(this.doff);
        sb.append(" doff=").append(this.doff);
        sb.append(" offset=").append(this.offset);
        sb.append(" size=").append(this.size);
        sb.append(">");
        return sb.toString();
    }

    public DatabaseEntry() {
    }

    public DatabaseEntry(byte[] data) {
        this.data = data;
        if (data != null) {
            this.size = data.length;
        }
    }

    public DatabaseEntry(byte[] data, int offset, int size) {
        this.data = data;
        this.offset = offset;
        this.size = size;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.offset = 0;
        this.size = data == null ? 0 : data.length;
    }

    public void setData(byte[] data, int offset, int size) {
        this.data = data;
        this.offset = offset;
        this.size = size;
    }

    public void setPartial(int doff, int dlen, boolean partial) {
        this.setPartialOffset(doff);
        this.setPartialLength(dlen);
        this.setPartial(partial);
    }

    public int getPartialLength() {
        return this.dlen;
    }

    public void setPartialLength(int dlen) {
        this.dlen = dlen;
    }

    public int getPartialOffset() {
        return this.doff;
    }

    public void setPartialOffset(int doff) {
        this.doff = doff;
    }

    public boolean getPartial() {
        return this.partial;
    }

    public void setPartial(boolean partial) {
        this.partial = partial;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    String dumpData() {
        return TreeUtils.dumpByteArray(this.data);
    }

    boolean dataEquals(DatabaseEntry o) {
        if (this.data == null && (o == null || o.data == null)) {
            return true;
        }
        if (this.data == null || o == null || o.data == null) {
            return false;
        }
        if (this.size != o.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[this.offset + i] == o.data[o.offset + i]) continue;
            return false;
        }
        return true;
    }
}

