/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.AutoTxn;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.ThreadLocker;

class DatabaseUtil {
    DatabaseUtil() {
    }

    static Locker getWritableLocker(Environment env, Transaction userTxn, boolean dbIsTransactional) throws DatabaseException {
        return DatabaseUtil.getWritableLocker(env, userTxn, dbIsTransactional, false);
    }

    static Locker getWritableLocker(Environment env, Transaction userTxn, boolean dbIsTransactional, boolean retainNonTxnLocks) throws DatabaseException {
        EnvironmentImpl envImpl = env.getEnvironmentImpl();
        boolean envIsTransactional = envImpl.isTransactional();
        if (dbIsTransactional && userTxn == null) {
            return new AutoTxn(envImpl, env.getDefaultTxnConfig());
        }
        if (userTxn == null) {
            if (retainNonTxnLocks) {
                return new BasicLocker(envImpl);
            }
            return new ThreadLocker(envImpl);
        }
        if (!envIsTransactional) {
            throw new DatabaseException("A Transaction cannot be used because the environment was opened non-transactionally");
        }
        if (!dbIsTransactional) {
            throw new DatabaseException("A Transaction cannot be used because the database was opened non-transactionally");
        }
        return userTxn.getLocker();
    }

    static Locker getReadableLocker(Environment env, Transaction userTxn, boolean dbIsTransactional, boolean retainNonTxnLocks) throws DatabaseException {
        if (userTxn != null && !dbIsTransactional) {
            throw new DatabaseException("A Transaction cannot be used because the database was opened non-transactionally");
        }
        Locker locker = userTxn != null ? userTxn.getLocker() : null;
        return DatabaseUtil.getReadableLocker(env, locker, retainNonTxnLocks);
    }

    static Locker getReadableLocker(Environment env, Database dbHandle, Locker locker, boolean retainNonTxnLocks) throws DatabaseException {
        if (!dbHandle.isTransactional() && locker != null && locker.isTransactional()) {
            throw new DatabaseException("A Transaction cannot be used because the database was opened non-transactionally");
        }
        return DatabaseUtil.getReadableLocker(env, locker, retainNonTxnLocks);
    }

    private static Locker getReadableLocker(Environment env, Locker locker, boolean retainNonTxnLocks) throws DatabaseException {
        EnvironmentImpl envImpl = env.getEnvironmentImpl();
        if (locker == null) {
            if (retainNonTxnLocks) {
                return new BasicLocker(envImpl);
            }
            return new ThreadLocker(envImpl);
        }
        return locker;
    }

    static void checkForNullParam(Object param, String name) {
        if (param == null) {
            throw new NullPointerException(name + " cannot be null");
        }
    }

    static void checkForNullDbt(DatabaseEntry dbt, String name, boolean checkData) {
        if (dbt == null) {
            throw new NullPointerException("DatabaseEntry " + name + " cannot be null");
        }
        if (checkData && dbt.getData() == null) {
            throw new NullPointerException("Data field for DatabaseEntry " + name + " cannot be null");
        }
    }

    static void checkForPartialKey(DatabaseEntry dbt) {
        if (dbt.getPartial()) {
            throw new IllegalArgumentException("A partial key DatabaseEntry is not allowed");
        }
    }
}

