/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.Locker;
import java.nio.ByteBuffer;
import java.util.Comparator;

public final class DIN
extends IN {
    private static final String BEGIN_TAG = "<din>";
    private static final String END_TAG = "</din>";
    private Key dupKey;
    private ChildReference dupCountLNRef;

    public DIN() {
        this.dupKey = new Key();
        this.dupCountLNRef = new ChildReference();
        this.init(null, new Key(), 0, 0);
    }

    public DIN(DatabaseImpl db, Key identifierKey, int capacity, Key dupKey, ChildReference dupCountLNRef, int level) {
        super(db, identifierKey, capacity, level);
        this.dupKey = dupKey;
        this.dupCountLNRef = dupCountLNRef;
        this.initMemorySize();
    }

    protected int generateLevel(DatabaseId dbId, int newLevel) {
        return newLevel;
    }

    protected IN createNewInstance(Key identifierKey, int maxEntries, int level) {
        return new DIN(this.getDatabase(), identifierKey, maxEntries, this.dupKey, this.dupCountLNRef, level);
    }

    public Key getDupKey() {
        return this.dupKey;
    }

    public Key getChildKey(IN child) throws DatabaseException {
        return child.getIdentifierKey();
    }

    public Key selectKey(Key mainTreeKey, Key dupTreeKey) {
        return dupTreeKey;
    }

    public Key getDupTreeKey() {
        return this.getIdentifierKey();
    }

    public Key getMainTreeKey() {
        return this.dupKey;
    }

    public ChildReference getDupCountLNRef() {
        return this.dupCountLNRef;
    }

    public DupCountLN getDupCountLN() throws DatabaseException {
        return (DupCountLN)this.dupCountLNRef.fetchTarget(this.getDatabase(), this);
    }

    void setDupCountLN(ChildReference dupCountLNRef) {
        this.updateMemorySize(this.dupCountLNRef, dupCountLNRef);
        this.dupCountLNRef = dupCountLNRef;
    }

    public void updateDupCountLNRefAndNullTarget(long newLsn) {
        this.setDirty(true);
        long oldSize = DIN.getInMemorySize(this.dupCountLNRef.getKey(), this.dupCountLNRef.getTarget());
        this.dupCountLNRef.setTarget(null);
        this.dupCountLNRef.setLsn(newLsn);
        long newSize = DIN.getInMemorySize(this.dupCountLNRef.getKey(), this.dupCountLNRef.getTarget());
        this.updateMemorySize(oldSize, newSize);
    }

    public void updateDupCountLNRef(long newLsn) {
        this.setDirty(true);
        this.dupCountLNRef.setLsn(newLsn);
    }

    public boolean containsDuplicates() {
        return true;
    }

    public boolean isDbRoot() {
        return false;
    }

    public final Comparator getKeyComparator() {
        return this.getDatabase().getDuplicateComparator();
    }

    void incrementDuplicateCount(EnvironmentImpl env, LockResult lockResult, Key key, Locker locker) throws DatabaseException {
        long oldLsn = this.dupCountLNRef.getLsn();
        lockResult.setAbortLsn(oldLsn, this.dupCountLNRef.isKnownDeleted());
        DupCountLN dupCountLN = this.getDupCountLN();
        dupCountLN.incDupCount();
        long newCountLSN = dupCountLN.log(env, this.getDatabase().getId(), key, oldLsn, locker);
        this.updateDupCountLNRef(newCountLSN);
    }

    protected long computeMemorySize() {
        long size = super.computeMemorySize();
        if (this.dupCountLNRef != null) {
            size += DIN.getInMemorySize(this.dupCountLNRef.getKey(), this.dupCountLNRef.getTarget());
        }
        return size;
    }

    public static long computeOverhead(DbConfigManager configManager) throws DatabaseException {
        int capacity = configManager.getInt(EnvironmentParams.NODE_MAX);
        return 376 + 4 * capacity * 2;
    }

    protected long getMemoryOverhead(MemoryBudget mb) {
        return mb.getDINOverhead();
    }

    boolean matchLNByNodeId(TreeLocation location, long nodeId) throws DatabaseException {
        for (int i = 0; i < this.getNEntries(); ++i) {
            boolean ret;
            Node n = this.fetchTarget(i);
            if (n == null || !(ret = n.matchLNByNodeId(location, nodeId))) continue;
            return true;
        }
        return false;
    }

    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processDIN(this, new Long(this.getNodeId()), this.getLevel());
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_DIN;
    }

    public int getLogSize() {
        int size = super.getLogSize();
        size += this.dupKey.getLogSize();
        size += LogUtils.getBooleanLogSize();
        if (this.dupCountLNRef != null) {
            size += this.dupCountLNRef.getLogSize();
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        this.dupKey.writeToLog(logBuffer);
        boolean dupCountLNRefExists = this.dupCountLNRef != null;
        LogUtils.writeBoolean(logBuffer, dupCountLNRefExists);
        if (dupCountLNRefExists) {
            this.dupCountLNRef.writeToLog(logBuffer);
        }
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        super.readFromLog(itemBuffer);
        this.dupKey.readFromLog(itemBuffer);
        boolean dupCountLNRefExists = LogUtils.readBoolean(itemBuffer);
        if (dupCountLNRefExists) {
            this.dupCountLNRef.readFromLog(itemBuffer);
        } else {
            this.dupCountLNRef = null;
        }
    }

    protected void dumpLogAdditional(StringBuffer sb) {
        super.dumpLogAdditional(sb);
        this.dupKey.dumpLog(sb, true);
        if (this.dupCountLNRef != null) {
            this.dupCountLNRef.dumpLog(sb, true);
        }
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.beginTag());
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<dupkey>");
        sb.append(this.dupKey == null ? "" : this.dupKey.toString());
        sb.append("</dupkey>");
        sb.append('\n');
        if (this.dupCountLNRef == null) {
            sb.append(TreeUtils.indent(nSpaces + 2));
            sb.append("<dupCountLN/>");
        } else {
            sb.append(this.dupCountLNRef.dumpString(nSpaces + 4, true));
        }
        sb.append('\n');
        sb.append(super.dumpString(nSpaces, false));
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.endTag());
        }
        return sb.toString();
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    public String shortClassName() {
        return "DIN";
    }
}

