/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogFileNotFoundException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.Generation;
import com.sleepycat.je.tree.InconsistentNodeException;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IN
extends Node
implements Comparable,
LoggableObject,
LogReadable {
    private static final String BEGIN_TAG = "<in>";
    private static final String END_TAG = "</in>";
    private static final String TRACE_SPLIT = "Split:";
    private static final String TRACE_DELETE = "Delete:";
    private static final byte KNOWN_DELETED_BIT = 1;
    private static final byte CLEAR_KNOWN_DELETED_BIT = -2;
    private static final byte DIRTY_BIT = 2;
    private static final byte CLEAR_DIRTY_BIT = -3;
    public static final int DBMAP_LEVEL = 131072;
    public static final int MAIN_LEVEL = 65536;
    public static final int MIN_LEVEL = -1;
    public static final int MAX_LEVEL = Integer.MAX_VALUE;
    private Latch latch;
    private long generation;
    private boolean dirty;
    private int nEntries;
    private Key identifierKey;
    private Node[] entryTargets;
    private Key[] entryKeys;
    private long[] entryLsns;
    private byte[] entryStates;
    private DatabaseImpl databaseImpl;
    private boolean isRoot;
    private int level;
    private long inMemorySize;
    private boolean inListResident;
    private long lastFullVersion = -1L;
    protected boolean evictionProhibited;
    public static final int EXACT_MATCH = 65536;
    public static final int INSERT_SUCCESS = 131072;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IN() {
        super(false);
        this.init(null, new Key(), 0, 0);
    }

    public IN(DatabaseImpl db, Key identifierKey, int capacity, int level) {
        super(true);
        this.init(db, identifierKey, capacity, this.generateLevel(db.getId(), level));
        this.initMemorySize();
    }

    protected void init(DatabaseImpl db, Key identifierKey, int initialCapacity, int level) {
        this.setDatabase(db);
        EnvironmentImpl env = this.databaseImpl == null ? null : this.databaseImpl.getDbEnvironment();
        this.latch = new Latch(this.shortClassName() + this.getNodeId(), env);
        this.generation = 0L;
        this.dirty = false;
        this.nEntries = 0;
        this.identifierKey = identifierKey;
        this.entryTargets = new Node[initialCapacity];
        this.entryKeys = new Key[initialCapacity];
        this.entryLsns = new long[initialCapacity];
        this.entryStates = new byte[initialCapacity];
        this.isRoot = false;
        this.level = level;
        this.inListResident = false;
        this.evictionProhibited = false;
    }

    protected void initMemorySize() {
        this.inMemorySize = this.computeMemorySize();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IN)) {
            return false;
        }
        IN in = (IN)obj;
        return in.getNodeId() == this.getNodeId();
    }

    public int hashCode() {
        return (int)(this.getNodeId() & 0xFFFFFFFFFFFFFFFFL);
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        IN argIN = (IN)o;
        long argNodeId = argIN.getNodeId();
        long myNodeId = this.getNodeId();
        if (myNodeId < argNodeId) {
            return -1;
        }
        if (myNodeId > argNodeId) {
            return 1;
        }
        return 0;
    }

    protected IN createNewInstance(Key identifierKey, int maxEntries, int level) {
        return new IN(this.databaseImpl, identifierKey, maxEntries, level);
    }

    public void postFetchInit(DatabaseImpl db, long sourceLsn) throws DatabaseException {
        this.setDatabase(db);
        this.setLastFullLsn(sourceLsn);
        EnvironmentImpl env = db.getDbEnvironment();
        this.initMemorySize();
        env.getInMemoryINs().add(this);
    }

    public void postRecoveryInit(DatabaseImpl db, long sourceLsn) {
        this.setDatabase(db);
        this.setLastFullLsn(sourceLsn);
        this.initMemorySize();
    }

    void setLastFullLsn(long lsn) {
        this.lastFullVersion = lsn;
    }

    public long getLastFullVersion() {
        return this.lastFullVersion;
    }

    public void latch() throws DatabaseException {
        this.setGeneration();
        this.latch.acquire();
    }

    public void releaseLatch() throws LatchNotHeldException {
        this.latch.release();
    }

    public Latch getLatch() {
        return this.latch;
    }

    public long getGeneration() {
        return this.generation;
    }

    public void setGeneration() {
        this.generation = Generation.getNextGeneration();
    }

    public void setGeneration(long newGeneration) {
        this.generation = newGeneration;
    }

    public int getLevel() {
        return this.level;
    }

    protected int generateLevel(DatabaseId dbId, int newLevel) {
        if (dbId.equals(DbTree.ID_DB_ID)) {
            return newLevel | 0x20000;
        }
        return newLevel | 0x10000;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isDbRoot() {
        return this.isRoot;
    }

    void setIsRoot(boolean isRoot) {
        this.isRoot = isRoot;
        this.setDirty(true);
    }

    public Key getIdentifierKey() {
        return this.identifierKey;
    }

    void setIdentifierKey(Key key) {
        this.identifierKey = key;
        this.setDirty(true);
    }

    public Key getChildKey(IN child) throws DatabaseException {
        return child.getIdentifierKey();
    }

    public Key selectKey(Key mainTreeKey, Key dupTreeKey) {
        return mainTreeKey;
    }

    public Key getDupKey() throws DatabaseException {
        throw new DatabaseException(this.shortClassName() + ".getDupKey() called");
    }

    public Key getDupTreeKey() {
        return null;
    }

    public Key getMainTreeKey() {
        return this.getIdentifierKey();
    }

    public DatabaseImpl getDatabase() {
        return this.databaseImpl;
    }

    public void setDatabase(DatabaseImpl db) {
        this.databaseImpl = db;
    }

    public DatabaseId getDatabaseId() {
        return this.databaseImpl.getId();
    }

    private void setEntryInternal(int from, int to) {
        this.entryTargets[to] = this.entryTargets[from];
        this.entryKeys[to] = this.entryKeys[from];
        this.entryLsns[to] = this.entryLsns[from];
        this.entryStates[to] = this.entryStates[from];
    }

    public Key getKey(int idx) {
        return this.entryKeys[idx];
    }

    private void setKey(int idx, Key key) {
        this.entryKeys[idx] = key;
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 2);
    }

    public byte getState(int idx) {
        return this.entryStates[idx];
    }

    public Node getTarget(int idx) {
        return this.entryTargets[idx];
    }

    public void setTarget(int idx, Node target) {
        this.entryTargets[idx] = target;
    }

    public void clearTarget(int idx) {
        this.entryTargets[idx] = null;
    }

    public long getLsn(int idx) {
        return this.entryLsns[idx];
    }

    public void setLsn(int idx, long lsn) {
        this.entryLsns[idx] = lsn;
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 2);
    }

    public boolean isEntryKnownDeleted(int idx) {
        return (this.entryStates[idx] & 1) != 0;
    }

    void setKnownDeleted(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 1);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
    }

    void clearKnownDeleted(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFFE);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
    }

    boolean isDirty(int idx) {
        return (this.entryStates[idx] & 2) != 0;
    }

    public int getNEntries() {
        return this.nEntries;
    }

    int getMaxEntries() {
        return this.entryTargets.length;
    }

    public Node fetchTarget(int idx) throws DatabaseException {
        if (this.isEntryKnownDeleted(idx)) {
            throw new DatabaseException("attempt to fetch a deleted entry: " + this.entryLsns[idx]);
        }
        return this.fetchTargetInternal(idx);
    }

    Node fetchTargetIgnoreKnownDeleted(int idx) throws DatabaseException {
        return this.fetchTargetInternal(idx);
    }

    private Node fetchTargetInternal(int idx) throws DatabaseException {
        if (this.entryTargets[idx] == null) {
            try {
                EnvironmentImpl env = this.databaseImpl.getDbEnvironment();
                Node node = (Node)env.getLogManager().get(this.entryLsns[idx]);
                node.postFetchInit(this.databaseImpl, this.entryLsns[idx]);
                this.entryTargets[idx] = node;
            }
            catch (LogFileNotFoundException LNFE) {
                if (!this.isEntryKnownDeleted(idx)) {
                    throw new DatabaseException(this.makeFetchErrorMsg(LNFE, this.entryLsns[idx], this.entryStates[idx]), LNFE);
                }
            }
            catch (Exception e) {
                throw new DatabaseException(this.makeFetchErrorMsg(e, this.entryLsns[idx], this.entryStates[idx]), e);
            }
            this.updateMemorySize(null, this.entryTargets[idx]);
        }
        return this.entryTargets[idx];
    }

    String makeFetchErrorMsg(Exception e, long lsn, byte state) {
        StringBuffer sb = new StringBuffer();
        sb.append("fetchTarget of ");
        if (lsn == -1L) {
            sb.append("null lsn");
        } else {
            sb.append(DbLsn.getNoFormatString(lsn));
        }
        sb.append(" IN=").append(this.getNodeId());
        sb.append(" state=").append(state);
        sb.append(" ").append(e);
        return sb.toString();
    }

    public void setEntry(int idx, Node target, Key key, long lsn, byte state) {
        long oldSize = this.getInMemorySize(idx);
        int newNEntries = idx + 1;
        if (newNEntries > this.nEntries) {
            this.nEntries = newNEntries;
            oldSize = 0L;
        }
        this.entryTargets[idx] = target;
        this.entryKeys[idx] = key;
        this.entryLsns[idx] = lsn;
        this.entryStates[idx] = state;
        long newSize = this.getInMemorySize(idx);
        this.updateMemorySize(oldSize, newSize);
        this.setDirty(true);
    }

    public void updateEntry(int idx, Node node) {
        long oldSize = this.getInMemorySize(idx);
        this.setTarget(idx, node);
        long newSize = this.getInMemorySize(idx);
        this.updateMemorySize(oldSize, newSize);
    }

    public void updateEntry(int idx, Node node, long lsn) {
        long oldSize = this.getInMemorySize(idx);
        this.setLsn(idx, lsn);
        this.setTarget(idx, node);
        long newSize = this.getInMemorySize(idx);
        this.updateMemorySize(oldSize, newSize);
        this.setDirty(true);
    }

    public void updateEntry(int idx, Node node, long lsn, Key key) {
        long oldSize = this.getInMemorySize(idx);
        this.setLsn(idx, lsn);
        this.setTarget(idx, node);
        this.setKey(idx, key);
        long newSize = this.getInMemorySize(idx);
        this.updateMemorySize(oldSize, newSize);
        this.setDirty(true);
    }

    public void updateEntry(int idx, long lsn) {
        this.setLsn(idx, lsn);
        this.setDirty(true);
    }

    public void updateEntry(int idx, long lsn, long oldLNSize, long newLNSize) {
        this.updateMemorySize(oldLNSize, newLNSize);
        this.setLsn(idx, lsn);
        this.setDirty(true);
    }

    private void updateEntryCompareKey(int idx, Node node, long lsn, Key key) {
        int s;
        long oldSize = this.getInMemorySize(idx);
        this.setLsn(idx, lsn);
        this.setTarget(idx, node);
        Key existingKey = this.getKey(idx);
        Comparator userCompareToFcn = this.getKeyComparator();
        int n = s = userCompareToFcn == null ? key.compareTo(existingKey) : userCompareToFcn.compare(key.getKey(), existingKey.getKey());
        if (s < 0) {
            this.setKey(idx, key);
        }
        long newSize = this.getInMemorySize(idx);
        this.updateMemorySize(oldSize, newSize);
        this.setDirty(true);
    }

    public boolean verifyMemorySize() {
        long calcMemorySize = this.computeMemorySize();
        if (calcMemorySize != this.inMemorySize) {
            String msg = "-Warning: Out of sync. Should be " + calcMemorySize + " / actual: " + this.inMemorySize + " node: " + this.getNodeId();
            Tracer.trace(Level.INFO, this.databaseImpl.getDbEnvironment(), msg);
            System.out.println(msg);
            return false;
        }
        return true;
    }

    public long getInMemorySize() {
        return this.inMemorySize;
    }

    long getInMemorySize(int idx) {
        Key key = this.entryKeys[idx];
        Node target = this.entryTargets[idx];
        return IN.getInMemorySize(key, target);
    }

    static long getInMemorySize(Key key, Node target) {
        long ret = 1L;
        if (key != null) {
            ret += (long)(key.getKey().length + 32);
        }
        ret += 8L;
        if (target != null) {
            ret += target.getMemorySizeIncludedByParent();
        }
        return ret;
    }

    protected long computeMemorySize() {
        MemoryBudget mb = this.databaseImpl.getDbEnvironment().getMemoryBudget();
        long calcMemorySize = this.getMemoryOverhead(mb);
        for (int i = 0; i < this.nEntries; ++i) {
            calcMemorySize += this.getInMemorySize(i);
        }
        return calcMemorySize;
    }

    public static long computeOverhead(DbConfigManager configManager) throws DatabaseException {
        int capacity = configManager.getInt(EnvironmentParams.NODE_MAX);
        return 305 + 4 * capacity * 2;
    }

    protected long getMemoryOverhead(MemoryBudget mb) {
        return mb.getINOverhead();
    }

    protected void updateMemorySize(ChildReference oldRef, ChildReference newRef) {
        long delta = 0L;
        if (newRef != null) {
            delta = IN.getInMemorySize(newRef.getKey(), newRef.getTarget());
        }
        if (oldRef != null) {
            delta -= IN.getInMemorySize(oldRef.getKey(), oldRef.getTarget());
        }
        this.changeMemorySize(delta);
    }

    protected void updateMemorySize(long oldSize, long newSize) {
        long delta = newSize - oldSize;
        this.changeMemorySize(delta);
    }

    void updateMemorySize(Node oldNode, Node newNode) {
        long delta = 0L;
        if (newNode != null) {
            delta = newNode.getMemorySizeIncludedByParent();
        }
        if (oldNode != null) {
            delta -= oldNode.getMemorySizeIncludedByParent();
        }
        this.changeMemorySize(delta);
    }

    private void changeMemorySize(long delta) {
        this.inMemorySize += delta;
        if (this.inListResident) {
            MemoryBudget mb = this.databaseImpl.getDbEnvironment().getMemoryBudget();
            mb.updateCacheMemoryUsage(delta);
        }
    }

    public void setInListResident(boolean resident) {
        this.inListResident = resident;
    }

    public boolean isKeyInBounds(Key key) {
        int cmp;
        if (this.nEntries < 2) {
            return false;
        }
        Comparator userCompareToFcn = this.getKeyComparator();
        Key myKey = this.entryKeys[0];
        int n = cmp = userCompareToFcn == null ? key.compareTo(myKey) : userCompareToFcn.compare(key.getKey(), myKey.getKey());
        if (cmp < 0) {
            return false;
        }
        myKey = this.entryKeys[this.nEntries - 1];
        int n2 = cmp = userCompareToFcn == null ? key.compareTo(myKey) : userCompareToFcn.compare(key.getKey(), myKey.getKey());
        return cmp <= 0;
    }

    public int findEntry(Key key, boolean indicateIfDuplicate, boolean exact) {
        boolean entryZeroSpecialCompare;
        int high = this.nEntries - 1;
        int low = 0;
        int middle = 0;
        Comparator userCompareToFcn = this.getKeyComparator();
        boolean bl = entryZeroSpecialCompare = this.entryZeroKeyComparesLow() && !exact && !indicateIfDuplicate;
        if (!$assertionsDisabled && this.nEntries < 0) {
            throw new AssertionError();
        }
        while (low <= high) {
            int s;
            middle = (high + low) / 2;
            Key middleKey = null;
            if (middle == 0 && entryZeroSpecialCompare) {
                s = 1;
            } else {
                middleKey = this.entryKeys[middle];
                int n = s = userCompareToFcn == null ? key.compareTo(middleKey) : userCompareToFcn.compare(key.getKey(), middleKey.getKey());
            }
            if (s < 0) {
                high = middle - 1;
                continue;
            }
            if (s > 0) {
                low = middle + 1;
                continue;
            }
            int ret = indicateIfDuplicate ? middle | 0x10000 : middle;
            if (ret >= 0 && exact && this.isEntryKnownDeleted(ret & 0xFFFF)) {
                return -1;
            }
            return ret;
        }
        if (exact) {
            return -1;
        }
        return high;
    }

    public boolean insertEntry(ChildReference entry) throws DatabaseException {
        return (this.insertEntry1(entry) & 0x20000) != 0;
    }

    public int insertEntry1(ChildReference entry) throws DatabaseException {
        if (this.nEntries >= this.entryTargets.length) {
            this.compress(null);
        }
        if (this.nEntries < this.entryTargets.length) {
            Key key = entry.getKey();
            int index = this.findEntry(key, true, false);
            if (index >= 0 && (index & 0x10000) != 0) {
                return index;
            }
            if (++index < this.nEntries) {
                this.shiftEntriesRight(index);
            }
            this.entryTargets[index] = entry.getTarget();
            this.entryKeys[index] = entry.getKey();
            this.entryLsns[index] = entry.getLsn();
            this.entryStates[index] = entry.getState();
            ++this.nEntries;
            this.adjustCursorsForInsert(index);
            this.updateMemorySize(0L, this.getInMemorySize(index));
            this.setDirty(true);
            return index | 0x20000;
        }
        throw new InconsistentNodeException("Node " + this.getNodeId() + " should have been split before calling insertEntry");
    }

    boolean deleteEntry(Key key, boolean maybeValidate) throws DatabaseException {
        if (this.nEntries == 0) {
            return false;
        }
        int index = this.findEntry(key, false, true);
        if (index < 0) {
            return false;
        }
        return this.deleteEntry(index, maybeValidate);
    }

    public boolean deleteEntry(int index, boolean maybeValidate) throws DatabaseException {
        if (this.nEntries == 0) {
            return false;
        }
        if (!$assertionsDisabled && maybeValidate && !this.validateSubtreeBeforeDelete(index)) {
            throw new AssertionError();
        }
        if (index < this.nEntries) {
            this.updateMemorySize(this.getInMemorySize(index), 0L);
            for (int i = index; i < this.nEntries - 1; ++i) {
                this.setEntryInternal(i + 1, i);
            }
            --this.nEntries;
            this.setDirty(true);
            this.setCompressedSinceLastLog();
            this.traceDelete(Level.FINEST, index);
            return true;
        }
        return false;
    }

    protected void setCompressedSinceLastLog() {
    }

    public void setCleanedSinceLastLog() {
    }

    public boolean compress(BINReference binRef) throws DatabaseException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateSubtreeBeforeDelete(int index) throws DatabaseException {
        boolean needToLatch = !this.getLatch().isOwner();
        try {
            if (needToLatch) {
                this.latch();
            }
            if (index >= this.nEntries) {
                boolean bl = true;
                return bl;
            }
            Node child = this.fetchTarget(index);
            boolean bl = child.isValidForDelete();
            return bl;
        }
        finally {
            if (needToLatch && this.getLatch().isOwner()) {
                this.releaseLatch();
            }
        }
    }

    Key makePrefixKey(Key wholeKey) {
        return wholeKey;
    }

    public boolean needsSplitting() {
        return this.entryTargets.length - this.nEntries < 1;
    }

    boolean entryZeroKeyComparesLow() {
        return true;
    }

    void split(IN parent, int childIndex, int maxEntries) throws DatabaseException {
        this.splitInternal(parent, childIndex, maxEntries, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void splitInternal(IN parent, int childIndex, int maxEntries, int splitIndex) throws DatabaseException {
        int high;
        int low;
        if (this.identifierKey == null) {
            throw new InconsistentNodeException("idkey is null");
        }
        int idKeyIndex = this.findEntry(this.identifierKey, false, false);
        if (splitIndex < 0) {
            splitIndex = this.nEntries / 2;
        }
        IN newSibling = null;
        if (idKeyIndex < splitIndex) {
            low = splitIndex;
            high = this.nEntries;
        } else {
            low = 0;
            high = splitIndex;
        }
        Key newIdKey = this.entryKeys[low];
        long parentLsn = -1L;
        newSibling = this.createNewInstance(newIdKey, maxEntries, this.level);
        newSibling.latch();
        long oldMemorySize = this.inMemorySize;
        try {
            boolean insertOk;
            int toIdx = 0;
            for (int i = low; i < high; ++i) {
                newSibling.setEntry(toIdx++, this.entryTargets[i], this.entryKeys[i], this.entryLsns[i], this.entryStates[i]);
            }
            int newSiblingNEntries = high - low;
            if (low == 0) {
                this.shiftEntriesLeft(newSiblingNEntries);
            }
            newSibling.nEntries = toIdx;
            this.nEntries -= newSiblingNEntries;
            this.setDirty(true);
            this.adjustCursors(newSibling, low, high);
            EnvironmentImpl env = this.databaseImpl.getDbEnvironment();
            LogManager logManager = env.getLogManager();
            INList inMemoryINs = env.getInMemoryINs();
            long newSiblingLsn = newSibling.logProvisional(logManager);
            long myNewLsn = this.logProvisional(logManager);
            if (low == 0) {
                if (childIndex == 0) {
                    parent.updateEntryCompareKey(childIndex, newSibling, newSiblingLsn, newIdKey);
                } else {
                    parent.updateEntry(childIndex, newSibling, newSiblingLsn);
                }
                insertOk = parent.insertEntry(new ChildReference(this, this.entryKeys[0], myNewLsn));
                if (!$assertionsDisabled && !insertOk) {
                    throw new AssertionError();
                }
            } else {
                if (childIndex == 0) {
                    parent.updateEntryCompareKey(childIndex, this, myNewLsn, this.entryKeys[0]);
                } else {
                    parent.updateEntry(childIndex, this, myNewLsn);
                }
                insertOk = parent.insertEntry(new ChildReference(newSibling, newIdKey, newSiblingLsn));
                if (!$assertionsDisabled && !insertOk) {
                    throw new AssertionError();
                }
            }
            parentLsn = parent.log(logManager);
            if (parent.isRoot()) {
                parent.setDirty(true);
            }
            long newSize = this.computeMemorySize();
            this.updateMemorySize(oldMemorySize, newSize);
            inMemoryINs.add(newSibling);
            this.traceSplit(Level.FINE, parent, newSibling, parentLsn, myNewLsn, newSiblingLsn, splitIndex, idKeyIndex, childIndex);
        }
        finally {
            newSibling.releaseLatch();
        }
    }

    void splitSpecial(IN parent, int parentIndex, int maxEntriesPerNode, Key key, boolean leftSide) throws DatabaseException {
        int index = this.findEntry(key, false, false);
        if (leftSide && index == 0) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, 1);
        } else if (!leftSide && index == this.nEntries - 1) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, this.nEntries - 1);
        } else {
            this.split(parent, parentIndex, maxEntriesPerNode);
        }
    }

    void adjustCursors(IN newSibling, int newSiblingLow, int newSiblingHigh) {
    }

    void adjustCursorsForInsert(int insertIndex) {
    }

    public Comparator getKeyComparator() {
        return this.databaseImpl.getBtreeComparator();
    }

    private void shiftEntriesRight(int index) {
        for (int i = this.nEntries; i > index; --i) {
            this.setEntryInternal(i - 1, i);
        }
        this.setDirty(true);
    }

    private void shiftEntriesLeft(int byHowMuch) {
        for (int i = 0; i < this.nEntries - byHowMuch; ++i) {
            this.setEntryInternal(i + byHowMuch, i);
        }
        this.setDirty(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify(Key maxKey) throws DatabaseException {
        boolean unlatchThis = false;
        try {
            if (!this.getLatch().isOwner()) {
                this.latch();
                unlatchThis = true;
            }
            Comparator userCompareToFcn = this.databaseImpl == null ? null : this.getKeyComparator();
            Key key1 = null;
            for (int i = 1; i < this.nEntries; ++i) {
                int s;
                key1 = this.entryKeys[i];
                Key key2 = this.entryKeys[i - 1];
                int n = s = userCompareToFcn == null ? key1.compareTo(key2) : userCompareToFcn.compare(key1.getKey(), key2.getKey());
                if (s > 0) continue;
                throw new InconsistentNodeException("IN " + this.getNodeId() + " key " + (i - 1) + " (" + key2.toString() + ") and " + i + " (" + key1.toString() + ") are out of order");
            }
            boolean inconsistent = false;
            if (maxKey != null && key1 != null) {
                if (userCompareToFcn == null) {
                    if (key1.compareTo(maxKey) >= 0) {
                        inconsistent = true;
                    }
                } else if (userCompareToFcn.compare(key1.getKey(), maxKey.getKey()) >= 0) {
                    inconsistent = true;
                }
            }
            if (inconsistent) {
                throw new InconsistentNodeException("IN " + this.getNodeId() + " has entry larger than next entry in parent.");
            }
        }
        catch (DatabaseException DE) {
            DE.printStackTrace(System.out);
        }
        finally {
            if (unlatchThis) {
                this.releaseLatch();
            }
        }
    }

    void rebuildINList(INList inList) throws DatabaseException {
        this.initMemorySize();
        inList.add(this);
        for (int i = 0; i < this.nEntries; ++i) {
            Node n = this.getTarget(i);
            if (n == null) continue;
            n.rebuildINList(inList);
        }
    }

    void accountForSubtreeRemoval(INList inList, Set modifiedFileSummaries) throws DatabaseException {
        if (this.nEntries > 1) {
            throw new DatabaseException("Found non-deletable IN " + this.getNodeId() + " while flushing INList. nEntries = " + this.nEntries);
        }
        inList.removeLatchAlreadyHeld(this);
        if (this.lastFullVersion != -1L) {
            this.databaseImpl.getDbEnvironment().getLogManager().countObsoleteNodes(this.lastFullVersion, this.getLogType(), true, -1L, null, false);
            modifiedFileSummaries.add(new Long(DbLsn.getFileNumber(this.lastFullVersion)));
        }
        for (int i = 0; i < this.nEntries; ++i) {
            Node n = this.fetchTargetIgnoreKnownDeleted(i);
            if (n == null) continue;
            n.accountForSubtreeRemoval(inList, modifiedFileSummaries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidForDelete() throws DatabaseException {
        boolean needToLatch = !this.getLatch().isOwner();
        try {
            if (needToLatch) {
                this.latch();
            }
            if (this.nEntries > 1) {
                boolean bl = false;
                return bl;
            }
            if (this.nEntries == 1) {
                Node child = this.fetchTarget(0);
                boolean bl = child.isValidForDelete();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (needToLatch && this.getLatch().isOwner()) {
                this.releaseLatch();
            }
        }
    }

    void findParent(Tree.SearchType searchType, long targetNodeId, boolean targetContainsDuplicates, boolean targetIsRoot, Key targetMainTreeKey, Key targetDupTreeKey, SearchResult result, boolean requireExactMatch, List trackingList, boolean doFetch) throws DatabaseException {
        if (!$assertionsDisabled && !this.getLatch().isOwner()) {
            throw new AssertionError();
        }
        if (this.getNodeId() == targetNodeId) {
            this.releaseLatch();
            result.exactParentFound = false;
            result.keepSearching = false;
            result.parent = null;
            return;
        }
        if (this.getNEntries() == 0) {
            result.keepSearching = false;
            result.exactParentFound = false;
            if (requireExactMatch) {
                this.releaseLatch();
                result.parent = null;
            } else {
                result.parent = this;
                result.index = -1;
            }
            return;
        }
        if (searchType == Tree.SearchType.NORMAL) {
            result.index = this.findEntry(this.selectKey(targetMainTreeKey, targetDupTreeKey), false, false);
        } else if (searchType == Tree.SearchType.LEFT) {
            result.index = 0;
        } else if (searchType == Tree.SearchType.RIGHT) {
            result.index = this.nEntries - 1;
        } else {
            throw new IllegalArgumentException("Invalid value of searchType: " + searchType);
        }
        if (result.index < 0) {
            result.keepSearching = false;
            result.exactParentFound = false;
            if (requireExactMatch) {
                this.releaseLatch();
                result.parent = null;
            } else {
                result.parent = this;
            }
            return;
        }
        if (this.isEntryKnownDeleted(result.index)) {
            result.exactParentFound = false;
            result.keepSearching = false;
            if (requireExactMatch) {
                result.parent = null;
                this.releaseLatch();
            } else {
                result.parent = this;
            }
            return;
        }
        Node child = null;
        if (doFetch) {
            child = this.fetchTarget(result.index);
        } else {
            child = this.getTarget(result.index);
            if (child == null) {
                result.keepSearching = false;
                result.exactParentFound = false;
                result.parent = this;
                result.childNotResident = true;
                return;
            }
        }
        long childLsn = this.getLsn(result.index);
        if (child.isSoughtNode(targetNodeId)) {
            result.exactParentFound = true;
            result.parent = this;
            result.keepSearching = false;
            return;
        }
        this.descendOnParentSearch(result, targetContainsDuplicates, targetIsRoot, targetNodeId, child, requireExactMatch);
        if (trackingList != null && result.parent != this && result.parent != null) {
            trackingList.add(new TrackingInfo(childLsn, child.getNodeId()));
        }
    }

    protected void descendOnParentSearch(SearchResult result, boolean targetContainsDuplicates, boolean targetIsRoot, long targetNodeId, Node child, boolean requireExactMatch) throws DatabaseException {
        if (child.canBeAncestor(targetContainsDuplicates)) {
            this.releaseLatch();
            result.parent = (IN)child;
        } else {
            ((IN)child).releaseLatch();
            result.exactParentFound = false;
            result.keepSearching = false;
            if (requireExactMatch) {
                this.releaseLatch();
                result.parent = null;
            } else {
                result.parent = this;
            }
        }
    }

    protected boolean isSoughtNode(long nid) throws DatabaseException {
        this.latch();
        if (this.getNodeId() == nid) {
            this.releaseLatch();
            return true;
        }
        return false;
    }

    protected boolean canBeAncestor(boolean targetContainsDuplicates) {
        return true;
    }

    public boolean isEvictable() {
        if (this.evictionProhibited) {
            return false;
        }
        for (int i = 0; i < this.nEntries; ++i) {
            if (this.getTarget(i) == null) continue;
            return false;
        }
        return true;
    }

    public void setEvictionProhibited(boolean pinned) {
        this.evictionProhibited = pinned;
    }

    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processIN(this, new Long(this.getNodeId()), this.getLevel());
    }

    public long log(LogManager logManager) throws DatabaseException {
        return this.logInternal(logManager, false, false);
    }

    public long log(LogManager logManager, boolean isProvisional) throws DatabaseException {
        return this.logInternal(logManager, false, isProvisional);
    }

    public long logProvisional(LogManager logManager) throws DatabaseException {
        return this.logInternal(logManager, false, true);
    }

    public long logAllowDeltas(LogManager logManager, boolean isProvisional) throws DatabaseException {
        return this.logInternal(logManager, true, isProvisional);
    }

    protected long logInternal(LogManager logManager, boolean allowDeltas, boolean isProvisional) throws DatabaseException {
        long lsn = logManager.log(new INLogEntry(this), isProvisional, this.getLastFullVersion(), false);
        this.setLastFullLsn(lsn);
        this.setDirty(false);
        return lsn;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_IN;
    }

    public int getLogSize() {
        int size = super.getLogSize();
        size += this.identifierKey.getLogSize();
        size += LogUtils.getBooleanLogSize();
        size += 4;
        size += 4;
        size += 4;
        for (int i = 0; i < this.nEntries; ++i) {
            size += this.entryKeys[i].getLogSize() + LogUtils.getLongLogSize() + 1;
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        this.identifierKey.writeToLog(logBuffer);
        LogUtils.writeBoolean(logBuffer, this.isRoot);
        LogUtils.writeInt(logBuffer, this.nEntries);
        LogUtils.writeInt(logBuffer, this.level);
        LogUtils.writeInt(logBuffer, this.entryTargets.length);
        int i = 0;
        while (i < this.nEntries) {
            this.entryKeys[i].writeToLog(logBuffer);
            if (!$assertionsDisabled && this.entryLsns[i] == -1L) {
                throw new AssertionError();
            }
            LogUtils.writeLong(logBuffer, this.entryLsns[i]);
            logBuffer.put(this.entryStates[i]);
            int n = i++;
            this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFFD);
        }
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        super.readFromLog(itemBuffer);
        this.identifierKey.readFromLog(itemBuffer);
        this.isRoot = LogUtils.readBoolean(itemBuffer);
        this.nEntries = LogUtils.readInt(itemBuffer);
        this.level = LogUtils.readInt(itemBuffer);
        int length = LogUtils.readInt(itemBuffer);
        this.entryTargets = new Node[length];
        this.entryKeys = new Key[length];
        this.entryLsns = new long[length];
        this.entryStates = new byte[length];
        int i = 0;
        while (i < this.nEntries) {
            this.entryKeys[i] = new Key();
            this.entryKeys[i].readFromLog(itemBuffer);
            this.entryLsns[i] = LogUtils.readLong(itemBuffer);
            this.entryStates[i] = itemBuffer.get();
            int n = i++;
            this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFFD);
        }
        this.latch.setName(this.shortClassName() + this.getNodeId());
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append(this.beginTag());
        super.dumpLog(sb, verbose);
        this.identifierKey.dumpLog(sb, verbose);
        sb.append("<isRoot val=\"");
        sb.append(this.isRoot);
        sb.append("\"/>");
        sb.append("<level val=\"");
        sb.append(Integer.toHexString(this.level));
        sb.append("\"/>");
        sb.append("<entries numEntries=\"");
        sb.append(this.nEntries);
        sb.append("\" length=\"");
        sb.append(this.entryTargets.length);
        sb.append("\">");
        if (verbose) {
            for (int i = 0; i < this.nEntries; ++i) {
                sb.append("<ref knownDeleted=\"").append(this.isEntryKnownDeleted(i));
                sb.append("\">");
                this.entryKeys[i].dumpLog(sb, verbose);
                sb.append(DbLsn.toString(this.entryLsns[i]));
                sb.append("</ref>");
            }
        }
        sb.append("</entries>");
        this.dumpLogAdditional(sb);
        sb.append(this.endTag());
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    protected void dumpLogAdditional(StringBuffer sb) {
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    void dumpKeys() throws DatabaseException {
        for (int i = 0; i < this.nEntries; ++i) {
            System.out.println(this.entryKeys[i].toString());
        }
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.beginTag());
            sb.append('\n');
        }
        sb.append(super.dumpString(nSpaces + 2, true));
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<idkey>");
        sb.append(this.identifierKey == null ? "" : this.identifierKey.toString());
        sb.append("</idkey>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<dirty val=\"").append(this.dirty).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<generation val=\"").append(this.generation).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<level val=\"");
        sb.append(Integer.toHexString(this.level)).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<isRoot val=\"").append(this.isRoot).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<entries nEntries=\"");
        sb.append(this.nEntries);
        sb.append("\">");
        sb.append('\n');
        for (int i = 0; i < this.nEntries; ++i) {
            sb.append(TreeUtils.indent(nSpaces + 4));
            sb.append("<entry id=\"" + i + "\">");
            sb.append('\n');
            if (this.entryTargets[i] == null) {
                sb.append(TreeUtils.indent(nSpaces + 6));
                sb.append("<empty>");
            } else {
                if (this.entryLsns[i] == -1L) {
                    sb.append(TreeUtils.indent(nSpaces + 6));
                    sb.append("<lsn/>");
                } else {
                    sb.append(DbLsn.dumpString(this.entryLsns[i], nSpaces + 6));
                }
                sb.append('\n');
                if (this.entryKeys[i] == null) {
                    sb.append(TreeUtils.indent(nSpaces + 6));
                    sb.append("<key/>");
                } else {
                    sb.append(this.entryKeys[i].dumpString(nSpaces + 6));
                }
                sb.append('\n');
                if (this.entryTargets[i] == null) {
                    sb.append(TreeUtils.indent(nSpaces + 6));
                    sb.append("<target/>");
                } else {
                    sb.append(this.entryTargets[i].dumpString(nSpaces + 6, true));
                }
                sb.append('\n');
                sb.append(TreeUtils.indent(nSpaces + 6));
                sb.append("<knownDeleted val=\"");
                sb.append(this.isEntryKnownDeleted(i)).append("\"/>");
                sb.append("<dirty val=\"").append(this.isDirty(i)).append("\"/>");
            }
            sb.append('\n');
            sb.append(TreeUtils.indent(nSpaces + 4));
            sb.append("</entry>");
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("</entries>");
        sb.append('\n');
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.endTag());
        }
        return sb.toString();
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    public String shortClassName() {
        return "IN";
    }

    void traceSplit(Level level, IN parent, IN newSibling, long parentLsn, long myNewLsn, long newSiblingLsn, int splitIndex, int idKeyIndex, int childIndex) {
        Logger logger = this.databaseImpl.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_SPLIT);
            sb.append(" parent=");
            sb.append(parent.getNodeId());
            sb.append(" child=");
            sb.append(this.getNodeId());
            sb.append(" newSibling=");
            sb.append(newSibling.getNodeId());
            sb.append(" parentLsn = ");
            sb.append(DbLsn.getNoFormatString(parentLsn));
            sb.append(" childLsn = ");
            sb.append(DbLsn.getNoFormatString(myNewLsn));
            sb.append(" newSiblingLsn = ");
            sb.append(DbLsn.getNoFormatString(newSiblingLsn));
            sb.append(" splitIdx=");
            sb.append(splitIndex);
            sb.append(" idKeyIdx=");
            sb.append(idKeyIndex);
            sb.append(" childIdx=");
            sb.append(childIndex);
            logger.log(level, sb.toString());
        }
    }

    private void traceDelete(Level level, int index) {
        Logger logger = this.databaseImpl.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_DELETE);
            sb.append(" in=").append(this.getNodeId());
            sb.append(" index=");
            sb.append(index);
            logger.log(level, sb.toString());
        }
    }

    static {
        $assertionsDisabled = !IN.class.desiredAssertionStatus();
    }
}

