/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.tree.Key;
import java.nio.ByteBuffer;

public class INDupDeleteInfo
implements LoggableObject,
LogReadable,
LogWritable {
    private long deletedNodeId;
    private Key deletedMainKey;
    private Key deletedDupKey;
    private DatabaseId dbId;

    public INDupDeleteInfo(long deletedNodeId, Key deletedMainKey, Key deletedDupKey, DatabaseId dbId) {
        this.deletedNodeId = deletedNodeId;
        this.deletedMainKey = deletedMainKey;
        this.deletedDupKey = deletedDupKey;
        this.dbId = dbId;
    }

    public INDupDeleteInfo() {
        this.deletedMainKey = new Key();
        this.deletedDupKey = new Key();
        this.dbId = new DatabaseId();
    }

    public long getDeletedNodeId() {
        return this.deletedNodeId;
    }

    public Key getDeletedMainKey() {
        return this.deletedMainKey;
    }

    public Key getDeletedDupKey() {
        return this.deletedDupKey;
    }

    public DatabaseId getDatabaseId() {
        return this.dbId;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_IN_DUPDELETE_INFO;
    }

    public boolean marshallOutsideWriteLatch() {
        return true;
    }

    public void postLogWork(long justLoggedLsn) {
    }

    public int getLogSize() {
        return 8 + this.deletedMainKey.getLogSize() + this.deletedDupKey.getLogSize() + this.dbId.getLogSize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeLong(logBuffer, this.deletedNodeId);
        this.deletedMainKey.writeToLog(logBuffer);
        this.deletedDupKey.writeToLog(logBuffer);
        this.dbId.writeToLog(logBuffer);
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        this.deletedNodeId = LogUtils.readLong(itemBuffer);
        this.deletedMainKey.readFromLog(itemBuffer);
        this.deletedDupKey.readFromLog(itemBuffer);
        this.dbId.readFromLog(itemBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<INDupDeleteEntry node=\"").append(this.deletedNodeId);
        sb.append("\">");
        this.deletedMainKey.dumpLog(sb, verbose);
        this.deletedDupKey.dumpLog(sb, verbose);
        this.dbId.dumpLog(sb, verbose);
        sb.append("</INDupDeleteEntry>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }
}

