/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.TxnAbort;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Txn
extends Locker
implements LogWritable,
LogReadable {
    public static final byte TXN_NOSYNC = 0;
    public static final byte TXN_WRITE_NOSYNC = 1;
    public static final byte TXN_SYNC = 2;
    private static final String DEBUG_NAME;
    private byte txnState;
    private CursorImpl cursorSet;
    private static final byte USABLE = 0;
    private static final byte CLOSED = 1;
    private static final byte ONLY_ABORTABLE = 2;
    private Set readLocks;
    private Map writeInfo;
    private Set deletedDatabases;
    private Map undoDatabases;
    private long lastLoggedLsn = -1L;
    private long firstLoggedLsn = -1L;
    private byte defaultFlushSyncBehavior;
    private boolean serializableIsolation;
    private int inMemorySize;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Txn(EnvironmentImpl envImpl, TransactionConfig config) throws DatabaseException {
        super(envImpl, config.getDirtyRead(), config.getNoWait());
        this.serializableIsolation = config.getSerializableIsolation();
        this.defaultFlushSyncBehavior = config.getSync() ? (byte)2 : (config.getWriteNoSync() ? (byte)1 : (config.getNoSync() ? (byte)0 : (byte)2));
        this.lastLoggedLsn = -1L;
        this.firstLoggedLsn = -1L;
        this.txnState = 0;
        this.inMemorySize = 160;
        this.envImpl.getTxnManager().registerTxn(this);
    }

    public Txn() {
        this.lastLoggedLsn = -1L;
    }

    protected long generateId(TxnManager txnManager) {
        return txnManager.incTxnId();
    }

    long getLastLsn() {
        return this.lastLoggedLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockResult lock(long nodeId, LockType lockType, DatabaseImpl database) throws DatabaseException {
        long timeout;
        this.checkState(false);
        Txn txn = this;
        synchronized (txn) {
            timeout = this.lockTimeOutMillis;
        }
        LockGrantType grant = this.lockManager.lock(nodeId, this, lockType, timeout, this.defaultNoWait);
        WriteLockInfo info = null;
        if (lockType.isWriteLock()) {
            Txn txn2 = this;
            synchronized (txn2) {
                info = (WriteLockInfo)this.writeInfo.get(new Long(nodeId));
                this.undoDatabases.put(database.getId(), database);
            }
        }
        return new LockResult(grant, info);
    }

    public long commit() throws DatabaseException {
        return this.commit(this.defaultFlushSyncBehavior);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long commit(byte flushSyncBehavior) throws DatabaseException {
        this.checkState(false);
        try {
            long commitLsn = -1L;
            Txn txn = this;
            synchronized (txn) {
                if (this.checkCursorsForClose()) {
                    throw new DatabaseException("Transaction " + this.id + " commit failed because there were open cursors");
                }
                if (this.handleLockToHandleMap != null) {
                    Iterator handleLockIter = this.handleLockToHandleMap.entrySet().iterator();
                    while (handleLockIter.hasNext()) {
                        Map.Entry entry = handleLockIter.next();
                        this.transferHandleLockToHandleSet((Long)entry.getKey(), (Set)entry.getValue());
                    }
                }
                LogManager logManager = this.envImpl.getLogManager();
                int numReadLocks = 0;
                if (this.readLocks != null) {
                    numReadLocks = this.readLocks.size();
                    Iterator iter = this.readLocks.iterator();
                    while (iter.hasNext()) {
                        Lock rLock = (Lock)iter.next();
                        this.lockManager.release(rLock, (Locker)this);
                    }
                    this.readLocks = null;
                }
                int numWriteLocks = 0;
                if (this.writeInfo != null) {
                    numWriteLocks = this.writeInfo.size();
                    TxnCommit commitRecord = new TxnCommit(this.id, this.lastLoggedLsn);
                    commitLsn = flushSyncBehavior == 2 ? logManager.logForceFlush(commitRecord, true) : (flushSyncBehavior == 1 ? logManager.logForceFlush(commitRecord, false) : logManager.log(commitRecord));
                    Iterator iter = this.writeInfo.values().iterator();
                    while (iter.hasNext()) {
                        WriteLockInfo info = (WriteLockInfo)iter.next();
                        this.lockManager.release(info.lock, (Locker)this);
                    }
                    this.writeInfo = null;
                    if (this.deleteInfo != null && this.deleteInfo.size() > 0) {
                        this.envImpl.addToCompressorQueue(this.deleteInfo.values());
                        this.deleteInfo.clear();
                    }
                    this.cleanupDatabaseImpls(true);
                }
                this.traceCommit(numWriteLocks, numReadLocks);
            }
            this.close(true);
            return commitLsn;
        }
        catch (RunRecoveryException e) {
            throw e;
        }
        catch (Throwable t) {
            try {
                this.abort();
                Tracer.trace(this.envImpl, "Txn", "commit", "Commit of transaction " + this.id + " failed", t);
            }
            catch (Throwable abortT2) {
                throw new DatabaseException("Failed while attempting to commit transaction " + this.id + ". The attempt to abort and clean up also failed. " + "The original exception seen from commit = " + t.getMessage() + " The exception from the cleanup = " + abortT2.getMessage(), t);
            }
            throw new DatabaseException("Failed while attempting to commit transaction " + this.id + ", aborted instead. Original exception = " + t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long abort() throws DatabaseException {
        try {
            Txn txn = this;
            synchronized (txn) {
                this.checkState(true);
                TxnAbort abortRecord = new TxnAbort(this.id, this.lastLoggedLsn);
                long abortLsn = -1L;
                if (this.writeInfo != null) {
                    abortLsn = this.envImpl.getLogManager().log(abortRecord);
                }
                this.undo();
                int numReadLocks = 0;
                if (this.readLocks != null) {
                    numReadLocks = this.readLocks.size();
                    Iterator iter = this.readLocks.iterator();
                    while (iter.hasNext()) {
                        Lock rLock = (Lock)iter.next();
                        this.lockManager.release(rLock, (Locker)this);
                    }
                    this.readLocks = null;
                }
                int numWriteLocks = 0;
                if (this.writeInfo != null) {
                    numWriteLocks = this.writeInfo.size();
                    Iterator iter = this.writeInfo.values().iterator();
                    while (iter.hasNext()) {
                        WriteLockInfo info = (WriteLockInfo)iter.next();
                        this.lockManager.release(info.lock, (Locker)this);
                    }
                    this.writeInfo = null;
                }
                this.deleteInfo = null;
                this.cleanupDatabaseImpls(false);
                boolean openCursors = this.checkCursorsForClose();
                Tracer.trace(Level.FINE, this.envImpl, "Abort:id = " + this.id + " numWriteLocks= " + numWriteLocks + " numReadLocks= " + numReadLocks + " openCursors= " + openCursors);
                if (openCursors) {
                    throw new DatabaseException("Transaction " + this.id + " detected open cursors while aborting");
                }
                if (this.handleToHandleLockMap != null) {
                    Iterator handleIter = this.handleToHandleLockMap.keySet().iterator();
                    while (handleIter.hasNext()) {
                        Database handle = (Database)handleIter.next();
                        DbInternal.dbInvalidate(handle);
                    }
                }
                long l = abortLsn;
                return l;
            }
        }
        finally {
            this.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void undo() throws DatabaseException {
        Long nodeId = null;
        long undoLsn = this.lastLoggedLsn;
        LogManager logManager = this.envImpl.getLogManager();
        try {
            HashSet<Long> alreadyUndone = new HashSet<Long>();
            TreeLocation location = new TreeLocation();
            while (undoLsn != -1L) {
                LNLogEntry undoEntry = (LNLogEntry)logManager.getLogEntry(undoLsn);
                LN undoLN = undoEntry.getLN();
                nodeId = new Long(undoLN.getNodeId());
                if (!alreadyUndone.contains(nodeId)) {
                    boolean abortKnownDeleted;
                    long abortLsn;
                    block10: {
                        alreadyUndone.add(nodeId);
                        DatabaseId dbId = undoEntry.getDbId();
                        DatabaseImpl db = (DatabaseImpl)this.undoDatabases.get(dbId);
                        undoLN.postFetchInit(db, undoLsn);
                        abortLsn = undoEntry.getAbortLsn();
                        abortKnownDeleted = undoEntry.getAbortKnownDeleted();
                        try {
                            boolean insertedOrReplaced = RecoveryManager.undo(Level.FINER, db, location, undoLN, undoEntry.getKey(), undoEntry.getDupKey(), undoLsn, abortLsn, abortKnownDeleted, null, false);
                            Object var16_16 = null;
                            if (location.bin == null || !location.bin.getLatch().isOwner()) break block10;
                        }
                        catch (Throwable throwable) {
                            Object var16_17 = null;
                            if (location.bin == null || !location.bin.getLatch().isOwner()) throw throwable;
                            location.bin.releaseLatch();
                            throw throwable;
                        }
                        location.bin.releaseLatch();
                    }
                    long obsoleteLsn = -1L;
                    long nonObsoleteLsn = -1L;
                    if (!undoLN.isDeleted()) {
                        obsoleteLsn = undoLsn;
                    }
                    if (abortLsn != -1L && !abortKnownDeleted) {
                        nonObsoleteLsn = abortLsn;
                    }
                    if (obsoleteLsn != -1L || nonObsoleteLsn != -1L) {
                        logManager.countObsoleteNodes(obsoleteLsn, null, true, nonObsoleteLsn, null, false);
                    }
                }
                undoLsn = undoEntry.getUserTxn().getLastLsn();
            }
            return;
        }
        catch (DatabaseException e) {
            Tracer.trace(this.envImpl, "Txn", "undo", "for node=" + nodeId + " LSN=" + DbLsn.getNoFormatString(undoLsn), e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogInfo(long nodeId, long lastLsn) throws DatabaseException {
        this.lastLoggedLsn = lastLsn;
        Txn txn = this;
        synchronized (txn) {
            if (this.firstLoggedLsn == -1L) {
                this.firstLoggedLsn = lastLsn;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getFirstActiveLsn() throws DatabaseException {
        long first = -1L;
        Txn txn = this;
        synchronized (txn) {
            first = this.firstLoggedLsn;
        }
        return first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDeleteAtTxnEnd(DatabaseImpl dbImpl, boolean deleteAtCommit, MemoryBudget mb) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            int delta = 0;
            if (this.deletedDatabases == null) {
                this.deletedDatabases = new HashSet();
                delta += 130;
            }
            this.deletedDatabases.add(new DatabaseCleanupInfo(dbImpl, deleteAtCommit));
            mb.updateCacheMemoryUsage(delta += 32);
            this.inMemorySize += delta;
        }
    }

    private void cleanupDatabaseImpls(boolean isCommit) throws DatabaseException {
        if (this.deletedDatabases != null) {
            Iterator iter = this.deletedDatabases.iterator();
            while (iter.hasNext()) {
                DatabaseCleanupInfo info = (DatabaseCleanupInfo)iter.next();
                if (info.deleteAtCommit != isCommit) continue;
                DatabaseImpl dbImpl = info.dbImpl;
                if (!isCommit) {
                    dbImpl.recordObsoleteNodes();
                }
                dbImpl.deleteAndReleaseINs();
            }
            this.deletedDatabases = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLock(Long nodeId, Lock lock, LockType type, LockGrantType grantStatus, MemoryBudget mb) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            int delta = 0;
            if (type.isWriteLock()) {
                if (this.writeInfo == null) {
                    this.writeInfo = new HashMap();
                    this.undoDatabases = new HashMap();
                    delta += 240;
                }
                this.writeInfo.put(nodeId, new WriteLockInfo(lock));
                delta += 40;
                if (grantStatus == LockGrantType.PROMOTION || grantStatus == LockGrantType.WAIT_PROMOTION) {
                    this.readLocks.remove(lock);
                    delta -= 130;
                }
                this.inMemorySize += delta;
                mb.updateCacheMemoryUsage(delta);
            } else {
                this.addReadLock(lock, mb);
            }
        }
    }

    private void addReadLock(Lock lock, MemoryBudget mb) {
        int delta = 0;
        if (this.readLocks == null) {
            this.readLocks = new HashSet();
            delta = 130;
        }
        this.readLocks.add(lock);
        this.inMemorySize += (delta += 24);
        mb.updateCacheMemoryUsage(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLock(long nodeId, Lock lock) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            if (this.readLocks != null && !this.readLocks.remove(lock) && this.writeInfo != null) {
                this.writeInfo.remove(new Long(nodeId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveWriteToReadLock(long nodeId, Lock lock, MemoryBudget mb) {
        boolean found = false;
        Txn txn = this;
        synchronized (txn) {
            if (this.writeInfo != null && this.writeInfo.remove(new Long(nodeId)) != null) {
                found = true;
                int delta = 40;
                this.inMemorySize -= delta;
                mb.updateCacheMemoryUsage(0 - delta);
            }
            if (!$assertionsDisabled && !found) {
                throw new AssertionError((Object)("Couldn't find lock for Node " + nodeId + " in writeInfo Map."));
            }
            this.addReadLock(lock, mb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createdNode(long nodeId) throws DatabaseException {
        boolean created = false;
        Txn txn = this;
        synchronized (txn) {
            WriteLockInfo info;
            if (this.writeInfo != null && (info = (WriteLockInfo)this.writeInfo.get(new Long(nodeId))) != null) {
                created = info.createdThisTxn;
            }
        }
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAbortLsn(long nodeId) throws DatabaseException {
        WriteLockInfo info = null;
        Txn txn = this;
        synchronized (txn) {
            if (this.writeInfo != null) {
                info = (WriteLockInfo)this.writeInfo.get(new Long(nodeId));
            }
        }
        if (info == null) {
            return -1L;
        }
        return info.abortLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAbortKnownDeleted(long nodeId) throws DatabaseException {
        WriteLockInfo info = null;
        Txn txn = this;
        synchronized (txn) {
            if (this.writeInfo != null) {
                info = (WriteLockInfo)this.writeInfo.get(new Long(nodeId));
            }
        }
        if (info == null) {
            return true;
        }
        return info.abortKnownDeleted;
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean isSerializableIsolation() {
        return this.serializableIsolation;
    }

    public Locker newInstance() throws DatabaseException {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Only ThreadLocker should be cloned");
        }
        return null;
    }

    public void operationEnd() throws DatabaseException {
    }

    public void operationEnd(boolean operationOK) throws DatabaseException {
    }

    public void setHandleLockOwner(boolean operationOK, Database dbHandle, boolean dbIsClosing) throws DatabaseException {
        if (dbIsClosing) {
            Long handleLockId = (Long)this.handleToHandleLockMap.get(dbHandle);
            if (handleLockId != null) {
                Set dbHandleSet = (Set)this.handleLockToHandleMap.get(handleLockId);
                boolean removed = dbHandleSet.remove(dbHandle);
                if (!$assertionsDisabled && !removed) {
                    throw new AssertionError((Object)("Can't find " + dbHandle + " from dbHandleSet"));
                }
                if (dbHandleSet.size() == 0) {
                    Object foo = this.handleLockToHandleMap.remove(handleLockId);
                    if (!$assertionsDisabled && foo == null) {
                        throw new AssertionError((Object)("Can't find " + handleLockId + " from handleLockIdtoHandleMap."));
                    }
                }
            }
            this.unregisterHandle(dbHandle);
        } else if (dbHandle != null) {
            DbInternal.dbSetHandleLocker(dbHandle, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCursor(CursorImpl cursor) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            cursor.setLockerNext(this.cursorSet);
            if (this.cursorSet != null) {
                this.cursorSet.setLockerPrev(cursor);
            }
            this.cursorSet = cursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterCursor(CursorImpl cursor) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            CursorImpl prev = cursor.getLockerPrev();
            CursorImpl next = cursor.getLockerNext();
            if (prev == null) {
                this.cursorSet = next;
            } else {
                prev.setLockerNext(next);
            }
            if (next != null) {
                next.setLockerPrev(prev);
            }
            cursor.setLockerPrev(null);
            cursor.setLockerNext(null);
        }
    }

    public boolean isHandleLockTransferrable() {
        return false;
    }

    private boolean checkCursorsForClose() throws DatabaseException {
        for (CursorImpl c = this.cursorSet; c != null; c = c.getLockerNext()) {
            if (c.isClosed()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockStats collectStats(LockStats stats) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            int nReadLocks = this.readLocks == null ? 0 : this.readLocks.size();
            stats.setNReadLocks(stats.getNReadLocks() + nReadLocks);
            int nWriteLocks = this.writeInfo == null ? 0 : this.writeInfo.size();
            stats.setNWriteLocks(stats.getNWriteLocks() + nWriteLocks);
        }
        return stats;
    }

    void setOnlyAbortable() {
        this.txnState = (byte)2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkState(boolean calledByAbort) throws DatabaseException {
        boolean ok = false;
        boolean onlyAbortable = false;
        Txn txn = this;
        synchronized (txn) {
            ok = this.txnState == 0;
            onlyAbortable = this.txnState == 2;
        }
        if (!calledByAbort && onlyAbortable) {
            throw new DatabaseException("Transaction " + this.id + " must be aborted.");
        }
        if (ok || calledByAbort && onlyAbortable) {
            return;
        }
        throw new DatabaseException("Transaction " + this.id + " has been closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean isCommit) throws DatabaseException {
        Txn txn = this;
        synchronized (txn) {
            this.txnState = 1;
        }
        this.envImpl.getTxnManager().unRegisterTxn(this, isCommit);
    }

    public int getLogSize() {
        return 16;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeLong(logBuffer, this.id);
        LogUtils.writeLong(logBuffer, this.lastLoggedLsn);
    }

    public void readFromLog(ByteBuffer logBuffer) {
        this.id = LogUtils.readLong(logBuffer);
        this.lastLoggedLsn = LogUtils.readLong(logBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<txn id=\"");
        sb.append(super.toString());
        sb.append("\">");
        sb.append(DbLsn.toString(this.lastLoggedLsn));
        sb.append("</txn>");
    }

    public long getTransactionId() {
        return this.getId();
    }

    public boolean logEntryIsTransactional() {
        return true;
    }

    private void transferHandleLockToHandleSet(Long handleLockId, Set dbHandleSet) throws DatabaseException {
        int numHandles = dbHandleSet.size();
        Database[] dbHandles = new Database[numHandles];
        dbHandles = dbHandleSet.toArray(dbHandles);
        Locker[] destTxns = new Locker[numHandles];
        for (int i = 0; i < numHandles; ++i) {
            destTxns[i] = new BasicLocker(this.envImpl);
        }
        long nodeId = handleLockId;
        this.lockManager.transferMultiple(nodeId, this, destTxns);
        for (int i = 0; i < numHandles; ++i) {
            destTxns[i].addToHandleMaps(handleLockId, dbHandles[i]);
            DbInternal.dbSetHandleLocker(dbHandles[i], destTxns[i]);
        }
    }

    private void traceCommit(int numWriteLocks, int numReadLocks) {
        Logger logger = this.envImpl.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer();
            sb.append(" Commit:id = ").append(this.id);
            sb.append(" numWriteLocks=").append(numWriteLocks);
            sb.append(" numReadLocks = ").append(numReadLocks);
            Tracer.trace(Level.FINE, this.envImpl, sb.toString());
        }
    }

    int getInMemorySize() {
        return this.inMemorySize;
    }

    static {
        $assertionsDisabled = !Txn.class.desiredAssertionStatus();
        DEBUG_NAME = Txn.class.getName();
    }

    private static class DatabaseCleanupInfo {
        DatabaseImpl dbImpl;
        boolean deleteAtCommit;

        DatabaseCleanupInfo(DatabaseImpl dbImpl, boolean deleteAtCommit) {
            this.dbImpl = dbImpl;
            this.deleteAtCommit = deleteAtCommit;
        }
    }
}

