/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.txn.LatchedLockManager;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.SyncedLockManager;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TxnManager {
    static final long NULL_TXN_ID = -1L;
    private static final String DEBUG_NAME = TxnManager.class.getName();
    private LockManager lockManager;
    private EnvironmentImpl env;
    private Latch allTxnLatch;
    private Set allTxns;
    private long lastUsedTxnId;
    private int nActiveSerializable;
    private int numCommits;
    private int numAborts;

    public TxnManager(EnvironmentImpl env) throws DatabaseException {
        this.lockManager = env.getConfigManager().getBoolean(EnvironmentParams.ENV_FAIR_LATCHES) ? new LatchedLockManager(env) : new SyncedLockManager(env);
        this.env = env;
        this.allTxns = new HashSet();
        this.allTxnLatch = new Latch(DEBUG_NAME, env);
        this.numCommits = 0;
        this.numAborts = 0;
        this.lastUsedTxnId = 0L;
    }

    public synchronized void setLastTxnId(long lastId) {
        this.lastUsedTxnId = lastId;
    }

    public synchronized long getLastTxnId() {
        return this.lastUsedTxnId;
    }

    synchronized long incTxnId() {
        return ++this.lastUsedTxnId;
    }

    public Txn txnBegin(Transaction parent, TransactionConfig txnConfig) throws DatabaseException {
        if (parent != null) {
            throw new DatabaseException("Nested transactions are not supported yet.");
        }
        return new Txn(this.env, txnConfig);
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    void registerTxn(Txn txn) throws DatabaseException {
        this.allTxnLatch.acquire();
        this.allTxns.add(txn);
        this.env.getMemoryBudget().updateCacheMemoryUsage(txn.getInMemorySize());
        if (txn.isSerializableIsolation()) {
            ++this.nActiveSerializable;
        }
        this.allTxnLatch.release();
    }

    void unRegisterTxn(Txn txn, boolean isCommit) throws DatabaseException {
        this.allTxnLatch.acquire();
        this.allTxns.remove(txn);
        this.env.getMemoryBudget().updateCacheMemoryUsage(0 - txn.getInMemorySize());
        if (isCommit) {
            ++this.numCommits;
        } else {
            ++this.numAborts;
        }
        if (txn.isSerializableIsolation()) {
            --this.nActiveSerializable;
        }
        this.allTxnLatch.release();
    }

    public boolean areOtherSerializableTransactionsActive(Locker excludeLocker) {
        int exclude = excludeLocker != null && excludeLocker.isSerializableIsolation() ? 1 : 0;
        return this.nActiveSerializable - exclude > 0;
    }

    public long getFirstActiveLsn() throws DatabaseException {
        this.allTxnLatch.acquire();
        Iterator iter = this.allTxns.iterator();
        long firstActive = -1L;
        while (iter.hasNext()) {
            long txnFirstActive = ((Txn)iter.next()).getFirstActiveLsn();
            if (firstActive == -1L) {
                firstActive = txnFirstActive;
                continue;
            }
            if (txnFirstActive == -1L || DbLsn.compareTo(txnFirstActive, firstActive) >= 0) continue;
            firstActive = txnFirstActive;
        }
        this.allTxnLatch.release();
        return firstActive;
    }

    public TransactionStats txnStat(StatsConfig config) throws DatabaseException {
        TransactionStats stats = new TransactionStats();
        this.allTxnLatch.acquire();
        stats.setNCommits(this.numCommits);
        stats.setNAborts(this.numAborts);
        stats.setNActive(this.allTxns.size());
        TransactionStats.Active[] activeSet = new TransactionStats.Active[stats.getNActive()];
        stats.setActiveTxns(activeSet);
        Iterator iter = this.allTxns.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Locker txn = (Locker)iter.next();
            activeSet[i] = new TransactionStats.Active(txn.toString(), txn.getId(), 0L);
            ++i;
        }
        if (config.getClear()) {
            this.numCommits = 0;
            this.numAborts = 0;
        }
        this.allTxnLatch.release();
        return stats;
    }

    public LockStats lockStat(StatsConfig config) throws DatabaseException {
        return this.lockManager.lockStat(config);
    }
}

