/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Properties;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.loader.FileCacheLoader;

public class FileCacheLoaderConfig
extends CacheLoaderConfig.IndividualCacheLoaderConfig {
    private static final long serialVersionUID = 4626734068542420865L;
    private String location;
    @Dynamic
    private boolean checkCharacterPortability = true;

    public FileCacheLoaderConfig() {
        this.setClassName(FileCacheLoader.class.getName());
    }

    FileCacheLoaderConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.setClassName(FileCacheLoader.class.getName());
        this.populateFromBaseConfig(base);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.testImmutability("location");
        this.location = location;
    }

    public boolean isCheckCharacterPortability() {
        return this.checkCharacterPortability;
    }

    public void setCheckCharacterPortability(boolean checkCharacterPortability) {
        this.testImmutability("check.character.portability");
        this.checkCharacterPortability = checkCharacterPortability;
    }

    public void setProperties(Properties props) {
        super.setProperties(props);
        if (props != null) {
            this.setLocation(props.getProperty("location"));
            String prop = props.getProperty("check.character.portability");
            this.setCheckCharacterPortability(prop == null || Boolean.valueOf(prop) != false);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileCacheLoaderConfig && this.equalsExcludingProperties(obj)) {
            return FileCacheLoaderConfig.safeEquals(this.location, ((FileCacheLoaderConfig)obj).location);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.hashCodeExcludingProperties() + (this.location == null ? 0 : this.location.hashCode());
    }

    public FileCacheLoaderConfig clone() throws CloneNotSupportedException {
        return (FileCacheLoaderConfig)super.clone();
    }
}

