/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockStrategy;
import org.jboss.cache.lock.LockStrategyNone;
import org.jboss.cache.lock.LockStrategyReadCommitted;
import org.jboss.cache.lock.LockStrategyReadUncommitted;
import org.jboss.cache.lock.LockStrategyRepeatableRead;
import org.jboss.cache.lock.LockStrategySerializable;

public class LockStrategyFactory {
    private static IsolationLevel lockingLevel_ = IsolationLevel.REPEATABLE_READ;

    protected LockStrategyFactory() {
    }

    public static LockStrategy getLockStrategy() {
        return LockStrategyFactory.getLockStrategy(lockingLevel_);
    }

    public static LockStrategy getLockStrategy(IsolationLevel lockingLevel) {
        if (lockingLevel == null) {
            return new LockStrategyNone();
        }
        switch (lockingLevel) {
            case NONE: {
                return new LockStrategyNone();
            }
            case SERIALIZABLE: {
                return new LockStrategySerializable();
            }
            case READ_UNCOMMITTED: {
                return new LockStrategyReadUncommitted();
            }
            case READ_COMMITTED: {
                return new LockStrategyReadCommitted();
            }
        }
        return new LockStrategyRepeatableRead();
    }

    public static void setIsolationLevel(IsolationLevel level) {
        lockingLevel_ = level;
    }
}

