/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.advice.AdviceType;
import org.jboss.aop.advice.InvalidAdviceException;
import org.jboss.aop.advice.annotation.AdviceInfo;
import org.jboss.aop.advice.annotation.AdviceMethodFactory;
import org.jboss.aop.advice.annotation.Arg;
import org.jboss.aop.advice.annotation.ParameterAnnotationRule;
import org.jboss.aop.advice.annotation.assignability.AssignabilityAlgorithm;
import org.jboss.aop.advice.annotation.assignability.VariableHierarchy;

class AnnotatedParameterAdviceInfo
extends AdviceInfo {
    private ParameterAnnotationType[] paramTypes;
    private ParameterAnnotationType[] contextParamTypes;
    private AdviceType adviceType;
    private VariableHierarchy hierarchy;
    private boolean prevalidated;

    public AnnotatedParameterAdviceInfo(AdviceMethodProperties properties, AdviceType adviceType, Method method, ParameterAnnotationRule[] rules, ParameterAnnotationRule[] contextRules, int[][] mutuallyExclusive, int[][] compulsory, AdviceMethodFactory.ReturnType returnType) throws InvalidAdviceException {
        super(method, 0);
        int i;
        this.paramTypes = this.createParameterAnnotationTypes(rules);
        this.contextParamTypes = this.createParameterAnnotationTypes(contextRules);
        this.adviceType = adviceType;
        this.hierarchy = new VariableHierarchy();
        this.applyRules(properties);
        if (returnType == AdviceMethodFactory.ReturnType.VOID && method.getReturnType() != Void.TYPE) {
            throw new InvalidAdviceException("The " + (Object)((Object)adviceType) + " advice method '" + method + "' return type must be void");
        }
        for (i = 0; i < mutuallyExclusive.length; ++i) {
            int[] exclusiveParamTypes = mutuallyExclusive[i];
            int found = -1;
            for (int j = 0; j < exclusiveParamTypes.length; ++j) {
                if (!this.contextParamTypes[exclusiveParamTypes[j]].isSet()) continue;
                if (found != -1) {
                    throw new InvalidAdviceException("Mutually exclusive parameter annotations '" + (Object)((Object)this.contextParamTypes[exclusiveParamTypes[found]].rule) + "' and '" + (Object)((Object)this.contextParamTypes[exclusiveParamTypes[j]].rule) + "' found on " + (Object)((Object)adviceType) + " advice method '" + method + "'");
                }
                found = j;
            }
        }
        if (compulsory != null) {
            for (i = 0; i < compulsory.length; ++i) {
                ParameterAnnotationType precondition = this.paramTypes[compulsory[i][0]];
                if (!precondition.isSet()) continue;
                for (int j = 1; j < compulsory[i].length; ++j) {
                    if (this.paramTypes[compulsory[i][j]].isSet()) continue;
                    throw new InvalidAdviceException("Compulsory " + (Object)((Object)this.paramTypes[compulsory[i][j]].rule) + "-annotated parameter not found on " + (Object)((Object)adviceType) + " advice method '" + method + "' (this parameter is compulsory in the presence of a " + (Object)((Object)precondition.rule) + "-annotated parameter)");
                }
            }
        }
    }

    public boolean matches(AdviceMethodProperties properties, AdviceMethodFactory.ReturnType returnType) {
        if (!this.prevalidated) {
            return false;
        }
        for (ParameterAnnotationType paramType : this.paramTypes) {
            if (paramType.validate(properties)) continue;
            return false;
        }
        for (ParameterAnnotationType paramType : this.contextParamTypes) {
            if (paramType.validate(properties)) continue;
            return false;
        }
        if (this.method.getReturnType() == Void.TYPE && returnType == AdviceMethodFactory.ReturnType.NOT_VOID && properties.getJoinpointReturnType() != Void.TYPE) {
            AdviceMethodFactory.appendNewMatchingMessage(this.method, "return value cannot be void (it must match the joinpoint return type)");
            return false;
        }
        if (this.method.getReturnType() != Void.TYPE && this.method.getReturnType() != Object.class && !AssignabilityAlgorithm.FROM_VARIABLE.isAssignable(properties.getJoinpointReturnType(), this.method.getGenericReturnType(), this.hierarchy)) {
            AdviceMethodFactory.appendNewMatchingMessage(this.method, "return value cannot be assigned to type '");
            AdviceMethodFactory.appendMatchingMessage(properties.getJoinpointReturnType());
            AdviceMethodFactory.appendMatchingMessage("'");
            return false;
        }
        return true;
    }

    public void resetMatching() {
        int i;
        for (i = 0; i < this.paramTypes.length; ++i) {
            this.paramTypes[i].resetValidation();
        }
        for (i = 0; i < this.contextParamTypes.length; ++i) {
            this.contextParamTypes[i].resetValidation();
        }
    }

    public short getAssignabilityDegree(int annotationIndex, boolean isContextRule, AdviceMethodProperties properties) {
        if (isContextRule) {
            return this.contextParamTypes[annotationIndex].getAssignabilityDegree(properties);
        }
        return this.paramTypes[annotationIndex].getAssignabilityDegree(properties);
    }

    public void assignAdviceInfo(AdviceMethodProperties properties) {
        int i;
        int[] args = new int[this.parameterTypes.length];
        for (i = 0; i < this.paramTypes.length; ++i) {
            this.paramTypes[i].assignParameterInfo(args);
        }
        for (i = 0; i < this.contextParamTypes.length; ++i) {
            this.contextParamTypes[i].assignParameterInfo(args);
        }
        properties.setFoundProperties(this.method, args);
    }

    private final ParameterAnnotationType[] createParameterAnnotationTypes(ParameterAnnotationRule[] rules) {
        ParameterAnnotationType[] types = new ParameterAnnotationType[rules.length];
        for (int i = 0; i < rules.length; ++i) {
            types[i] = rules[i].isSingleEnforced() ? new SingleParameterType(rules[i]) : new MultipleParameterType(rules[i], this.method.getParameterTypes().length);
        }
        return types;
    }

    private void applyRules(AdviceMethodProperties properties) {
        Annotation[][] paramAnnotations = this.method.getParameterAnnotations();
        boolean nullifyRank = false;
        for (int i = 0; i < paramAnnotations.length; ++i) {
            ParameterAnnotationType typeFound = null;
            for (Annotation annotation : paramAnnotations[i]) {
                if (typeFound == null) {
                    typeFound = this.findAnnotationType(annotation, i);
                    continue;
                }
                if (this.findAnnotationType(annotation, i) == null) continue;
                throw new InvalidAdviceException("Parameter " + i + " of " + (Object)((Object)this.adviceType) + " advice method '" + this.method + "' contains more than one valid annotation");
            }
            if (typeFound == null) {
                if (paramAnnotations[i].length == 0) {
                    throw new InvalidAdviceException("Parameter " + i + " of " + (Object)((Object)this.adviceType) + " advice method '" + this.method + "' is not annotated\nFor interception of joinpoint " + properties.getJoinPoint() + " expecting one of annotations: " + this.getDescription(this.paramTypes) + this.getDescription(this.contextParamTypes));
                }
                AdviceMethodFactory.appendNewMatchingMessage(this.method, "parameter ");
                AdviceMethodFactory.appendMatchingMessage(i);
                AdviceMethodFactory.appendMatchingMessage("' is not annotated correctly. Expecting one of: ");
                AdviceMethodFactory.appendMatchingMessage(this.getDescription(this.paramTypes));
                AdviceMethodFactory.appendMatchingMessage(this.getDescription(this.contextParamTypes));
                this.prevalidated = false;
                return;
            }
            nullifyRank = nullifyRank || typeFound.rule.lowerRankGrade(properties);
        }
        if (nullifyRank) {
            this.rank = 0;
        }
        this.prevalidated = true;
    }

    private String getDescription(ParameterAnnotationType[] types) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 1; i < types.length; ++i) {
            buffer.append("\n          ");
            buffer.append((Object)types[i].rule);
        }
        return buffer.toString();
    }

    private final ParameterAnnotationType findAnnotationType(Annotation annotation, int i) {
        int j;
        for (j = 0; j < this.paramTypes.length; ++j) {
            if (!this.paramTypes[j].applies(annotation, i)) continue;
            return this.paramTypes[j];
        }
        for (j = 0; j < this.contextParamTypes.length; ++j) {
            if (!this.contextParamTypes[j].applies(annotation, i)) continue;
            return this.contextParamTypes[j];
        }
        return null;
    }

    class MultipleParameterType
    extends ParameterAnnotationType {
        private int[][] indexes;
        private int[] originalIndexValues;
        private int indexesLength;

        public MultipleParameterType(ParameterAnnotationRule rule, int totalArgs) {
            super(rule);
            this.indexes = new int[totalArgs][2];
            this.indexesLength = 0;
            this.originalIndexValues = new int[totalArgs];
        }

        public final void setIndex(int index, Annotation annotation) {
            if (this.indexesLength == this.indexes.length) {
                throw new RuntimeException("Unexpected call to setIndex method during processing of '" + AnnotatedParameterAdviceInfo.this.method + "'");
            }
            this.indexes[this.indexesLength][0] = index;
            this.originalIndexValues[this.indexesLength] = ((Arg)annotation).index();
            this.indexes[this.indexesLength][1] = this.originalIndexValues[this.indexesLength];
            ++this.indexesLength;
            AnnotatedParameterAdviceInfo.this.rank += this.rule.getRankGrade();
        }

        public final boolean isSet() {
            return this.indexesLength > 0;
        }

        public final boolean internalValidate(AdviceMethodProperties properties) {
            int i;
            Type[] expectedTypes = (Type[])this.rule.getAssignableFrom(properties);
            Type[] adviceTypes = AnnotatedParameterAdviceInfo.this.method.getGenericParameterTypes();
            if (this.indexesLength > 0 && expectedTypes.length == 0) {
                AdviceMethodFactory.appendNewMatchingMessage(AnnotatedParameterAdviceInfo.this.method, "joinpoint has no arguments; unexpected ");
                AdviceMethodFactory.appendMatchingMessage(this.rule);
                AdviceMethodFactory.appendMatchingMessage("-annotated parameter found");
                return false;
            }
            if (this.indexesLength > expectedTypes.length) {
                AdviceMethodFactory.appendNewMatchingMessage(AnnotatedParameterAdviceInfo.this.method, "found more ");
                AdviceMethodFactory.appendMatchingMessage(this.rule);
                AdviceMethodFactory.appendMatchingMessage("-annotated parameters than the number of arguments available on the joinpoint");
                return false;
            }
            boolean[] taken = new boolean[expectedTypes.length];
            for (i = 0; i < this.indexesLength; ++i) {
                if (this.indexes[i][1] == -1) continue;
                if (this.indexes[i][1] < 0) {
                    throw new InvalidAdviceException("Negative joinpoint parameter index found at method '" + AnnotatedParameterAdviceInfo.this.method + "'");
                }
                if (this.indexes[i][1] >= expectedTypes.length) {
                    AdviceMethodFactory.appendNewMatchingMessage(AnnotatedParameterAdviceInfo.this.method, "there is no joinpoint argument with index ");
                    AdviceMethodFactory.appendMatchingMessage(this.indexes[i][1]);
                    AdviceMethodFactory.appendMatchingMessage(", since there are ");
                    AdviceMethodFactory.appendMatchingMessage(expectedTypes.length == 0 ? "no" : Integer.valueOf(expectedTypes.length));
                    AdviceMethodFactory.appendMatchingMessage(" joinpoint arguments available");
                    return false;
                }
                if (!AssignabilityAlgorithm.VARIABLE_TARGET.isAssignable(adviceTypes[this.indexes[i][0]], expectedTypes[this.indexes[i][1]], AnnotatedParameterAdviceInfo.this.hierarchy)) {
                    AdviceMethodFactory.appendNewMatchingMessage(AnnotatedParameterAdviceInfo.this.method, "advice parameter ");
                    AdviceMethodFactory.appendMatchingMessage(this.indexes[i][0]);
                    AdviceMethodFactory.appendMatchingMessage(", of type '");
                    AdviceMethodFactory.appendMatchingMessage(adviceTypes[this.indexes[i][0]]);
                    AdviceMethodFactory.appendMatchingMessage("', cannot be assigned to the value of joinpoint argument with index ");
                    AdviceMethodFactory.appendMatchingMessage(this.indexes[i][1] + ", whose type is '");
                    AdviceMethodFactory.appendMatchingMessage(expectedTypes[this.indexes[i][1]]);
                    AdviceMethodFactory.appendMatchingMessage("'");
                    return false;
                }
                if (taken[this.indexes[i][1]]) {
                    throw new InvalidAdviceException("Joinpoint parameter index '" + this.indexes[i][0] + "' cannot be assigned to more than one " + (Object)((Object)this.rule) + "-annotated advice parameter (on " + (Object)((Object)AnnotatedParameterAdviceInfo.this.adviceType) + " advice method '" + AnnotatedParameterAdviceInfo.this.method + "')");
                }
                taken[this.indexes[i][1]] = true;
            }
            for (i = 0; i < this.indexesLength; ++i) {
                int j;
                if (this.indexes[i][1] != -1) continue;
                boolean found = false;
                for (j = 0; j < expectedTypes.length; ++j) {
                    if (adviceTypes[this.indexes[i][0]] != expectedTypes[j] || taken[j]) continue;
                    this.indexes[i][1] = j;
                    taken[j] = true;
                    found = true;
                    break;
                }
                if (found) continue;
                for (j = 0; j < expectedTypes.length; ++j) {
                    if (!AssignabilityAlgorithm.VARIABLE_TARGET.isAssignable(adviceTypes[this.indexes[i][0]], expectedTypes[j], AnnotatedParameterAdviceInfo.this.hierarchy) || taken[j]) continue;
                    this.indexes[i][1] = j;
                    taken[j] = true;
                    found = true;
                    break;
                }
                if (found) continue;
                AdviceMethodFactory.appendNewMatchingMessage(AnnotatedParameterAdviceInfo.this.method, "not found a match for argument ");
                AdviceMethodFactory.appendMatchingMessage(adviceTypes[this.indexes[i][0]]);
                AdviceMethodFactory.appendMatchingMessage("; expected one of types: ");
                for (j = 0; j < expectedTypes.length; ++j) {
                    if (taken[j]) continue;
                    AdviceMethodFactory.appendMatchingMessage(expectedTypes[j]);
                    AdviceMethodFactory.appendMatchingMessage(" ");
                }
                return false;
            }
            return true;
        }

        public void resetValidation() {
            for (int i = 0; i < this.indexesLength; ++i) {
                this.indexes[i][1] = this.originalIndexValues[i];
            }
        }

        public short getAssignabilityDegree(AdviceMethodProperties properties) {
            if (this.indexesLength == 0) {
                return -1;
            }
            Type[] expectedTypes = (Type[])this.rule.getAssignableFrom(properties);
            short level = 0;
            for (int i = 0; i < this.indexesLength; ++i) {
                level = (short)(level + AdviceInfo.DEGREE.getAssignabilityDegree(AnnotatedParameterAdviceInfo.this.method.getGenericParameterTypes()[this.indexes[i][0]], expectedTypes[this.indexes[i][1]]));
            }
            return level;
        }

        public void assignParameterInfo(int[] args) {
            for (int i = 0; i < this.indexesLength; ++i) {
                args[this.indexes[i][0]] = this.indexes[i][1];
            }
        }
    }

    class SingleParameterType
    extends ParameterAnnotationType {
        int index;

        public SingleParameterType(ParameterAnnotationRule rule) {
            super(rule);
            this.index = -1;
        }

        public final void setIndex(int parameterIndex, Annotation annotation) {
            if (this.index != -1) {
                throw new InvalidAdviceException("Found more than one occurence of '" + (Object)((Object)this.rule) + "' on parameters of " + (Object)((Object)AnnotatedParameterAdviceInfo.this.adviceType) + " advice method '" + AnnotatedParameterAdviceInfo.this.method + "'");
            }
            this.index = parameterIndex;
            AnnotatedParameterAdviceInfo.this.rank += this.rule.getRankGrade();
        }

        public final boolean isSet() {
            return this.index != -1;
        }

        public final boolean internalValidate(AdviceMethodProperties properties) {
            if (this.index != -1 && !AssignabilityAlgorithm.VARIABLE_TARGET.isAssignable(AnnotatedParameterAdviceInfo.this.method.getGenericParameterTypes()[this.index], (Type)this.rule.getAssignableFrom(properties), AnnotatedParameterAdviceInfo.this.hierarchy)) {
                AdviceMethodFactory.appendNewMatchingMessage(AnnotatedParameterAdviceInfo.this.method, this.rule);
                AdviceMethodFactory.appendMatchingMessage("-annotated parameter is not assignable from expected type ");
                AdviceMethodFactory.appendMatchingMessage(((Class)this.rule.getAssignableFrom(properties)).getName());
                return false;
            }
            return true;
        }

        public final void resetValidation() {
        }

        public final short getAssignabilityDegree(AdviceMethodProperties properties) {
            if (this.index == -1) {
                return -1;
            }
            return AdviceInfo.DEGREE.getAssignabilityDegree(AnnotatedParameterAdviceInfo.this.method.getGenericParameterTypes()[this.index], (Type)this.rule.getAssignableFrom(properties));
        }

        public final void assignParameterInfo(int[] args) {
            if (this.index != -1) {
                args[this.index] = this.rule.getProperty();
            }
        }
    }

    abstract class ParameterAnnotationType {
        ParameterAnnotationRule rule;

        public ParameterAnnotationType(ParameterAnnotationRule rule) {
            this.rule = rule;
        }

        public final boolean applies(Annotation parameterAnnotation, int parameterIndex) {
            if (parameterAnnotation.annotationType() == this.rule.getAnnotation()) {
                this.setIndex(parameterIndex, parameterAnnotation);
                return true;
            }
            return false;
        }

        public final boolean validate(AdviceMethodProperties properties) {
            if (this.rule.isMandatory() && !this.isSet()) {
                AdviceMethodFactory.appendNewMatchingMessage(AnnotatedParameterAdviceInfo.this.method, "mandatory ");
                AdviceMethodFactory.appendMatchingMessage(this.rule);
                AdviceMethodFactory.appendMatchingMessage("-annotated parameter  not found");
                return false;
            }
            return this.internalValidate(properties);
        }

        public abstract void setIndex(int var1, Annotation var2);

        public abstract boolean isSet();

        public abstract boolean internalValidate(AdviceMethodProperties var1);

        public abstract void resetValidation();

        public abstract short getAssignabilityDegree(AdviceMethodProperties var1);

        public abstract void assignParameterInfo(int[] var1);
    }
}

