/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public class LRUConfigurationTest {
    public void testXMLParsing() throws Exception {
        LRUConfiguration config = new LRUConfiguration();
        String xml = "<region name=\"/org/jboss/data\">\n<attribute name=\"maxNodes\">5000</attribute>\n<attribute name=\"timeToLiveSeconds\">1000</attribute>\n</region>";
        Element element = XmlHelper.stringToElement((String)xml);
        XmlConfigurationParser.parseEvictionPolicyConfig((Element)element, (EvictionPolicyConfig)config);
        AssertJUnit.assertEquals((int)5000, (int)config.getMaxNodes());
        AssertJUnit.assertEquals((int)1000, (int)config.getTimeToLiveSeconds());
    }

    public void testXMLParsing2() throws Exception {
        LRUConfiguration config = new LRUConfiguration();
        String xml = "<region name=\"/maxAgeTest/\">\n<attribute name=\"maxNodes\">10000</attribute>\n<attribute name=\"timeToLiveSeconds\">8</attribute>\n<attribute name=\"maxAgeSeconds\">10</attribute>\n</region>";
        Element element = XmlHelper.stringToElement((String)xml);
        XmlConfigurationParser.parseEvictionPolicyConfig((Element)element, (EvictionPolicyConfig)config);
        AssertJUnit.assertEquals((int)10000, (int)config.getMaxNodes());
        AssertJUnit.assertEquals((int)8, (int)config.getTimeToLiveSeconds());
        AssertJUnit.assertEquals((int)10, (int)config.getMaxAgeSeconds());
    }

    public void testXMLParsing3() throws Exception {
        LRUConfiguration config = new LRUConfiguration();
        String xml = "<region name=\"/maxAgeTest/\">\n<attribute name=\"maxNodes\">10000</attribute>\n<attribute name=\"maxAgeSeconds\">10</attribute>\n</region>";
        Element element = XmlHelper.stringToElement((String)xml);
        boolean caught = false;
        try {
            XmlConfigurationParser.parseEvictionPolicyConfig((Element)element, (EvictionPolicyConfig)config);
        }
        catch (ConfigurationException ce) {
            caught = true;
        }
        AssertJUnit.assertTrue((String)"Configure exception should have been caught", (boolean)caught);
        xml = "<region name=\"/maxAgeTest/\">\n<attribute name=\"timeToLiveSeconds\">8</attribute>\n<attribute name=\"maxAgeSeconds\">10</attribute>\n</region>";
        element = XmlHelper.stringToElement((String)xml);
        XmlConfigurationParser.parseEvictionPolicyConfig((Element)element, (EvictionPolicyConfig)config);
        AssertJUnit.assertEquals((int)0, (int)config.getMaxNodes());
    }
}

