/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ObjectInputStream;
import org.jboss.cache.RegionManager;
import org.jboss.cache.Version;
import org.jboss.cache.marshall.CacheMarshaller200;
import org.jboss.cache.marshall.CacheMarshaller210;
import org.jboss.cache.marshall.ObjectSerializationFactory;
import org.jboss.cache.marshall.VersionAwareMarshaller;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class VersionAwareMarshallerTest {
    public void testMarshallerSelection() {
        VersionAwareMarshaller marshaller = new VersionAwareMarshaller(new RegionManager(), false, false, "2.1.0.GA");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
        marshaller = new VersionAwareMarshaller(new RegionManager(), false, false, "2.0.0.GA");
        AssertJUnit.assertEquals(CacheMarshaller200.class, marshaller.defaultMarshaller.getClass());
        marshaller = new VersionAwareMarshaller(new RegionManager(), false, false, "1.4.0.GA");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
        marshaller = new VersionAwareMarshaller(new RegionManager(), false, false, "1.5.0.GA");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
        marshaller = new VersionAwareMarshaller(new RegionManager(), false, false, "1.3.0.GA");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
        marshaller = new VersionAwareMarshaller(new RegionManager(), false, false, "1.3.0.SP2");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
        marshaller = new VersionAwareMarshaller(new RegionManager(), false, false, "1.3.1.GA");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
        marshaller = new VersionAwareMarshaller(new RegionManager(), false, false, "1.2.4.SP2");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
        marshaller = new VersionAwareMarshaller(new RegionManager(), false, false, "1.2.3");
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.defaultMarshaller.getClass());
    }

    public void testVersionHeaderDefaultCurrent() throws Exception {
        VersionAwareMarshaller marshaller = new VersionAwareMarshaller(new RegionManager(), false, false, Version.getVersionString((short)Version.getVersionShort()));
        byte[] bytes = marshaller.objectToByteBuffer((Object)"Hello");
        ObjectInputStream in = ObjectSerializationFactory.createObjectInputStream((byte[])bytes);
        AssertJUnit.assertEquals((String)"Version header short should be '21'", (int)21, (int)in.readShort());
    }

    public void testVersionHeader200() throws Exception {
        VersionAwareMarshaller marshaller = new VersionAwareMarshaller(new RegionManager(), false, false, "2.0.0.GA");
        byte[] bytes = marshaller.objectToByteBuffer((Object)"Hello");
        ObjectInputStream in = ObjectSerializationFactory.createObjectInputStream((byte[])bytes);
        AssertJUnit.assertEquals((String)"Version header short should be '20'", (int)20, (int)in.readShort());
    }
}

