/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.optimistic.TestListener;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.testng.AssertJUnit;

public class ThreadedOptimisticCreateIfNotExistsInterceptorTest
extends AbstractOptimisticTestCase {
    protected synchronized void setTransactionsInInvocationCtx(TransactionManager mgr, CacheImpl cache) throws Exception {
        cache.getInvocationContext().setTransaction(mgr.getTransaction());
        cache.getInvocationContext().setGlobalTransaction(cache.getCurrentTransaction());
    }

    protected void resetInvocationCtx(CacheImpl cache) {
        cache.getInvocationContext().setTransaction(null);
        cache.getInvocationContext().setGlobalTransaction(null);
    }

    public void testDifferentTransactions() throws Exception {
        int i;
        int numThreads = 100;
        boolean minSleep = false;
        int maxSleep = 1000;
        TestListener listener = new TestListener();
        final CacheImpl<Object, Object> cache = this.createCacheWithListener(listener);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        interceptor.setCache(cache);
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache((CacheSPI)cache);
        interceptor.setNext((Interceptor)dummy);
        cache.setInterceptorChain((Interceptor)interceptor);
        AssertJUnit.assertEquals((int)0, (int)cache.getNumberOfNodes());
        Runnable run = new Runnable(){

            public void run() {
                try {
                    DummyTransactionManager mgr = DummyTransactionManager.getInstance();
                    mgr.begin();
                    ThreadedOptimisticCreateIfNotExistsInterceptorTest.this.setTransactionsInInvocationCtx((TransactionManager)mgr, cache);
                    SamplePojo pojo = new SamplePojo(21, "test");
                    cache.put("/one", (Object)"key1", (Object)pojo);
                    ThreadedOptimisticCreateIfNotExistsInterceptorTest.this.randomSleep(0, 1000);
                    cache.put("/one/two", (Object)"key2", (Object)pojo);
                    OptimisticTransactionEntry entry = (OptimisticTransactionEntry)cache.getTransactionTable().get(cache.getCurrentTransaction());
                    AssertJUnit.assertEquals((int)3, (int)entry.getTransactionWorkSpace().getNodes().size());
                    AssertJUnit.assertTrue((entry.getTransactionWorkSpace().getNode(Fqn.fromString((String)"/")) != null ? 1 : 0) != 0);
                    AssertJUnit.assertTrue((entry.getTransactionWorkSpace().getNode(Fqn.fromString((String)"/one")) != null ? 1 : 0) != 0);
                    AssertJUnit.assertTrue((entry.getTransactionWorkSpace().getNode(Fqn.fromString((String)"/one/two")) != null ? 1 : 0) != 0);
                    mgr.commit();
                    ThreadedOptimisticCreateIfNotExistsInterceptorTest.this.resetInvocationCtx(cache);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Thread[] threads = new Thread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            Thread t = new Thread(run);
            t.start();
            threads[i] = t;
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
        cache.stop();
    }

    public void testDifferentThreadsSameTransaction() throws Exception {
        int i;
        int numThreads = 100;
        boolean minSleep = false;
        int maxSleep = 500;
        TestListener listener = new TestListener();
        final CacheImpl<Object, Object> cache = this.createCacheWithListener(listener);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        interceptor.setCache(cache);
        MockInterceptor dummy = new MockInterceptor();
        dummy.setCache((CacheSPI)cache);
        interceptor.setNext((Interceptor)dummy);
        cache.setInterceptorChain((Interceptor)interceptor);
        final DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        final Transaction tx = mgr.getTransaction();
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    mgr.setTransaction(tx);
                    SamplePojo pojo = new SamplePojo(21, "test");
                    ThreadedOptimisticCreateIfNotExistsInterceptorTest.this.setTransactionsInInvocationCtx((TransactionManager)mgr, cache);
                    cache.put("/one", (Object)"key1", (Object)pojo);
                    OptimisticTransactionEntry entry = (OptimisticTransactionEntry)cache.getTransactionTable().get(cache.getCurrentTransaction());
                    ThreadedOptimisticCreateIfNotExistsInterceptorTest.this.randomSleep(0, 500);
                    cache.put("/one/two", (Object)"key2", (Object)pojo);
                    AssertJUnit.assertEquals((int)3, (int)entry.getTransactionWorkSpace().getNodes().size());
                    AssertJUnit.assertTrue((entry.getTransactionWorkSpace().getNode(Fqn.fromString((String)"/")) != null ? 1 : 0) != 0);
                    AssertJUnit.assertTrue((entry.getTransactionWorkSpace().getNode(Fqn.fromString((String)"/one")) != null ? 1 : 0) != 0);
                    AssertJUnit.assertTrue((entry.getTransactionWorkSpace().getNode(Fqn.fromString((String)"/one/two")) != null ? 1 : 0) != 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    ThreadedOptimisticCreateIfNotExistsInterceptorTest.this.resetInvocationCtx(cache);
                }
            }
        };
        Thread[] threads = new Thread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            Thread t = new Thread(run);
            t.start();
            threads[i] = t;
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
        mgr.commit();
        TestingUtil.sleepThread(4000L);
        cache.stop();
    }
}

