/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.util.Random;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.marshall.InactiveRegionException;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.statetransfer.StateTransferTestBase;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class StateTransferConcurrencyTest
extends StateTransferTestBase {
    protected String getReplicationVersion() {
        return "2.0.0.GA";
    }

    public void testConcurrentActivationSync() throws Exception {
        this.concurrentActivationTest(true);
    }

    public void testConcurrentActivationAsync() throws Exception {
        this.concurrentActivationTest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concurrentActivationTest(boolean sync) throws Exception {
        String[] names = new String[]{"A", "B", "C", "D", "E"};
        int count = names.length;
        CacheActivator[] activators = new CacheActivator[count];
        try {
            int i;
            Semaphore semaphore = new Semaphore(count);
            semaphore.acquire(count);
            CacheSPI[] caches = new CacheSPI[count];
            for (i = 0; i < count; ++i) {
                activators[i] = new CacheActivator(semaphore, names[i], sync, caches);
                caches[i] = activators[i].getCacheSPI();
                activators[i].start();
            }
            TestingUtil.blockUntilViewsReceived((Cache[])caches, 60000L);
            semaphore.release(count);
            TestingUtil.sleepThread(1000L);
            for (i = 0; i < count; ++i) {
                boolean acquired = semaphore.tryAcquire(60L, TimeUnit.SECONDS);
                if (acquired) continue;
                AssertJUnit.fail((String)("failed to acquire semaphore " + i));
            }
            if (!sync) {
                TestingUtil.sleepThread(2000L);
            }
            for (i = 0; i < count; ++i) {
                boolean gotUnexpectedException;
                Exception aException = activators[i].getException();
                boolean bl = gotUnexpectedException = aException != null && !(aException instanceof InactiveRegionException) && !(aException.getCause() instanceof InactiveRegionException);
                if (gotUnexpectedException) {
                    AssertJUnit.fail((String)("Activator " + names[i] + " caught an exception " + aException));
                }
                for (int j = 0; j < count; ++j) {
                    Fqn fqn = new Fqn(A_B, (Object[])new String[]{names[j]});
                    AssertJUnit.assertEquals((String)("Incorrect value for " + fqn + " on activator " + names[i]), (Object)"VALUE", (Object)activators[i].getCacheValue(fqn));
                }
            }
        }
        catch (Exception ex) {
            AssertJUnit.fail((String)ex.getLocalizedMessage());
        }
        finally {
            for (int i = 0; i < count; ++i) {
                activators[i].cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concurrentActivationTest2(boolean sync) throws Exception {
        String[] names = new String[]{"A", "B"};
        int count = names.length;
        int regionsToActivate = 15;
        int sleepTimeBetweenNodeStarts = 10000;
        StaggeredWebDeployerActivator[] activators = new StaggeredWebDeployerActivator[count];
        try {
            int i;
            Semaphore semaphore = new Semaphore(count);
            semaphore.acquire(count);
            CacheSPI[] caches = new CacheSPI[count];
            for (i = 0; i < count; ++i) {
                activators[i] = new StaggeredWebDeployerActivator(semaphore, names[i], sync, regionsToActivate);
                caches[i] = activators[i].getCacheSPI();
                semaphore.release(1);
                activators[i].start();
                TestingUtil.sleepThread(sleepTimeBetweenNodeStarts);
            }
            TestingUtil.blockUntilViewsReceived((Cache[])caches, 60000L);
            TestingUtil.sleepThread(1000L);
            for (i = 0; i < count; ++i) {
                boolean acquired = semaphore.tryAcquire(60L, TimeUnit.SECONDS);
                if (acquired) continue;
                AssertJUnit.fail((String)("failed to acquire semaphore " + i));
            }
            if (!sync) {
                TestingUtil.sleepThread(1000L);
            }
            for (i = 0; i < count; ++i) {
                boolean gotUnexpectedException;
                Exception aException = activators[i].getException();
                boolean bl = gotUnexpectedException = aException != null && !(aException instanceof InactiveRegionException) && !(aException.getCause() instanceof InactiveRegionException);
                if (gotUnexpectedException) {
                    AssertJUnit.fail((String)("Activator " + names[i] + " caught an exception " + aException));
                }
                for (int j = 0; j < regionsToActivate; ++j) {
                    Fqn fqn = Fqn.fromString((String)("/a/" + i + "/" + names[i]));
                    AssertJUnit.assertEquals((String)("Incorrect value for " + fqn + " on activator " + names[i]), (Object)"VALUE", (Object)activators[i].getCacheValue(fqn));
                }
            }
        }
        catch (Exception ex) {
            AssertJUnit.fail((String)ex.getLocalizedMessage());
        }
        finally {
            for (int i = 0; i < count; ++i) {
                activators[i].cleanup();
            }
        }
    }

    public void testConcurrentStartupActivationAsync() throws Exception {
        this.concurrentActivationTest2(false);
    }

    public void testConcurrentStartupActivationSync() throws Exception {
        this.concurrentActivationTest2(true);
    }

    public void testConcurrentUseSync() throws Exception {
        this.concurrentUseTest(true);
    }

    public void testConcurrentUseAsync() throws Exception {
        this.concurrentUseTest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concurrentUseTest(boolean sync) throws Exception {
        String[] names = new String[]{"B", "C", "D", "E"};
        int count = names.length;
        CacheStressor[] stressors = new CacheStressor[count];
        try {
            int i;
            CacheSPI<Object, Object> cacheA = this.createCache("cacheA", sync, true, false);
            CacheSPI[] caches = new CacheSPI[count + 1];
            caches[0] = cacheA;
            Semaphore semaphore = new Semaphore(count);
            semaphore.acquire(count);
            for (i = 0; i < count; ++i) {
                stressors[i] = new CacheStressor(semaphore, names[i], sync);
                caches[i + 1] = stressors[i].getCacheSPI();
                stressors[i].start();
            }
            TestingUtil.blockUntilViewsReceived((Cache[])caches, 60000L);
            for (int x = 0; x < 1; ++x) {
                int i2;
                for (i2 = 0; i2 < count; ++i2) {
                    Region r = cacheA.getRegion(Fqn.fromString((String)("/" + names[i2])), true);
                    r.registerContextClassLoader(this.getClass().getClassLoader());
                    r.deactivate();
                    System.out.println("Run " + x + "-- /" + names[i2] + " deactivated on A");
                    stressors[i2].startPuts();
                }
                semaphore.release(count);
                TestingUtil.sleepThread(1000L);
                for (CacheStressor stressor : stressors) {
                    System.out.println("Activating /" + stressor.getName() + " on A");
                    cacheA.getRegion(Fqn.fromString((String)("/" + stressor.getName())), true).activate();
                    stressor.stopPuts();
                    System.out.println("Run " + x + "-- /" + stressor.getName() + " activated on A");
                    boolean acquired = semaphore.tryAcquire(60L, TimeUnit.SECONDS);
                    if (!acquired) {
                        AssertJUnit.fail((String)("failed to acquire semaphore " + stressor.getName()));
                    }
                    TestingUtil.sleepThread(100L);
                }
                TestingUtil.sleepThread(1000L);
                for (i2 = 0; i2 < count; ++i2) {
                    if (stressors[i2].getException() == null || stressors[i2].getException() instanceof InactiveRegionException) continue;
                    AssertJUnit.fail((String)("Stressor " + names[i2] + " caught an exception " + stressors[i2].getException()));
                }
                TestingUtil.sleepThread(1000L);
                for (i2 = 0; i2 < count; ++i2) {
                    for (int j = 0; j < 10; ++j) {
                        Fqn fqn = Fqn.fromString((String)("/" + names[i2] + "/" + j));
                        AssertJUnit.assertEquals((String)("/A/" + j + " matches " + fqn), (Object)cacheA.get(fqn, (Object)"KEY"), (Object)stressors[i2].getCacheSPI().get(fqn, (Object)"KEY"));
                    }
                }
            }
            for (i = 0; i < count; ++i) {
                stressors[i].stopThread();
            }
        }
        finally {
            for (int i = 0; i < count; ++i) {
                if (stressors[i] == null) continue;
                stressors[i].cleanup();
            }
        }
    }

    public void testEvictionSeesStateTransfer() throws Exception {
        Configuration c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC, true);
        Cache cache1 = DefaultCacheFactory.getInstance().createCache(c, false);
        cache1.start();
        this.caches.put("evict1", cache1);
        cache1.put(Fqn.fromString((String)"/a/b/c"), (Object)"key", (Object)"value");
        c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC, true);
        Cache cache2 = DefaultCacheFactory.getInstance().createCache(c, false);
        cache2.start();
        this.caches.put("evict2", cache2);
        Region region = cache2.getRegion(Fqn.ROOT, false);
        int nodeEventQueueSize = region.nodeEventQueueSize();
        int i = 0;
        while (region.nodeEventQueueSize() > 0) {
            System.out.println(++i + ") Queue contains : " + region.takeLastEventNode());
        }
        AssertJUnit.assertEquals((String)"Saw the expected number of node events", (int)3, (int)nodeEventQueueSize);
    }

    public void testEvictionAfterStateTransfer() throws Exception {
        Configuration c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC, true);
        Cache cache1 = DefaultCacheFactory.getInstance().createCache(c, false);
        cache1.start();
        this.caches.put("evict1", cache1);
        for (int i = 0; i < 25000; ++i) {
            cache1.put(Fqn.fromString((String)("/base/" + i)), (Object)"key", (Object)("base" + i));
            if (i >= 5) continue;
            cache1.put(Fqn.fromString((String)("/org/jboss/test/data/" + i)), (Object)"key", (Object)("data" + i));
        }
        c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC, true);
        Cache cache2 = DefaultCacheFactory.getInstance().createCache(c, false);
        cache2.start();
        this.caches.put("evict2", cache2);
        Node parent = cache2.getRoot().getChild(Fqn.fromString((String)"/org/jboss/test/data"));
        Set children = parent.getChildren();
        AssertJUnit.assertEquals((String)"All data children transferred", (int)5, (int)children.size());
        parent = cache2.getRoot().getChild(Fqn.fromString((String)"/base"));
        children = parent.getChildren();
        AssertJUnit.assertTrue((String)"Minimum number of base children transferred", (children.size() >= 5000 ? 1 : 0) != 0);
        TestingUtil.sleepThread(2500L);
        class Putter
        extends Thread {
            Cache<Object, Object> cache = null;
            boolean stopped = false;
            Exception ex = null;

            Putter() {
            }

            public void run() {
                int i = 25000;
                while (!this.stopped) {
                    try {
                        this.cache.put(Fqn.fromString((String)("/base/" + i)), (Object)"key", (Object)("base" + i));
                        this.cache.put(Fqn.fromString((String)("/org/jboss/test/data/" + i)), (Object)"key", (Object)("data" + i));
                        ++i;
                    }
                    catch (Exception e) {
                        this.ex = e;
                    }
                }
            }
        }
        Putter p1 = new Putter();
        p1.cache = cache1;
        p1.start();
        Putter p2 = new Putter();
        p2.cache = cache2;
        p2.start();
        Random rnd = new Random();
        TestingUtil.sleepThread(rnd.nextInt(200));
        int maxCountBase = 0;
        int maxCountData = 0;
        boolean sawBaseDecrease = false;
        boolean sawDataDecrease = false;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 10000L) {
            parent = cache2.getRoot().getChild(Fqn.fromString((String)"/org/jboss/test/data"));
            children = parent.getChildren();
            if (children != null) {
                int dataCount = children.size();
                if (dataCount < maxCountData) {
                    System.out.println("data " + dataCount + " < " + maxCountData + " elapsed = " + (System.currentTimeMillis() - start));
                    sawDataDecrease = true;
                } else {
                    maxCountData = dataCount;
                }
            }
            if ((children = (parent = cache2.getRoot().getChild(Fqn.fromString((String)"/base"))).getChildren()) != null) {
                int baseCount = children.size();
                if (baseCount < maxCountBase) {
                    System.out.println("base " + baseCount + " < " + maxCountBase + " elapsed = " + (System.currentTimeMillis() - start));
                    sawBaseDecrease = true;
                } else {
                    maxCountBase = baseCount;
                }
            }
            if (sawDataDecrease && sawBaseDecrease) break;
            TestingUtil.sleepThread(50L);
        }
        p1.stopped = true;
        p2.stopped = true;
        p1.join(1000L);
        p2.join(1000L);
        AssertJUnit.assertTrue((String)"Saw data decrease", (boolean)sawDataDecrease);
        AssertJUnit.assertTrue((String)"Saw base decrease", (boolean)sawBaseDecrease);
        AssertJUnit.assertNull((String)"No exceptions in p1", (Object)p1.ex);
        AssertJUnit.assertNull((String)"No exceptions in p2", (Object)p2.ex);
        TestingUtil.sleepThread(5100L);
        parent = cache2.getRoot().getChild(Fqn.fromString((String)"/org/jboss/test/data"));
        children = parent.getChildren();
        if (children != null) {
            System.out.println(children.size());
            AssertJUnit.assertTrue((String)"Excess children evicted", (children.size() <= 5 ? 1 : 0) != 0);
        }
        if ((children = (parent = cache2.getRoot().getChild(Fqn.fromString((String)"/base"))).getChildren()) != null) {
            System.out.println(children.size());
            AssertJUnit.assertTrue((String)"Excess children evicted", (children.size() <= 25000 ? 1 : 0) != 0);
        }
        TestingUtil.sleepThread(8100L);
        parent = cache2.getRoot().getChild(Fqn.fromString((String)"/org/jboss/test/data"));
        children = parent.getChildren();
        if (children != null) {
            AssertJUnit.assertEquals((String)"All data children evicted", (int)0, (int)children.size());
        }
    }

    private class CacheStressor
    extends StateTransferTestBase.CacheUser {
        private Random random;
        private boolean putsStopped;
        private boolean stopped;

        CacheStressor(Semaphore semaphore, String name, boolean sync) throws Exception {
            super(semaphore, name, sync, true);
            this.random = new Random(System.currentTimeMillis());
            this.putsStopped = false;
            this.stopped = false;
        }

        void useCache() throws Exception {
            int factor = 0;
            int i = 0;
            Fqn fqn = null;
            boolean acquired = false;
            while (!this.stopped) {
                if (i > 0 && !(acquired = this.semaphore.tryAcquire(60L, TimeUnit.SECONDS))) {
                    throw new Exception(this.name + " cannot acquire semaphore");
                }
                while (!this.putsStopped) {
                    factor = this.random.nextInt(50);
                    fqn = Fqn.fromString((String)("/" + this.name + "/" + String.valueOf(factor % 10)));
                    Integer value = factor / 10;
                    this.cache.put(fqn, (Object)"KEY", (Object)value);
                    TestingUtil.sleepThread(factor);
                    ++i;
                }
                System.out.println(this.name + ": last put [#" + i + "] -- " + fqn + " = " + factor / 10);
                this.semaphore.release();
                while (!this.stopped && this.putsStopped) {
                    TestingUtil.sleepThread(100L);
                }
            }
        }

        public void stopPuts() {
            this.putsStopped = true;
        }

        public void startPuts() {
            this.putsStopped = false;
        }

        public void stopThread() {
            this.stopped = true;
            if (this.thread.isAlive()) {
                this.thread.interrupt();
            }
        }
    }

    private class StaggeredWebDeployerActivator
    extends StateTransferTestBase.CacheUser {
        int regionCount;

        StaggeredWebDeployerActivator(Semaphore semaphore, String name, boolean sync, int regionCount) throws Exception {
            super(semaphore, name, sync, false);
            this.regionCount = 15;
            this.regionCount = regionCount;
        }

        void useCache() throws Exception {
            for (int i = 0; i < this.regionCount; ++i) {
                StateTransferConcurrencyTest.this.createAndActivateRegion((CacheSPI<Object, Object>)this.cache, Fqn.fromString((String)("/a/" + i)));
                Fqn childFqn = Fqn.fromString((String)("/a/" + i + "/" + this.name));
                this.cache.put(childFqn, (Object)"KEY", (Object)"VALUE");
                TestingUtil.sleepThread(1000L);
            }
        }

        public Object getCacheValue(Fqn fqn) throws CacheException {
            return this.cache.get(fqn, (Object)"KEY");
        }
    }

    private class CacheActivator
    extends StateTransferTestBase.CacheUser {
        private CacheSPI[] caches;

        CacheActivator(Semaphore semaphore, String name, boolean sync, CacheSPI[] caches) throws Exception {
            super(semaphore, name, sync, false);
            this.caches = caches;
        }

        void useCache() throws Exception {
            System.out.println("---- Cache" + this.name + " = " + this.cache.getLocalAddress() + " being used");
            TestingUtil.sleepRandom(5000);
            StateTransferConcurrencyTest.this.createAndActivateRegion((CacheSPI<Object, Object>)this.cache, StateTransferTestBase.A_B);
            System.out.println(this.name + " activated region" + " " + System.currentTimeMillis());
            Fqn childFqn = new Fqn(StateTransferTestBase.A_B, (Object[])new String[]{this.name});
            this.cache.put(childFqn, (Object)"KEY", (Object)"VALUE");
        }

        private void waitUntillAllChachesActivatedRegion() {
            boolean allActive = true;
            do {
                allActive = true;
                for (CacheSPI cache : this.caches) {
                    if (cache.getRegion(StateTransferTestBase.A_B, false) != null && cache.getRegion(StateTransferTestBase.A_B, false).isActive()) continue;
                    allActive = false;
                }
                TestingUtil.sleepThread(1000L);
            } while (!allActive);
            System.out.println("---- /a/b is active on all cache instances");
        }

        public Object getCacheValue(Fqn fqn) throws CacheException {
            return this.cache.get(fqn, (Object)"KEY");
        }
    }
}

