/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.TransactionSetup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"})
public class IsolationLevelNoneTest {
    CacheImpl<String, String> cache = null;
    final Fqn FQN = Fqn.fromString((String)"/a/b/c");
    final String KEY = "key";
    final String VALUE = "value";
    TransactionManager tm;

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            this.cache.stop();
            this.cache.destroy();
            this.cache = null;
        }
    }

    public void testWithoutTransactions() throws Exception {
        CacheFactory instance = DefaultCacheFactory.getInstance();
        this.cache = (CacheImpl)instance.createCache(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.NONE);
        this.cache.start();
        this.cache.put(this.FQN, (Object)"key", (Object)"value");
        this.cache.put(this.FQN + "/d", (Object)"key", (Object)"value");
        AssertJUnit.assertTrue((boolean)this.cache.exists(this.FQN, (Object)"key"));
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
        System.out.println("cache: " + this.cache.toString(true) + ", locks: " + this.cache.printLockInfo());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testWithTransactions() throws Exception {
        CacheFactory instance = DefaultCacheFactory.getInstance();
        this.cache = (CacheImpl)instance.createCache(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.NONE);
        this.cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.cache.start();
        this.tm = this.startTransaction();
        this.cache.put(this.FQN, (Object)"key", (Object)"value");
        this.cache.put(this.FQN + "/d", (Object)"key", (Object)"value");
        AssertJUnit.assertTrue((boolean)this.cache.exists(this.FQN, (Object)"key"));
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
        System.out.println("cache: " + this.cache.toString(true) + ", locks: " + this.cache.printLockInfo());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tm.commit();
    }

    public void testWithTransactionsRepeatableRead() throws Exception {
        CacheFactory instance = DefaultCacheFactory.getInstance();
        this.cache = (CacheImpl)instance.createCache(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.cache.start();
        this.tm = this.startTransaction();
        this.cache.put(this.FQN, (Object)"key", (Object)"value");
        this.cache.put(this.FQN + "/d", (Object)"key", (Object)"value");
        AssertJUnit.assertTrue((boolean)this.cache.exists(this.FQN, (Object)"key"));
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
        System.out.println("cache: " + this.cache.toString(true) + ", locks: " + this.cache.printLockInfo());
        AssertJUnit.assertEquals((int)5, (int)this.cache.getNumberOfLocksHeld());
        this.tm.commit();
    }

    private TransactionManager startTransaction() throws SystemException, NotSupportedException {
        TransactionManager mgr = this.cache.getTransactionManager();
        mgr.begin();
        return mgr;
    }
}

