/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionSetup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"})
public class TransactionTest {
    CacheImpl<String, Comparable> cache = null;
    UserTransaction tx = null;
    Exception thread_ex;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        CacheFactory instance = DefaultCacheFactory.getInstance();
        this.cache = (CacheImpl)instance.createCache(false);
        this.cache.getConfiguration().setClusterName("test");
        this.cache.getConfiguration().setStateRetrievalTimeout(10000L);
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache.getConfiguration().setLockParentForChildInsertRemove(true);
        this.cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.tx = TransactionSetup.getUserTransaction();
        this.cache.create();
        this.cache.start();
        this.thread_ex = null;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            this.cache.stop();
            this.cache = null;
        }
        TransactionSetup.cleanup();
        if (this.tx != null) {
            try {
                this.tx.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.tx = null;
        }
    }

    public void testPutTx() throws Exception {
        this.tx.begin();
        this.cache.put("/a/b/c", (Object)"age", (Object)38);
        AssertJUnit.assertEquals((Object)this.cache.get("/a/b/c", (Object)"age"), (Object)38);
        this.cache.put("/a/b/c", (Object)"age", (Object)39);
        this.tx.commit();
        AssertJUnit.assertEquals((Object)this.cache.get("/a/b/c", (Object)"age"), (Object)39);
    }

    public void testRollbackTx1() {
        try {
            this.tx.begin();
            this.cache.put("/a/b/c", (Object)"age", (Object)38);
            this.cache.put("/a/b/c", (Object)"age", (Object)39);
            this.tx.rollback();
            AssertJUnit.assertNull((Object)this.cache.get("/a/b/c", (Object)"age"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testGetAfterRemovalRollback() throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.cache.put("/a/b", null);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        AssertJUnit.assertTrue((boolean)this.cache.exists("/a/b"));
        this.tx.begin();
        this.cache.remove("/a/b");
        AssertJUnit.assertFalse((boolean)this.cache.exists("/a/b"));
        this.tx.rollback();
        AssertJUnit.assertTrue((boolean)this.cache.exists("/a/b"));
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        Thread th = new Thread(){

            public void run() {
                try {
                    TransactionTest.this.cache.getTransactionManager().begin();
                    AssertJUnit.assertNotNull((Object)TransactionTest.this.cache.get("/a/b"));
                    TransactionTest.this.cache.getTransactionManager().rollback();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AssertJUnit.fail((String)"Caught exception");
                }
            }
        };
        th.start();
        th.join();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testRollbackTx2() {
        try {
            this.tx.begin();
            this.cache.put("/a/b/c", (Object)"age", (Object)38);
            this.cache.remove("/a/b/c", (Object)"age");
            this.tx.rollback();
            AssertJUnit.assertNull((Object)this.cache.get("/a/b/c", (Object)"age"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testRollbackTx2a() {
        try {
            System.out.println("locks " + this.cache.printLockInfo());
            this.cache.put("/a/b/c", (Object)"age", (Object)38);
            System.out.println("locks " + this.cache.printLockInfo());
            this.tx.begin();
            this.cache.remove("/a/b/c", (Object)"age");
            this.tx.rollback();
            AssertJUnit.assertEquals((Object)38, (Object)this.cache.get("/a/b/c", (Object)"age"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testRollbackTx3() {
        try {
            HashMap<String, Integer> map1 = new HashMap<String, Integer>();
            map1.put("age", 38);
            HashMap<String, Integer> map2 = new HashMap<String, Integer>();
            map2.put("age", 39);
            this.tx.begin();
            this.cache.put("/a/b/c", map1);
            this.cache.put("/a/b/c", map2);
            this.tx.rollback();
            AssertJUnit.assertNull((Object)this.cache.get("/a/b/c", (Object)"age"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testRollbackTx4() {
        try {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("age", 38);
            this.tx.begin();
            this.cache.put("/a/b/c", map);
            this.cache.remove("/a/b/c");
            this.tx.rollback();
            AssertJUnit.assertNull((Object)this.cache.get("/a/b/c", (Object)"age"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testNodeCreationRollback() {
        try {
            this.tx.begin();
            System.out.println("initial state:\n" + this.cache);
            this.cache.put("/bela/ban", (Object)"key", (Object)"value");
            System.out.println("after put():\n" + this.cache);
            this.tx.rollback();
            System.out.println("after rollback():\n" + this.cache);
            AssertJUnit.assertNull((String)"node should be not existent", (Object)this.cache.get("/bela/ban"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testNodeCreationRollback2() {
        try {
            this.cache.put("/bela/ban", null);
            this.tx.begin();
            this.cache.put("/bela/ban/michelle", null);
            this.tx.rollback();
            AssertJUnit.assertNotNull((String)"node should be not null", (Object)this.cache.get("/bela/ban"));
            AssertJUnit.assertNull((String)"node should be not existent", (Object)this.cache.get("/bela/ban/michelle"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testNodeDeletionRollback() {
        try {
            this.cache.put("/a/b/c", null);
            this.tx.begin();
            this.cache.remove("/a/b/c");
            AssertJUnit.assertNull((Object)this.cache.get("/a/b/c"));
            this.cache.remove("/a/b");
            AssertJUnit.assertNull((Object)this.cache.get("/a/b"));
            this.cache.remove("/a");
            AssertJUnit.assertNull((Object)this.cache.get("/a"));
            this.tx.rollback();
            AssertJUnit.assertNotNull((Object)this.cache.get("/a/b/c"));
            AssertJUnit.assertNotNull((Object)this.cache.get("/a/b"));
            AssertJUnit.assertNotNull((Object)this.cache.get("/a"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testNodeDeletionRollback2() throws Exception {
        this.cache.put("/a/b/c", null);
        this.cache.put("/a/b/c1", null);
        this.cache.put("/a/b/c2", null);
        this.tx.begin();
        this.cache.remove("/a");
        AssertJUnit.assertNull((Object)this.cache.get("/a/b/c"));
        AssertJUnit.assertNull((Object)this.cache.get("/a/b/c1"));
        AssertJUnit.assertNull((Object)this.cache.get("/a/b/c2"));
        AssertJUnit.assertNull((Object)this.cache.get("/a/b"));
        AssertJUnit.assertNull((Object)this.cache.get("/a"));
        Set children = this.cache.getChildrenNames("/a/b");
        AssertJUnit.assertTrue((boolean)children.isEmpty());
        children = this.cache.getChildrenNames("/a");
        AssertJUnit.assertTrue((boolean)children.isEmpty());
        this.tx.rollback();
        AssertJUnit.assertNotNull((Object)this.cache.get("/a"));
        AssertJUnit.assertNotNull((Object)this.cache.get("/a/b"));
        AssertJUnit.assertNotNull((Object)this.cache.get("/a/b/c"));
        AssertJUnit.assertNotNull((Object)this.cache.get("/a/b/c1"));
        AssertJUnit.assertNotNull((Object)this.cache.get("/a/b/c2"));
        children = this.cache.getChildrenNames("/a/b");
        AssertJUnit.assertEquals((int)3, (int)children.size());
    }

    public void testNodeCreation() throws Exception {
        this.cache.put("/a/b", null);
        this.tx.begin();
        GlobalTransaction gtx = this.cache.getCurrentTransaction();
        this.cache.put("/a/b/c", null);
        this.assertLocked(gtx, "/a", false);
        this.assertLocked(gtx, "/a/b", true);
        this.assertLocked(gtx, "/a/b/c", true);
        System.out.println("locks: " + this.cache.printLockInfo());
    }

    public void testNodeCreation2() throws Exception {
        this.tx.begin();
        GlobalTransaction gtx = this.cache.getCurrentTransaction();
        this.cache.put("/a/b/c", null);
        this.assertLocked(gtx, "/a", true);
        this.assertLocked(gtx, "/a/b", true);
        this.assertLocked(gtx, "/a/b/c", true);
        System.out.println("locks: " + this.cache.printLockInfo());
    }

    public void testNodeRemoval() {
        try {
            this.cache.put("/a/b/c", null);
            this.tx.begin();
            GlobalTransaction gtx = this.cache.getCurrentTransaction();
            this.cache.remove("/a/b/c");
            System.out.println("Locks: " + this.cache.printLockInfo());
            this.assertLocked(gtx, "/a", false);
            this.assertLocked(gtx, "/a/b", true);
            this.assertLocked(gtx, "/a/b/c", true);
            System.out.println("locks: " + this.cache.printLockInfo());
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testNodeRemoval2() {
        try {
            this.cache.put("/a/b/c", null);
            this.tx.begin();
            GlobalTransaction gtx = this.cache.getCurrentTransaction();
            this.cache.remove("/a/b");
            this.assertLocked(gtx, "/a", true);
            this.assertLocked(gtx, "/a/b", true);
            this.assertLocked(gtx, "/a/b/c", true);
            System.out.println("locks: " + this.cache.printLockInfo());
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testIntermediateNodeCreationOnWrite() throws Exception {
        this.cache.put("/a", null);
        this.tx.begin();
        this.cache.put("/a/b/c", null);
        GlobalTransaction gtx = this.cache.getCurrentTransaction();
        this.assertLocked(gtx, "/a", true);
        this.assertLocked(gtx, "/a/b", true);
        this.assertLocked(gtx, "/a/b/c", true);
        this.tx.rollback();
    }

    public void testIntermediateNodeCreationOnRead() throws Exception {
        this.cache.put("/a", null);
        this.tx.begin();
        this.cache.get("/a/b/c");
        GlobalTransaction gtx = this.cache.getCurrentTransaction();
        this.assertLocked(gtx, "/", false);
        this.assertLocked(gtx, "/a", false);
        AssertJUnit.assertNull((String)"/a/b should not exist", (Object)this.cache.peek(Fqn.fromString((String)"/a/b"), true));
        AssertJUnit.assertNull((String)"/a/b/c should not exist", (Object)this.cache.peek(Fqn.fromString((String)"/a/b/c"), true));
        this.tx.rollback();
        AssertJUnit.assertNull((String)"/a/b should not exist", (Object)this.cache.peek(Fqn.fromString((String)"/a/b"), true));
        AssertJUnit.assertNull((String)"/a/b/c should not exist", (Object)this.cache.peek(Fqn.fromString((String)"/a/b/c"), true));
    }

    public void testIntermediateNodeCreationOnRemove() throws Exception {
        this.cache.put("/a", null);
        this.tx.begin();
        this.cache.remove("/a/b/c");
        GlobalTransaction gtx = this.cache.getCurrentTransaction();
        this.assertLocked(gtx, "/", false);
        this.assertLocked(gtx, "/a", true);
        this.assertLocked(gtx, "/a/b", true);
        this.assertLocked(gtx, "/a/b/c", true);
        AssertJUnit.assertNotNull((String)"/a/b should exist", (Object)this.cache.peek(Fqn.fromString((String)"/a/b"), true));
        AssertJUnit.assertNotNull((String)"/a/b/c should exist", (Object)this.cache.peek(Fqn.fromString((String)"/a/b/c"), true));
        AssertJUnit.assertNotNull((String)"/a/b should NOT be visible", (Object)this.cache.exists(Fqn.fromString((String)"/a/b")));
        AssertJUnit.assertNotNull((String)"/a/b/c should NOT be visible", (Object)this.cache.exists(Fqn.fromString((String)"/a/b/c")));
        this.tx.rollback();
        AssertJUnit.assertNull((String)"/a/b should not exist", (Object)this.cache.peek(Fqn.fromString((String)"/a/b"), true));
        AssertJUnit.assertNull((String)"/a/b/c should not exist", (Object)this.cache.peek(Fqn.fromString((String)"/a/b/c"), true));
    }

    public void testNodeDeletionRollback3() throws Exception {
        this.cache.put("/a/b/c1", null);
        this.tx.begin();
        GlobalTransaction gtx = this.cache.getCurrentTransaction();
        this.cache.put("/a/b/c1", null);
        this.assertLocked(gtx, "/a", false);
        this.assertLocked(gtx, "/a/b", false);
        this.assertLocked(gtx, "/a/b/c1", true);
        this.cache.put("/a/b/c2", null);
        this.assertLocked(gtx, "/a/b", true);
        this.assertLocked(gtx, "/a/b/c2", true);
        this.cache.put("/a/b/c3", null);
        this.cache.put("/a/b/c1/one", null);
        this.assertLocked(gtx, "/a/b/c1", true);
        this.assertLocked(gtx, "/a/b/c1/one", true);
        this.cache.put("/a/b/c1/two", null);
        this.cache.put("/a/b/c1/one/1", null);
        this.assertLocked(gtx, "/a/b/c1", true);
        this.assertLocked(gtx, "/a/b/c1/one", true);
        this.assertLocked(gtx, "/a/b/c1/one/1", true);
        this.cache.put("/a/b/c1/two/2/3/4", null);
        this.assertLocked(gtx, "/a/b/c1", true);
        this.assertLocked(gtx, "/a/b/c1/two", true);
        this.assertLocked(gtx, "/a/b/c1/two/2", true);
        this.assertLocked(gtx, "/a/b/c1/two/2/3", true);
        this.assertLocked(gtx, "/a/b/c1/two/2/3/4", true);
        System.out.println("locks: " + this.cache.printLockInfo());
        this.cache.remove("/a/b");
        this.tx.rollback();
        AssertJUnit.assertTrue((boolean)this.cache.getChildrenNames("/a/b/c1").isEmpty());
        Set cn = this.cache.getChildrenNames("/a/b");
        AssertJUnit.assertEquals((int)1, (int)cn.size());
        AssertJUnit.assertEquals((Object)"c1", cn.iterator().next());
    }

    public void testDoubleLocks() throws Exception {
        this.tx.begin();
        GlobalTransaction gtx = this.cache.getCurrentTransaction();
        this.cache.put("/a/b/c", null);
        this.cache.put("/a/b/c", null);
        NodeSPI n = (NodeSPI)this.cache.get("/a");
        NodeLock lock = n.getLock();
        int num = lock.getReaderOwners().size();
        AssertJUnit.assertEquals((int)0, (int)num);
        this.assertLocked(gtx, "/a", true);
        n = (NodeSPI)this.cache.get("/a/b");
        lock = n.getLock();
        num = lock.getReaderOwners().size();
        AssertJUnit.assertEquals((int)0, (int)num);
        this.assertLocked(gtx, "/a/b", true);
        n = (NodeSPI)this.cache.get("/a/b/c");
        lock = n.getLock();
        num = lock.getReaderOwners().size();
        AssertJUnit.assertEquals((int)0, (int)num);
        this.assertLocked(gtx, "/a/b/c", true);
        this.tx.rollback();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    private void assertLocked(Object owner, String fqn, boolean write_locked) throws Exception {
        NodeSPI n = this.cache.peek(Fqn.fromString((String)fqn), true);
        NodeLock lock = n.getLock();
        if (owner == null) {
            owner = Thread.currentThread();
        }
        AssertJUnit.assertTrue((String)("node " + fqn + " is not locked"), (boolean)lock.isLocked());
        if (write_locked) {
            AssertJUnit.assertTrue((String)("node " + fqn + " is not write-locked" + (lock.isReadLocked() ? " but is read-locked instead!" : "!")), (boolean)lock.isWriteLocked());
        } else {
            AssertJUnit.assertTrue((String)("node " + fqn + " is not read-locked" + (lock.isWriteLocked() ? " but is write-locked instead!" : "!")), (boolean)lock.isReadLocked());
        }
        AssertJUnit.assertTrue((String)("owner " + owner + "is not owner"), (boolean)lock.isOwner(owner));
    }

    public void testConcurrentNodeAccessOnRemovalWithTx() throws Exception {
        this.cache.put("/a/b/c", null);
        this.tx.begin();
        this.cache.remove("/a/b/c");
        TransactionManager tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        Transaction t = tm.suspend();
        System.out.println(this.cache.printLockInfo());
        tm.begin();
        Transaction t2 = tm.getTransaction();
        try {
            this.cache.get("/a/b/c");
            AssertJUnit.fail((String)"Should not be able to get a hold of /a/b/c until the deleting tx completes");
        }
        catch (Exception e) {
            tm.commit();
        }
        tm.resume(t);
        this.tx.rollback();
        AssertJUnit.assertNotNull((Object)this.cache.get("/a/b/c"));
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testConcurrentNodeAccessOnRemovalWithoutTx() throws Exception {
        this.cache.put("/a/b/c", null);
        this.tx.begin();
        this.cache.remove("/a/b/c");
        Transaction t = this.cache.getTransactionManager().suspend();
        Thread th = new Thread(){

            public void run() {
                try {
                    System.out.println(TransactionTest.this.cache.printLockInfo());
                    TransactionTest.this.cache.get("/a/b/c");
                    AssertJUnit.fail((String)"Should not be able to get a hold of /a/b/c until the deleting tx completes");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        th.start();
        th.join();
        this.cache.getTransactionManager().resume(t);
        this.tx.rollback();
        AssertJUnit.assertNotNull((Object)this.cache.get("/a/b/c"));
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testRemove() throws CacheException, SystemException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException {
        this.cache.put("/a/b/c", null);
        this.cache.put("/a/b/c/1", null);
        this.cache.put("/a/b/c/2", null);
        this.cache.put("/a/b/c/3", null);
        this.cache.put("/a/b/c/3/a/b/c", null);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getLockTable().size());
        this.tx.begin();
        this.cache.remove("/a/b/c");
        System.out.println("locks held (after removing /a/b/c): \n" + this.cache.printLockInfo());
        AssertJUnit.assertEquals((int)10, (int)this.cache.getNumberOfLocksHeld());
        this.tx.commit();
        System.out.println("locks held (after committing /a/b/c): \n" + this.cache.printLockInfo());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testRemoveAndRollback() throws CacheException, SystemException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException {
        this.cache.put("/a/b/c", null);
        this.cache.put("/a/b/c/1", null);
        this.cache.put("/a/b/c/2", null);
        this.cache.put("/a/b/c/3", null);
        this.cache.put("/a/b/c/3/a/b/c", null);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getLockTable().size());
        this.tx.begin();
        System.out.println("locks held (before removing /a/b/c): \n" + this.cache.printLockInfo());
        this.cache.remove("/a/b/c");
        System.out.println("locks held (after removing /a/b/c): \n" + this.cache.printLockInfo());
        AssertJUnit.assertEquals((int)10, (int)this.cache.getNumberOfLocksHeld());
        this.tx.rollback();
        System.out.println("locks held (after rollback): \n" + this.cache.printLockInfo());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        AssertJUnit.assertTrue((boolean)this.cache.exists("/a/b/c"));
        AssertJUnit.assertTrue((boolean)this.cache.exists("/a/b/c/1"));
        AssertJUnit.assertTrue((boolean)this.cache.exists("/a/b/c/2"));
        AssertJUnit.assertTrue((boolean)this.cache.exists("/a/b/c/3"));
        AssertJUnit.assertTrue((boolean)this.cache.exists("/a/b/c/3/a"));
        AssertJUnit.assertTrue((boolean)this.cache.exists("/a/b/c/3/a/b"));
        AssertJUnit.assertTrue((boolean)this.cache.exists("/a/b/c/3/a/b/c"));
    }

    public void testRemoveKeyRollback() throws CacheException, SystemException, NotSupportedException {
        this.cache.put("/bela/ban", (Object)"name", (Object)"Bela");
        this.tx.begin();
        this.cache.remove("/bela/ban", (Object)"name");
        AssertJUnit.assertNull((Object)this.cache.get("/bela/ban", (Object)"name"));
        this.tx.rollback();
        AssertJUnit.assertEquals((Object)"Bela", (Object)this.cache.get("/bela/ban", (Object)"name"));
    }

    public void testRemoveKeyRollback2() {
        try {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("name", "Bela");
            m.put("id", 322649);
            this.cache.put("/bela/ban", m);
            this.tx.begin();
            this.cache.remove("/bela/ban", (Object)"name");
            AssertJUnit.assertNull((Object)this.cache.get("/bela/ban", (Object)"name"));
            this.tx.rollback();
            AssertJUnit.assertEquals((Object)"Bela", (Object)this.cache.get("/bela/ban", (Object)"name"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testRemoveKeyRollback3() {
        try {
            this.cache.put("/bela/ban", (Object)"name", (Object)"Bela");
            this.tx.begin();
            this.cache.put("/bela/ban", (Object)"name", (Object)"Michelle");
            this.cache.remove("/bela/ban", (Object)"name");
            AssertJUnit.assertNull((Object)this.cache.get("/bela/ban", (Object)"name"));
            this.tx.rollback();
            AssertJUnit.assertEquals((Object)"Bela", (Object)this.cache.get("/bela/ban", (Object)"name"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testDoubleRemovalOfSameData() {
        try {
            this.tx.begin();
            this.cache.put("/foo/1", (Object)"item", (Object)1);
            AssertJUnit.assertEquals((Object)this.cache.get("/foo/1", (Object)"item"), (Object)1);
            this.cache.remove("/foo/1");
            AssertJUnit.assertNull((Object)this.cache.get("/foo/1", (Object)"item"));
            this.cache.remove("/foo/1");
            AssertJUnit.assertNull((Object)this.cache.get("/foo/1", (Object)"item"));
            this.tx.rollback();
            AssertJUnit.assertFalse((boolean)this.cache.exists("/foo/1"));
            AssertJUnit.assertNull((Object)this.cache.get("/foo/1", (Object)"item"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testPutDataRollback1() {
        try {
            this.cache.put("/bela/ban", null);
            this.tx.begin();
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("name", "Bela");
            m.put("id", 322649);
            this.cache.put("/bela/ban", m);
            this.tx.rollback();
            Node n = this.cache.get("/bela/ban");
            if (n.getData() == null) {
                return;
            }
            AssertJUnit.assertEquals((String)"map should be empty", (int)0, (int)n.getData().size());
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testputDataRollback2() {
        HashMap<String, Object> m1 = new HashMap<String, Object>();
        m1.put("name", "Bela");
        m1.put("id", 322649);
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("other", "bla");
        m2.put("name", "Michelle");
        try {
            this.cache.put("/bela/ban", m1);
            this.tx.begin();
            this.cache.put("/bela/ban", m2);
            Map tmp = this.cache.get("/bela/ban").getData();
            AssertJUnit.assertEquals((int)3, (int)tmp.size());
            AssertJUnit.assertEquals((Object)"Michelle", tmp.get("name"));
            AssertJUnit.assertEquals(tmp.get("id"), (Object)322649);
            AssertJUnit.assertEquals((Object)"bla", tmp.get("other"));
            this.tx.rollback();
            tmp = this.cache.get("/bela/ban").getData();
            AssertJUnit.assertEquals((int)2, (int)tmp.size());
            AssertJUnit.assertEquals((Object)"Bela", tmp.get("name"));
            AssertJUnit.assertEquals(tmp.get("id"), (Object)322649);
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testPutRollback() {
        try {
            this.cache.put("/bela/ban", null);
            this.tx.begin();
            this.cache.put("/bela/ban", (Object)"name", (Object)"Bela");
            AssertJUnit.assertEquals((Object)"Bela", (Object)this.cache.get("/bela/ban", (Object)"name"));
            this.tx.rollback();
            AssertJUnit.assertNull((Object)this.cache.get("/bela/ban", (Object)"name"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testPutRollback2() {
        try {
            this.cache.put("/bela/ban", (Object)"name", (Object)"Bela");
            this.tx.begin();
            this.cache.put("/bela/ban", (Object)"name", (Object)"Michelle");
            AssertJUnit.assertEquals((Object)"Michelle", (Object)this.cache.get("/bela/ban", (Object)"name"));
            this.tx.rollback();
            AssertJUnit.assertEquals((Object)"Bela", (Object)this.cache.get("/bela/ban", (Object)"name"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            AssertJUnit.fail((String)t.toString());
        }
    }

    public void testSimpleRollbackTransactions() throws Exception {
        Fqn FQN = Fqn.fromString((String)"/a/b/c");
        this.tx.begin();
        this.cache.put(FQN, (Object)"entry", (Object)"commit");
        this.tx.commit();
        this.tx.begin();
        this.cache.put(FQN, (Object)"entry", (Object)"rollback");
        this.cache.remove(FQN);
        this.tx.rollback();
        AssertJUnit.assertEquals((String)"Node should keep the commited value", (Object)"commit", (Object)this.cache.get(FQN).get((Object)"entry"));
        this.tx.begin();
        this.cache.remove(FQN);
        this.cache.put(FQN, (Object)"entry", (Object)"rollback");
        this.tx.rollback();
        AssertJUnit.assertEquals((String)"Node should keep the commited value", (Object)"commit", (Object)this.cache.get(FQN).get((Object)"entry"));
    }

    private TransactionManager startTransaction() throws Exception {
        TransactionManager mgr = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        return mgr;
    }

    public void testConcurrentReadAndWriteAccess() throws Exception {
        this.cache.stop();
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache.start();
        this.cache.put("/1/2/3/4", (Object)"foo", (Object)"bar");
        class Reader
        extends Thread {
            TransactionManager thread_tx;

            public Reader() {
                super("Reader");
            }

            public void run() {
                try {
                    this.thread_tx = TransactionTest.this.startTransaction();
                    TransactionTest.log("acquiring RL");
                    TransactionTest.this.cache.get("/1/2/3", (Object)"foo");
                    TransactionTest.log("RL acquired successfully");
                    Reader.sleep(2000L);
                    TransactionTest.log("committing TX");
                    this.thread_tx.commit();
                    TransactionTest.log("committed TX");
                }
                catch (Exception e) {
                    TransactionTest.this.thread_ex = e;
                }
            }
        }
        Reader reader = new Reader();
        class Writer
        extends Thread {
            TransactionManager thread_tx;

            public Writer() {
                super("Writer");
            }

            public void run() {
                try {
                    Writer.sleep(500L);
                    this.thread_tx = TransactionTest.this.startTransaction();
                    TransactionTest.log("acquiring WL");
                    TransactionTest.this.cache.put("/1", (Object)"foo", (Object)"bar2");
                    TransactionTest.log("acquired WL successfully");
                    TransactionTest.log("committing TX");
                    this.thread_tx.commit();
                    TransactionTest.log("committed TX");
                }
                catch (Exception e) {
                    TransactionTest.this.thread_ex = e;
                }
            }
        }
        Writer writer = new Writer();
        reader.start();
        writer.start();
        reader.join();
        writer.join();
        if (this.thread_ex != null) {
            throw this.thread_ex;
        }
    }

    public void testRemoveAndGetInTx() throws Exception {
        Fqn A_B = Fqn.fromString((String)"/a/b");
        Fqn A = Fqn.fromString((String)"/a");
        this.cache.put(A_B, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)this.cache.exists(A_B));
        AssertJUnit.assertTrue((boolean)this.cache.exists(A));
        this.cache.getTransactionManager().begin();
        this.cache.remove(A);
        this.cache.get(A_B, (Object)"k");
        this.cache.getTransactionManager().commit();
    }

    public void testRemoveAndPutInTx() throws Exception {
        Fqn A_B = Fqn.fromString((String)"/a/b");
        Fqn A = Fqn.fromString((String)"/a");
        this.cache.put(A_B, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)this.cache.exists(A_B));
        AssertJUnit.assertTrue((boolean)this.cache.exists(A));
        this.cache.getTransactionManager().begin();
        this.cache.remove(A_B);
        this.cache.put(A_B, (Object)"k", (Object)"v2");
        this.cache.getTransactionManager().commit();
        AssertJUnit.assertTrue((boolean)this.cache.exists(A_B));
        AssertJUnit.assertTrue((boolean)this.cache.exists(A));
        assert (this.cache.peek(A, true, true).isValid());
        assert (this.cache.peek(A_B, true, true).isValid());
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache.get(A_B, (Object)"k"));
    }

    public void testRemoveParentAndPutInTx() throws Exception {
        Fqn A_B = Fqn.fromString((String)"/a/b");
        Fqn A = Fqn.fromString((String)"/a");
        this.cache.put(A_B, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)this.cache.exists(A_B));
        AssertJUnit.assertTrue((boolean)this.cache.exists(A));
        this.cache.getTransactionManager().begin();
        this.cache.remove(A);
        this.cache.put(A_B, (Object)"k", (Object)"v2");
        this.cache.getTransactionManager().commit();
        AssertJUnit.assertTrue((boolean)this.cache.exists(A_B));
        AssertJUnit.assertTrue((boolean)this.cache.exists(A));
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache.get(A_B, (Object)"k"));
    }

    public void testRemoveGrandParentAndPutInTx() throws Exception {
        Fqn A_B_C = Fqn.fromString((String)"/a/b/c");
        Fqn A = Fqn.fromString((String)"/a");
        this.cache.put(A_B_C, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)this.cache.exists(A_B_C));
        AssertJUnit.assertTrue((boolean)this.cache.exists(A));
        this.cache.getTransactionManager().begin();
        this.cache.remove(A);
        this.cache.put(A_B_C, (Object)"k", (Object)"v2");
        this.cache.getTransactionManager().commit();
        AssertJUnit.assertTrue((boolean)this.cache.exists(A_B_C));
        AssertJUnit.assertTrue((boolean)this.cache.exists(A));
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache.get(A_B_C, (Object)"k"));
    }

    public void testRootNodeRemoval() throws Exception {
        Fqn root = Fqn.ROOT;
        Fqn fqn = new Fqn((Object[])new Integer[]{1});
        this.tx.begin();
        this.cache.put(fqn, (Object)"k", (Object)"v");
        this.tx.commit();
        this.tx.begin();
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache.get(fqn, (Object)"k"));
        this.tx.commit();
        this.tx.begin();
        this.cache.remove(root);
        this.tx.commit();
        this.tx.begin();
        AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)"k"));
        this.cache.put(fqn, (Object)"k", (Object)"v");
        this.tx.commit();
    }

    public void testNodeAdditionAfterRemoval() throws Exception {
        Fqn fqn = Fqn.fromString((String)"/1/2/3/4");
        this.tx.begin();
        this.cache.put(fqn, (Object)"k", (Object)"v");
        this.tx.commit();
        this.tx.begin();
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache.get(fqn, (Object)"k"));
        this.tx.commit();
        this.tx.begin();
        this.cache.remove(Fqn.ROOT);
        this.tx.commit();
        this.tx.begin();
        AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)"k"));
        this.cache.put(fqn, (Object)"k", (Object)"v");
        this.tx.commit();
    }

    public void testRootNodeRemovalRollback() throws Exception {
        Fqn root = Fqn.ROOT;
        Fqn fqn = new Fqn(root, new Object[]{1});
        this.tx.begin();
        this.cache.put(fqn, (Object)"k", (Object)"v");
        this.tx.commit();
        this.tx.begin();
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache.get(fqn, (Object)"k"));
        this.tx.commit();
        this.tx.begin();
        this.cache.remove(root);
        this.tx.rollback();
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache.get(fqn, (Object)"k"));
    }

    private static void log(String msg) {
        System.out.println(Thread.currentThread().getName() + ": " + msg);
    }
}

