/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.impl.InternalHelper;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.impl.PojoInstance;

class SerializableObjectHandler {
    private Cache<Object, Object> cache;
    private PojoCacheImpl pojoCache;
    private InternalHelper internal_;
    private final Log log_ = LogFactory.getLog(SerializableObjectHandler.class);

    public SerializableObjectHandler(PojoCacheImpl cache, InternalHelper internal) {
        this.pojoCache = cache;
        this.cache = this.pojoCache.getCache();
        this.internal_ = internal;
    }

    Object get(Fqn fqn, Class clazz, PojoInstance pojoInstance) throws CacheException {
        Object obj = this.internal_.get(fqn, "__SERIALIZED__");
        return obj;
    }

    boolean put(Fqn fqn, Object obj) throws CacheException {
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("put(): obj (" + obj.getClass() + ") is non-advisable but serialize it anyway. " + "Note that if it is non-serializable we require to use JBoss Serialization."));
        }
        this.putIntoCache(fqn, obj);
        return true;
    }

    private void putIntoCache(Fqn fqn, Object obj) throws CacheException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PojoInstance pojoInstance = new PojoInstance();
        pojoInstance.set(obj);
        pojoInstance.setPojoClass(obj.getClass());
        map.put("POJOCache.PojoInstance", pojoInstance);
        map.put("__SERIALIZED__", obj);
        this.internal_.put(fqn, map);
    }

    void remove() {
    }
}

