/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.DummyEvictionPolicy;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.FIFOAlgorithm;
import org.jboss.cache.eviction.FIFOConfiguration;
import org.jboss.cache.eviction.FIFOQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.NodeEventType;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class FIFOAlgorithmTest {
    RegionManager regionManager;
    FIFOAlgorithm algo;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.algo = new FIFOAlgorithm();
        FIFOConfiguration config = new FIFOConfiguration();
        config.setMaxNodes(0);
        this.regionManager = new RegionManager();
        config.setEvictionPolicyClass(DummyEvictionPolicy.class.getName());
        this.regionManager.getRegion("/a/b", true).setEvictionPolicy((EvictionPolicyConfig)config);
    }

    public void testMaxNodes1() throws Exception {
        int i;
        String fqn;
        Region region = this.regionManager.getRegion("/a/b", true);
        FIFOConfiguration config = (FIFOConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(5);
        for (int i2 = 0; i2 < 8; ++i2) {
            Fqn fqn2 = Fqn.fromString((String)("/a/b/" + Integer.toString(i2)));
            region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        }
        this.algo.process(region);
        FIFOQueue queue = (FIFOQueue)this.algo.evictionQueue;
        AssertJUnit.assertEquals((int)5, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        Iterator it = queue.iterate();
        int index = 3;
        while (it.hasNext()) {
            NodeEntry ne = (NodeEntry)it.next();
            fqn = ne.getFqn().toString();
            AssertJUnit.assertTrue((boolean)fqn.endsWith("/" + Integer.toString(index)));
            ++index;
        }
        for (i = 3; i < 8; ++i) {
            fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.putNodeEvent(new EvictedEventNode((Fqn)fqn, NodeEventType.VISIT_NODE_EVENT));
        }
        for (i = 3; i < 5; ++i) {
            fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.putNodeEvent(new EvictedEventNode((Fqn)fqn, NodeEventType.VISIT_NODE_EVENT));
        }
        this.algo.process(region);
        AssertJUnit.assertEquals((int)5, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        it = queue.iterate();
        index = 3;
        while (it.hasNext()) {
            NodeEntry ne = (NodeEntry)it.next();
            fqn = ne.getFqn().toString();
            AssertJUnit.assertTrue((boolean)fqn.endsWith("/" + Integer.toString(index)));
            ++index;
        }
    }

    public void testMaxNodes2() throws Exception {
        Region region = this.regionManager.getRegion("/a/b", true);
        FIFOConfiguration config = (FIFOConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(50000);
        for (int i = 0; i < 50000; ++i) {
            Fqn fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.putNodeEvent(new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT));
        }
        this.algo.process(region);
        FIFOQueue queue = (FIFOQueue)this.algo.evictionQueue;
        AssertJUnit.assertEquals((int)50000, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        Iterator it = queue.iterate();
        int index = 0;
        while (it.hasNext()) {
            NodeEntry ne = (NodeEntry)it.next();
            AssertJUnit.assertTrue((boolean)ne.getFqn().toString().endsWith("/" + Integer.toString(index)));
            ++index;
        }
        for (int i = 50000; i < 60000; ++i) {
            Fqn fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.putNodeEvent(new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT));
        }
        this.algo.process(region);
        it = queue.iterate();
        index = 10000;
        while (it.hasNext()) {
            NodeEntry ne = (NodeEntry)it.next();
            AssertJUnit.assertTrue((boolean)ne.getFqn().toString().endsWith("/" + Integer.toString(index)));
            ++index;
        }
    }
}

