/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.misc.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class LFUPolicyTest {
    CacheSPI<Object, Object> cache;
    int wakeupIntervalMillis = 0;
    final String ROOT_STR = "/test";
    Throwable t1_ex;
    Throwable t2_ex;
    final long DURATION = 10000L;
    boolean isTrue;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis = this.cache.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds() * 1000;
        this.log("wakeupInterval is " + this.wakeupIntervalMillis);
        if (this.wakeupIntervalMillis < 0) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis));
        }
        this.t2_ex = null;
        this.t1_ex = null;
        this.isTrue = true;
    }

    void initCaches() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache("META-INF/local-lfu-eviction-service.xml", false);
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.stop();
    }

    public void testEviction() throws Exception {
        String rootStr = "/org/jboss/data/";
        for (int i = 0; i < 8000; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            try {
                this.cache.put(fqn, (Object)str, (Object)str);
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
            if (i % 2 == 0) continue;
            this.cache.get(fqn, (Object)str);
        }
        long period = this.wakeupIntervalMillis + 500;
        TestingUtil.sleepThread(period);
        for (int i = 0; i < 8000; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            if (i % 2 == 0) {
                AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)str));
                continue;
            }
            AssertJUnit.assertNotNull((Object)this.cache.get(fqn, (Object)str));
        }
    }

    public void testNodeVisited() {
        String rootStr = "/org/jboss/test/data/";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            try {
                this.cache.put(fqn, (Object)str, (Object)str);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        int period = this.wakeupIntervalMillis + 500;
        this.log("sleeping for " + period + "ms");
        TestingUtil.sleepThread(period);
        try {
            Fqn fqn;
            String str;
            int i;
            for (i = 0; i < 5; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)str));
            }
            for (i = 5; i < 10; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNotNull((Object)this.cache.get(fqn, (Object)str));
            }
            TestingUtil.sleepThread(period);
            for (i = 5; i < 10; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNotNull((Object)this.cache.get(fqn, (Object)str));
            }
            for (i = 5; i < 7; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                this.cache.get(fqn, (Object)str);
            }
            for (i = 10; i < 13; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                this.cache.put(fqn, (Object)str, (Object)str);
                for (int k = 0; k < 10; ++k) {
                    this.cache.get(fqn, (Object)str);
                }
            }
            TestingUtil.sleepThread(period);
            for (i = 5; i < 7; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNotNull((Object)this.cache.get(fqn, (Object)str));
            }
            for (i = 7; i < 10; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)str));
            }
            for (i = 10; i < 13; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNotNull((Object)this.cache.get(fqn, (Object)str));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to evict" + e));
        }
    }

    public void testNodeRemoved() throws Exception {
        Fqn fqn;
        String str;
        int i;
        String rootStr = "/org/jboss/data/";
        for (int i2 = 0; i2 < 5000; ++i2) {
            String str2 = rootStr + i2;
            Fqn fqn2 = Fqn.fromString((String)str2);
            try {
                this.cache.put(fqn2, (Object)str2, (Object)str2);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        int period = this.wakeupIntervalMillis + 500;
        this.log("period is " + period);
        TestingUtil.sleepThread(period);
        for (i = 0; i < 1000; ++i) {
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)str));
        }
        for (i = 1000; i < 5000; ++i) {
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            AssertJUnit.assertNotNull((Object)this.cache.get(fqn, (Object)str));
        }
        for (i = 1000; i < 5000; ++i) {
            if (i % 2 != 0) continue;
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            this.cache.removeNode(fqn);
        }
        TestingUtil.sleepThread(period);
        for (i = 1000; i < 5000; ++i) {
            if (i % 2 != 0) continue;
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            AssertJUnit.assertNull((Object)this.cache.getNode(fqn));
        }
    }

    public void testConcurrentPutAndEvict() throws Exception {
        this.cache.stop();
        this.cache.destroy();
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache.start();
        this.cache.put("/test/concurrentPutAndEvict", (Object)"value", (Object)1);
        for (int i = 0; i < 10; ++i) {
            new MyPutter("Putter" + i).start();
        }
        int counter = 0;
        do {
            ++counter;
            if (this.t1_ex != null) {
                AssertJUnit.fail((String)("Exception generated in put() " + this.t1_ex));
            }
            this.log("nodes/locks: " + this.cache.getNumberOfNodes() + "/" + this.cache.getNumberOfLocksHeld());
            TestingUtil.sleepThread(1000L);
        } while (counter <= 10);
        this.isTrue = false;
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }

    class MyPutter
    extends Thread {
        public MyPutter(String name) {
            super(name);
        }

        public void run() {
            int i = 0;
            String myName = "/test/test1/node" + this.getName();
            while (LFUPolicyTest.this.isTrue) {
                try {
                    LFUPolicyTest.this.cache.put(myName + i++, (Object)"value", (Object)i);
                    MyPutter.sleep(1L);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (LFUPolicyTest.this.t1_ex != null) continue;
                    LFUPolicyTest.this.t1_ex = e;
                }
            }
        }
    }
}

