/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.misc.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class LRUPolicyTest {
    CacheSPI<Object, Object> cache_;
    int wakeupIntervalMillis_ = 0;
    final String ROOT_STR = "/test";
    Throwable t1_ex;
    Throwable t2_ex;
    final long DURATION = 10000L;
    boolean isTrue;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis_ = this.cache_.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds() * 1000;
        this.log("wakeupInterval is " + this.wakeupIntervalMillis_);
        if (this.wakeupIntervalMillis_ < 0) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis_));
        }
        this.t2_ex = null;
        this.t1_ex = null;
        this.isTrue = true;
    }

    public void initCaches() throws Exception {
        this.cache_ = (CacheSPI)new DefaultCacheFactory().createCache("META-INF/local-lru-eviction-service.xml", false);
        this.cache_.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache_.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache_.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache_.stop();
    }

    public void testInUseEviction() throws Exception {
        Fqn fqn;
        String str;
        int i;
        String rootStr = "/org/jboss/test/data/inuse/";
        for (i = 0; i < 10; ++i) {
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            this.cache_.put(fqn, (Object)str, (Object)str);
        }
        TestingUtil.sleepThread(this.wakeupIntervalMillis_ + 500);
        System.out.println("***************************** marking as in-use");
        this.cache_.getRegionManager().getRegion(Fqn.fromString((String)(rootStr + 5)), false).markNodeCurrentlyInUse(Fqn.fromString((String)(rootStr + 5)), 0L);
        for (i = 10; i < 15; ++i) {
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            this.cache_.put(fqn, (Object)str, (Object)str);
        }
        TestingUtil.sleepThread(this.wakeupIntervalMillis_ + 500);
        for (i = 0; i < 5; ++i) {
            AssertJUnit.assertNull((Object)this.cache_.getNode(Fqn.fromString((String)(rootStr + i))));
        }
        AssertJUnit.assertNotNull((Object)this.cache_.getNode(Fqn.fromString((String)(rootStr + 5))));
        for (i = 6; i < 11; ++i) {
            AssertJUnit.assertNull((Object)this.cache_.getNode(Fqn.fromString((String)(rootStr + i))));
        }
        for (i = 11; i < 15; ++i) {
            AssertJUnit.assertNotNull((Object)this.cache_.getNode(Fqn.fromString((String)(rootStr + i))));
        }
    }

    public void testEviction() {
        String rootStr = "/org/jboss/test/data/";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            try {
                this.cache_.put(fqn, (Object)str, (Object)str);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        System.out.println(this.cache_.toString());
        TestingUtil.sleepThread(this.wakeupIntervalMillis_ + 500);
        System.out.println(this.cache_.toString());
        try {
            String val = (String)this.cache_.get(rootStr + "3", (Object)(rootStr + "3"));
            AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to get" + e));
        }
    }

    public void testNodeVisited() {
        Fqn fqn;
        String str;
        String rootStr = "/org/jboss/test/data/";
        System.out.println("REGIONS: " + this.cache_.getRegionManager().dumpRegions());
        for (int i = 0; i < 10; ++i) {
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            try {
                this.cache_.put(fqn, (Object)str, (Object)str);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        int period = this.wakeupIntervalMillis_ / 2 + 500;
        this.log("sleeping for " + period + "ms");
        TestingUtil.sleepThread(period);
        str = rootStr + "7";
        fqn = Fqn.fromString((String)str);
        try {
            this.cache_.get(fqn, (Object)str);
            System.out.println("-- sleeping for " + period + "ms");
            TestingUtil.sleepThread(period);
            this.cache_.get(fqn, (Object)str);
            System.out.println("-- sleeping for " + period + "ms");
            TestingUtil.sleepThread(period);
            String val = (String)this.cache_.get(rootStr + "3", (Object)(rootStr + "3"));
            System.out.println("-- val=" + val);
            AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
            val = (String)this.cache_.get(rootStr + "7", (Object)(rootStr + "7"));
            System.out.println("-- val=" + val);
            AssertJUnit.assertNotNull((String)"DataNode should not be empty ", (Object)val);
            System.out.println("-- sleeping for " + (this.wakeupIntervalMillis_ + 1000) + "ms");
            TestingUtil.sleepThread(this.wakeupIntervalMillis_ + 1000);
            val = (String)this.cache_.get(rootStr + "7", (Object)(rootStr + "7"));
            System.out.println("-- val=" + val);
            AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to evict" + e));
        }
    }

    public void testNodeRemoved() {
        String rootStr = "/org/jboss/test/data/";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i + "/" + i;
            Fqn fqn = Fqn.fromString((String)str);
            try {
                this.cache_.put(fqn, (Object)str, (Object)str);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        int period = this.wakeupIntervalMillis_ / 2 + 500;
        this.log("period is " + period);
        String str1 = rootStr + "7";
        Fqn fqn1 = Fqn.fromString((String)str1);
        String str2 = rootStr + "7/7";
        Fqn fqn2 = Fqn.fromString((String)str2);
        try {
            this.cache_.get(fqn1, (Object)str1);
            this.cache_.get(fqn2, (Object)str2);
            TestingUtil.sleepThread(period);
            this.cache_.get(fqn1, (Object)str1);
            this.cache_.get(fqn2, (Object)str2);
            TestingUtil.sleepThread(period);
            String val = (String)this.cache_.get(rootStr + "7/7", (Object)(rootStr + "7/7"));
            AssertJUnit.assertNotNull((String)"DataNode should not be empty ", (Object)val);
            this.cache_.removeNode(fqn1);
            TestingUtil.sleepThread(this.wakeupIntervalMillis_ + 500);
            val = (String)this.cache_.get(rootStr + "7/7", (Object)(rootStr + "7/7"));
            AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to evict" + e));
        }
    }

    public void testCompleteRemoval() throws Exception {
        String rootStr = "/test/";
        Fqn parent = Fqn.fromString((String)(rootStr + "parent"));
        this.cache_.put(parent, (Object)"key", (Object)"value");
        this.cache_.put(new Fqn(parent, (Object[])new String[]{"child"}), (Object)"key", (Object)"value");
        TestingUtil.sleepThread(this.wakeupIntervalMillis_ * 4 + 100);
        AssertJUnit.assertFalse((String)"Parent completely removed", (boolean)this.cache_.getRoot().hasChild(parent));
    }

    public void testConcurrentPutAndEvict() throws Exception {
        this.cache_.stop();
        this.cache_.destroy();
        this.cache_.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache_.create();
        this.cache_.start();
        this.cache_.put("/test/concurrentPutAndEvict", (Object)"value", (Object)1);
        for (int i = 0; i < 10; ++i) {
            new MyPutter("Putter" + i).start();
        }
        int counter = 0;
        do {
            ++counter;
            if (this.t1_ex != null) {
                AssertJUnit.fail((String)("Exception generated in put() " + this.t1_ex));
            }
            this.log("nodes/locks: " + this.cache_.getNumberOfNodes() + "/" + this.cache_.getNumberOfLocksHeld());
            TestingUtil.sleepThread(1000L);
        } while (counter <= 10);
        this.isTrue = false;
    }

    public void testForEvictionInternalError() {
        try {
            String rootStr = "/test/testdata";
            for (int i = 0; i < 10; ++i) {
                String str = rootStr + i;
                Fqn fqn = Fqn.fromString((String)str);
                try {
                    this.cache_.put(fqn, (Object)str, (Object)str);
                    continue;
                }
                catch (Exception e) {
                    AssertJUnit.fail((String)("Failed to insert data" + e));
                    e.printStackTrace();
                }
            }
            TestingUtil.sleepThread(2 * this.wakeupIntervalMillis_ + 2000);
            String val = (String)this.cache_.get(rootStr + "3", (Object)(rootStr + "3"));
            AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
            for (int i = 0; i < 10; ++i) {
                String str = rootStr + i;
                Fqn fqn = Fqn.fromString((String)str);
                try {
                    this.cache_.put(fqn, (Object)str, (Object)str);
                    continue;
                }
                catch (Exception e) {
                    AssertJUnit.fail((String)("Failed to insert data" + e));
                    e.printStackTrace();
                }
            }
            this.cache_.removeNode(Fqn.ROOT);
            TestingUtil.sleepThread(2 * this.wakeupIntervalMillis_ + 1000);
            val = (String)this.cache_.get(rootStr + "3", (Object)(rootStr + "3"));
            AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to get" + e));
        }
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }

    class MyPutter
    extends Thread {
        public MyPutter(String name) {
            super(name);
        }

        public void run() {
            int i = 0;
            String myName = "/test/test1/node" + this.getName();
            while (LRUPolicyTest.this.isTrue) {
                try {
                    LRUPolicyTest.this.cache_.put(myName + i++, (Object)"value", (Object)i);
                    MyPutter.sleep(1L);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (LRUPolicyTest.this.t1_ex != null) continue;
                    LRUPolicyTest.this.t1_ex = e;
                }
            }
        }
    }
}

