/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction.minttl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionPolicyConfigBase;
import org.jboss.cache.misc.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class MinTTLTestBase {
    protected Cache cache;
    protected Fqn region = Fqn.fromString((String)"/test-region");
    protected Fqn fqn = new Fqn(this.region, new Object[]{"a"});
    protected CountDownLatch cacheInitialisedLatch;

    protected abstract EvictionPolicyConfigBase getEvictionPolicyConfig();

    @BeforeMethod
    public void setUp() {
        this.cacheInitialisedLatch = new CountDownLatch(1);
        EvictionPolicyConfigBase cfg = this.getEvictionPolicyConfig();
        EvictionRegionConfig regionCfg = new EvictionRegionConfig();
        regionCfg.setRegionFqn(this.region);
        regionCfg.setRegionName(this.region.toString());
        regionCfg.setEvictionPolicyConfig((EvictionPolicyConfig)cfg);
        List<EvictionRegionConfig> evictionRegionConfigs = Collections.singletonList(regionCfg);
        EvictionConfig ec = new EvictionConfig();
        ec.setWakeupIntervalSeconds(1);
        ec.setEvictionRegionConfigs(evictionRegionConfigs);
        this.cache = new DefaultCacheFactory().createCache(false);
        this.cache.getConfiguration().setEvictionConfig(ec);
    }

    @AfterMethod
    public void tearDown() {
        this.cache.stop();
    }

    public void testNoMinimumTTL() {
        this.cache.start();
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.cacheInitialisedLatch.countDown();
        assert (this.cache.get(this.fqn, (Object)"k") != null) : "Node should be in the cache";
        TestingUtil.sleepThread(3000L);
        assert (this.cache.get(this.fqn, (Object)"k") == null) : "Node should have been evicted";
    }

    public void testWithMinimumTTL() {
        ((EvictionPolicyConfigBase)((EvictionRegionConfig)this.cache.getConfiguration().getEvictionConfig().getEvictionRegionConfigs().get(0)).getEvictionPolicyConfig()).setMinTimeToLiveSeconds(3);
        this.cache.start();
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.cacheInitialisedLatch.countDown();
        assert (this.cache.get(this.fqn, (Object)"k") != null) : "Node should be in the cache";
        TestingUtil.sleepThread(3000L);
        assert (this.cache.get(this.fqn, (Object)"k") != null) : "Node should still be in cache due to a minTTL of 3 secs";
        TestingUtil.sleepThread(5000L);
        assert (this.cache.get(this.fqn, (Object)"k") == null) : "Node should have been evicted";
    }
}

