/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.util.List;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.InterceptorChainTestBase;
import org.jboss.cache.interceptors.Interceptor;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class CustomInterceptorChainTest
extends InterceptorChainTestBase {
    private CacheSPI<Object, Object> cache;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration c = new Configuration();
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(c);
        this.cache.create();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache != null) {
            this.cache.stop();
            this.cache = null;
        }
    }

    public void testChainImmutability() {
        try {
            this.cache.getInterceptorChain().add(new TestInterceptor());
            AssertJUnit.fail((String)"unsupportedException should have been thrown as the chain obtained from the cache should be immutable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testInjectionAtHead() {
        List interceptors = this.cache.getInterceptorChain();
        AssertJUnit.assertEquals((String)"Expecting 6 interceptors", (int)7, (int)interceptors.size());
        this.assertInterceptorLinkage(interceptors);
        TestInterceptor x = new TestInterceptor();
        this.cache.addInterceptor((Interceptor)x, 0);
        interceptors = this.cache.getInterceptorChain();
        AssertJUnit.assertEquals((String)"Expecting 7 interceptors", (int)8, (int)interceptors.size());
        this.assertInterceptorLinkage(interceptors);
        AssertJUnit.assertEquals((Object)((Object)x), interceptors.get(0));
    }

    public void testInjectionAtTail() {
        List interceptors = this.cache.getInterceptorChain();
        AssertJUnit.assertEquals((String)"Expecting 6 interceptors", (int)7, (int)interceptors.size());
        this.assertInterceptorLinkage(interceptors);
        TestInterceptor x = new TestInterceptor();
        this.cache.addInterceptor((Interceptor)x, 6);
        interceptors = this.cache.getInterceptorChain();
        AssertJUnit.assertEquals((String)"Expecting 7 interceptors", (int)8, (int)interceptors.size());
        this.assertInterceptorLinkage(interceptors);
        AssertJUnit.assertEquals((Object)((Object)x), interceptors.get(6));
    }

    public void testInjectionInMiddle() {
        List interceptors = this.cache.getInterceptorChain();
        AssertJUnit.assertEquals((String)"Expecting 6 interceptors", (int)7, (int)interceptors.size());
        this.assertInterceptorLinkage(interceptors);
        TestInterceptor x = new TestInterceptor();
        this.cache.addInterceptor((Interceptor)x, 3);
        interceptors = this.cache.getInterceptorChain();
        AssertJUnit.assertEquals((String)"Expecting 7 interceptors", (int)8, (int)interceptors.size());
        this.assertInterceptorLinkage(interceptors);
        AssertJUnit.assertEquals((Object)((Object)x), interceptors.get(3));
    }

    public void testInjectionBeyondTail() {
        List interceptors = this.cache.getInterceptorChain();
        AssertJUnit.assertEquals((String)"Expecting 6 interceptors", (int)7, (int)interceptors.size());
        this.assertInterceptorLinkage(interceptors);
        TestInterceptor x = new TestInterceptor();
        try {
            this.cache.addInterceptor((Interceptor)x, 8);
            AssertJUnit.fail((String)"Should throw an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testRemoveAtHead() {
        List interceptors = this.cache.getInterceptorChain();
        Interceptor afterHead = (Interceptor)interceptors.get(1);
        AssertJUnit.assertEquals((String)"Expecting 6 interceptors", (int)7, (int)interceptors.size());
        this.assertInterceptorLinkage(interceptors);
        this.cache.removeInterceptor(0);
        interceptors = this.cache.getInterceptorChain();
        AssertJUnit.assertEquals((String)"Expecting 5 interceptors", (int)6, (int)interceptors.size());
        this.assertInterceptorLinkage(interceptors);
        AssertJUnit.assertEquals((Object)afterHead, interceptors.get(0));
    }

    public void testRemoveAtTail() {
        List interceptors = this.cache.getInterceptorChain();
        Interceptor beforeTail = (Interceptor)interceptors.get(4);
        AssertJUnit.assertEquals((String)"Expecting 6 interceptors", (int)7, (int)interceptors.size());
        this.assertInterceptorLinkage(interceptors);
        this.cache.removeInterceptor(5);
        interceptors = this.cache.getInterceptorChain();
        System.out.println(interceptors);
        AssertJUnit.assertEquals((String)"Expecting 5 interceptors", (int)6, (int)interceptors.size());
        this.assertInterceptorLinkage(interceptors);
        AssertJUnit.assertEquals((Object)beforeTail, interceptors.get(4));
    }

    public void testRemoveAtMiddle() {
        List interceptors = this.cache.getInterceptorChain();
        AssertJUnit.assertEquals((String)"Expecting 6 interceptors", (int)7, (int)interceptors.size());
        this.assertInterceptorLinkage(interceptors);
        this.cache.removeInterceptor(3);
        interceptors = this.cache.getInterceptorChain();
        AssertJUnit.assertEquals((String)"Expecting 5 interceptors", (int)6, (int)interceptors.size());
        this.assertInterceptorLinkage(interceptors);
    }

    public void testRemoveBeyondTail() {
        List interceptors = this.cache.getInterceptorChain();
        AssertJUnit.assertEquals((String)"Expecting 6 interceptors", (int)7, (int)interceptors.size());
        this.assertInterceptorLinkage(interceptors);
        try {
            this.cache.removeInterceptor(8);
            AssertJUnit.fail((String)"Should throw an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static class TestInterceptor
    extends Interceptor {
    }
}

