/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.Interceptor;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class InterceptorCacheReferenceTest {
    public void testPessLocking() throws Exception {
        Configuration c = new Configuration();
        c.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        Cache cache = new DefaultCacheFactory().createCache(c);
        this.assertInterceptorsHaveSameCache((CacheSPI)cache);
        cache.stop();
    }

    public void testOptLocking() throws Exception {
        Configuration c = new Configuration();
        c.setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        Cache cache = new DefaultCacheFactory().createCache(c);
        this.assertInterceptorsHaveSameCache((CacheSPI)cache);
        cache.stop();
    }

    private void assertInterceptorsHaveSameCache(CacheSPI<?, ?> c) {
        for (Interceptor i : c.getInterceptorChain()) {
            System.out.println("Testing " + i);
            AssertJUnit.assertSame(c, (Object)i.cache);
        }
    }
}

